/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input.controller;

import b100.utils.ReflectUtils;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiCrafting;
import net.minecraft.src.GuiFurnace;
import net.minecraft.src.GuiGuidebook;
import net.minecraft.src.GuiInventory;
import net.minecraft.src.GuiInventoryCreative;
import net.minecraft.src.Slot;
import net.minecraft.src.helper.Time;
import net.minecraft.src.input.InputHandler;
import net.minecraft.src.input.controller.Button;
import net.minecraft.src.input.controller.ControllerInventoryHandler;
import net.minecraft.src.input.controller.DigitalPad;
import net.minecraft.src.input.controller.IButtonListener;
import net.minecraft.src.input.controller.Joystick;

public class ControllerInput {
    public final Minecraft minecraft;
    private final Controller controller;
    public Joystick joyLeft;
    public Joystick joyRight;
    public Button buttonA;
    public Button buttonB;
    public Button buttonX;
    public Button buttonY;
    public Button buttonZL;
    public Button buttonZR;
    public Button buttonMinus;
    public Button buttonPlus;
    public Button buttonL;
    public Button buttonR;
    public DigitalPad digitalPad;
    public Button[] buttons;
    public Joystick[] joysticks;
    public double cursorX;
    public double cursorY;
    public final ControllerInventoryHandler craftingGuiHandler = new ControllerInventoryHandler(this);
    private boolean disconnected = false;

    public ControllerInput(Minecraft minecraft, Controller controller) {
        this.minecraft = minecraft;
        this.controller = controller;
        System.out.println("Controller: " + controller + " Type: " + controller.getType());
        this.setup();
    }

    public void setup() {
        Component[] c = this.controller.getComponents();
        IButtonListener defaultListener = comp -> comp.getPollData() > 0.5f;
        this.joyLeft = new Joystick("Analog Left", c[1], c[0], new Button("Left Stick", c[13], defaultListener), this.minecraft.gameSettings.controllerDeadzoneLeft);
        this.joyRight = new Joystick("Analog Right", c[3], c[2], new Button("Right Stick", c[14], defaultListener), this.minecraft.gameSettings.controllerDeadzoneRight);
        this.buttonMinus = new Button("-", this.comp("6"), defaultListener);
        this.buttonPlus = new Button("+", this.comp("7"), defaultListener);
        if (!((Boolean)this.minecraft.gameSettings.controllerSwapAB.value).booleanValue()) {
            this.buttonA = new Button("A", this.comp("0"), defaultListener);
            this.buttonB = new Button("B", this.comp("1"), defaultListener);
        } else {
            this.buttonA = new Button("A", this.comp("1"), defaultListener);
            this.buttonB = new Button("B", this.comp("0"), defaultListener);
        }
        if (!((Boolean)this.minecraft.gameSettings.controllerSwapXY.value).booleanValue()) {
            this.buttonX = new Button("X", this.comp("2"), defaultListener);
            this.buttonY = new Button("Y", this.comp("3"), defaultListener);
        } else {
            this.buttonX = new Button("X", this.comp("3"), defaultListener);
            this.buttonY = new Button("Y", this.comp("2"), defaultListener);
        }
        if (((Boolean)this.minecraft.gameSettings.controllerSwapShoulderButtons.value).booleanValue()) {
            this.buttonZL = new Button("ZL", this.comp("4"), defaultListener);
            this.buttonZR = new Button("ZR", this.comp("5"), defaultListener);
            this.buttonL = new Button("L", this.comp("z"), comp -> comp.getPollData() > 0.5f);
            this.buttonR = new Button("R", this.comp("z"), comp -> comp.getPollData() < -0.5f);
        } else {
            this.buttonL = new Button("ZL", this.comp("4"), defaultListener);
            this.buttonR = new Button("ZR", this.comp("5"), defaultListener);
            this.buttonZL = new Button("L", this.comp("z"), comp -> comp.getPollData() > 0.5f);
            this.buttonZR = new Button("R", this.comp("z"), comp -> comp.getPollData() < -0.5f);
        }
        this.digitalPad = new DigitalPad(this, this.comp("pov"));
        this.buttons = ReflectUtils.getAllObjects(ControllerInput.class, Button.class, this);
        this.joysticks = ReflectUtils.getAllObjects(ControllerInput.class, Joystick.class, this);
    }

    public void moveCursor() {
        double speed = 300.0 * Time.delta * (double)(((Float)this.minecraft.gameSettings.controllerMenuSensitivity.value).floatValue() + 0.5f);
        this.cursorX += (Math.pow(this.joyLeft.getX(), 3.0) + (double)this.joyLeft.getX()) / 2.0 * speed;
        this.cursorY += (Math.pow(this.joyLeft.getY(), 3.0) + (double)this.joyLeft.getY()) / 2.0 * speed;
        this.cursorX = Math.max(this.cursorX, 0.0);
        this.cursorY = Math.max(this.cursorY, 0.0);
        this.cursorX = Math.min(this.cursorX, (double)this.minecraft.resolution.scaledWidth);
        this.cursorY = Math.min(this.cursorY, (double)this.minecraft.resolution.scaledHeight);
    }

    public Controller getController() {
        return this.controller;
    }

    public void update() {
        int i;
        if (this.disconnected || !this.controller.poll()) {
            this.disconnected = true;
            throw new RuntimeException("Controller Disconnected!");
        }
        for (i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].update();
        }
        for (i = 0; i < this.joysticks.length; ++i) {
            this.joysticks[i].update();
        }
        this.digitalPad.update();
    }

    public Slot getSlotAtCursor(GuiContainer guiContainer) {
        return this.getSlotAt((int)this.cursorX, (int)this.cursorY, guiContainer);
    }

    public Slot getSlotAt(int x, int y, GuiContainer guiContainer) {
        for (Slot slot : guiContainer.inventorySlots.inventorySlots) {
            int mx = (int)this.cursorX;
            int my = (int)this.cursorY;
            int slotX = slot.xDisplayPosition + (this.minecraft.resolution.scaledWidth - guiContainer.xSize) / 2 - 2;
            int slotY = slot.yDisplayPosition + (this.minecraft.resolution.scaledHeight - guiContainer.ySize) / 2 - 2;
            if (mx <= slotX || my <= slotY || mx >= slotX + 20 || my >= slotY + 20) continue;
            return slot;
        }
        return null;
    }

    public void inventoryControls(GuiContainer guiContainer) {
        Slot slot = this.getSlotAt((int)this.cursorX, (int)this.cursorY, guiContainer);
        if (slot != null) {
            Slot slot3;
            if (this.digitalPad.right.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                    if (slot2.xDisplayPosition <= slot.xDisplayPosition || Math.abs(slot2.yDisplayPosition - slot.yDisplayPosition) >= 12 || slot3 != null && slot2.xDisplayPosition >= slot3.xDisplayPosition) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                        if (Math.abs(slot2.yDisplayPosition - slot.yDisplayPosition) >= 12 || slot3 != null && slot2.xDisplayPosition >= slot3.xDisplayPosition) continue;
                        slot3 = slot2;
                    }
                }
                this.snapToSlot(guiContainer, slot3);
            }
            if (this.digitalPad.left.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                    if (slot2.xDisplayPosition >= slot.xDisplayPosition || Math.abs(slot2.yDisplayPosition - slot.yDisplayPosition) >= 12 || slot3 != null && slot2.xDisplayPosition <= slot3.xDisplayPosition) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                        if (Math.abs(slot2.yDisplayPosition - slot.yDisplayPosition) >= 12 || slot3 != null && slot2.xDisplayPosition <= slot3.xDisplayPosition) continue;
                        slot3 = slot2;
                    }
                }
                this.snapToSlot(guiContainer, slot3);
            }
            if (this.digitalPad.up.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                    if (slot2.yDisplayPosition >= slot.yDisplayPosition || Math.abs(slot2.xDisplayPosition - slot.xDisplayPosition) >= 12 || slot3 != null && slot2.yDisplayPosition <= slot3.yDisplayPosition) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                        if (Math.abs(slot2.xDisplayPosition - slot.xDisplayPosition) >= 12 || slot3 != null && slot2.yDisplayPosition <= slot3.yDisplayPosition) continue;
                        slot3 = slot2;
                    }
                }
                this.snapToSlot(guiContainer, slot3);
            }
            if (this.digitalPad.down.pressedThisFrame()) {
                slot3 = null;
                for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                    if (slot2.yDisplayPosition <= slot.yDisplayPosition || Math.abs(slot2.xDisplayPosition - slot.xDisplayPosition) >= 12 || slot3 != null && slot2.yDisplayPosition >= slot3.yDisplayPosition) continue;
                    slot3 = slot2;
                }
                if (slot3 == null) {
                    for (Slot slot2 : guiContainer.inventorySlots.inventorySlots) {
                        if (Math.abs(slot2.xDisplayPosition - slot.xDisplayPosition) >= 12 || slot3 != null && slot2.yDisplayPosition >= slot3.yDisplayPosition) continue;
                        slot3 = slot2;
                    }
                }
                this.snapToSlot(guiContainer, slot3);
            }
        }
        if (this.buttonR.pressedThisFrame() && (slot = this.getSlotAtCursor(guiContainer)) != null) {
            System.out.println("SLOT: " + slot.id);
        }
        if (guiContainer instanceof GuiInventoryCreative) {
            GuiInventoryCreative inventoryCreative = (GuiInventoryCreative)guiContainer;
            if (this.buttonL.pressedThisFrame()) {
                inventoryCreative.scroll(1);
            }
            if (this.buttonR.pressedThisFrame()) {
                inventoryCreative.scroll(-1);
            }
        }
        if (guiContainer instanceof GuiGuidebook) {
            GuiGuidebook guidebook = (GuiGuidebook)guiContainer;
            if (this.buttonL.pressedThisFrame()) {
                guidebook.scroll(1);
            }
            if (this.buttonR.pressedThisFrame()) {
                guidebook.scroll(-1);
            }
        }
        if (guiContainer instanceof GuiCrafting) {
            this.craftingGuiHandler.handleCrafting((GuiCrafting)guiContainer);
        }
        if (guiContainer instanceof GuiInventory) {
            this.craftingGuiHandler.handleInventory((GuiInventory)guiContainer);
        }
        if (guiContainer instanceof GuiFurnace) {
            this.craftingGuiHandler.handleFurnace((GuiFurnace)guiContainer);
        }
        if (this.buttonA.pressedThisFrame() || this.buttonX.pressedThisFrame() || this.buttonY.pressedThisFrame()) {
            this.minecraft.sndManager.playSoundFX("random.ui_click", 1.0f, 1.0f);
        }
        if (this.buttonB.pressedThisFrame()) {
            this.minecraft.sndManager.playSoundFX("random.ui_back", 1.0f, 1.0f);
        }
    }

    public void snapToSlot(GuiContainer guiContainer, int id) {
        this.snapToSlot(guiContainer, guiContainer.inventorySlots.getSlot(id));
    }

    public void snapToSlot(GuiContainer guiContainer, Slot slot) {
        if (slot == null) {
            return;
        }
        int slotX = slot.xDisplayPosition + (this.minecraft.resolution.scaledWidth - guiContainer.xSize) / 2 - 1;
        int slotY = slot.yDisplayPosition + (this.minecraft.resolution.scaledHeight - guiContainer.ySize) / 2 - 1;
        this.cursorX = slotX + 8;
        this.cursorY = slotY + 8;
    }

    private Component comp(String id) {
        return InputHandler.getComponent(this.controller, id);
    }

    public void cancelButtonPresses() {
        for (Button button : this.buttons) {
            button.cancelButtonPress();
        }
    }
}

