/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiOptionsButton;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.StatBase;
import net.minecraft.core.achievement.stat.StatFileWriter;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiAchievements
extends GuiScreen {
    private static final int field_27126_s = AchievementList.minX * 24 - 112;
    private static final int field_27125_t = AchievementList.minY * 24 - 112;
    private static final int field_27124_u = AchievementList.maxX * 24 - 77;
    private static final int field_27123_v = AchievementList.maxY * 24 - 77;
    protected int field_27121_a = 256;
    protected int field_27119_i = 202;
    protected int field_27118_j = 0;
    protected int field_27117_l = 0;
    protected double field_27116_m;
    protected double field_27115_n;
    protected double field_27114_o;
    protected double field_27113_p;
    protected double field_27112_q;
    protected double field_27111_r;
    private int field_27122_w = 0;
    private StatFileWriter field_27120_x;
    GuiScreen parent;

    public GuiAchievements(GuiScreen parent, StatFileWriter statfilewriter) {
        this.field_27120_x = statfilewriter;
        int c = 141;
        int c1 = 141;
        this.field_27114_o = this.field_27112_q = (double)(AchievementList.OPEN_INVENTORY.x * 24 - c / 2 - 12);
        this.field_27116_m = this.field_27112_q;
        this.field_27113_p = this.field_27111_r = (double)(AchievementList.OPEN_INVENTORY.y * 24 - c1 / 2);
        this.field_27115_n = this.field_27111_r;
        this.parent = parent;
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        this.controlList.add(new GuiOptionsButton(1, this.width / 2 + 24, this.height / 2 + 74, 80, 20, I18n.getInstance().translateKey("gui.done")));
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.parent);
        }
        super.buttonPressed(guibutton);
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (this.mc.gameSettings.keyInventory.isKey(i)) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        } else {
            super.keyTyped(c, i, mouseX, mouseY);
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        if (Mouse.isButtonDown((int)0)) {
            int k = (this.width - this.field_27121_a) / 2;
            int l = (this.height - this.field_27119_i) / 2;
            int i1 = k + 8;
            int j1 = l + 17;
            if ((this.field_27122_w == 0 || this.field_27122_w == 1) && x >= i1 && x < i1 + 224 && y >= j1 && y < j1 + 155) {
                if (this.field_27122_w == 0) {
                    this.field_27122_w = 1;
                } else {
                    this.field_27114_o -= (double)(x - this.field_27118_j);
                    this.field_27113_p -= (double)(y - this.field_27117_l);
                    this.field_27112_q = this.field_27116_m = this.field_27114_o;
                    this.field_27111_r = this.field_27115_n = this.field_27113_p;
                }
                this.field_27118_j = x;
                this.field_27117_l = y;
            }
            if (this.field_27112_q < (double)field_27126_s) {
                this.field_27112_q = field_27126_s;
            }
            if (this.field_27111_r < (double)field_27125_t) {
                this.field_27111_r = field_27125_t;
            }
            if (this.field_27112_q >= (double)field_27124_u) {
                this.field_27112_q = field_27124_u - 1;
            }
            if (this.field_27111_r >= (double)field_27123_v) {
                this.field_27111_r = field_27123_v - 1;
            }
        } else {
            this.field_27122_w = 0;
        }
        this.drawDefaultBackground();
        this.func_27109_b(x, y, renderPartialTicks);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.func_27110_k();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    @Override
    public void updateScreen() {
        this.field_27116_m = this.field_27114_o;
        this.field_27115_n = this.field_27113_p;
        double d = this.field_27112_q - this.field_27114_o;
        double d1 = this.field_27111_r - this.field_27113_p;
        if (d * d + d1 * d1 < 4.0) {
            this.field_27114_o += d;
            this.field_27113_p += d1;
        } else {
            this.field_27114_o += d * 0.85;
            this.field_27113_p += d1 * 0.85;
        }
    }

    protected void func_27110_k() {
        int i = (this.width - this.field_27121_a) / 2;
        int j = (this.height - this.field_27119_i) / 2;
        this.fontRenderer.drawString("Achievements", i + 15, j + 5, 0x404040);
    }

    protected void func_27109_b(int i, int j, float f) {
        int k = MathHelper.floor_double(this.field_27116_m + (this.field_27114_o - this.field_27116_m) * (double)f);
        int l = MathHelper.floor_double(this.field_27115_n + (this.field_27113_p - this.field_27115_n) * (double)f);
        if (k < field_27126_s) {
            k = field_27126_s;
        }
        if (l < field_27125_t) {
            l = field_27125_t;
        }
        if (k >= field_27124_u) {
            k = field_27124_u - 1;
        }
        if (l >= field_27123_v) {
            l = field_27123_v - 1;
        }
        int i1 = this.mc.renderEngine.getTexture("/terrain.png");
        int j1 = this.mc.renderEngine.getTexture("/achievement/bg.png");
        int k1 = (this.width - this.field_27121_a) / 2;
        int l1 = (this.height - this.field_27119_i) / 2;
        int i2 = k1 + 16;
        int j2 = l1 + 17;
        this.zLevel = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        this.mc.renderEngine.bindTexture(i1);
        int k2 = k + 288 >> 4;
        int i3 = l + 288 >> 4;
        int j3 = (k + 288) % 16;
        int i4 = (l + 288) % 16;
        Random random = new Random();
        int l7 = 0;
        while (l7 * 16 - i4 < 155) {
            float f5 = 0.6f - (float)(i3 + l7) / 25.0f * 0.3f;
            GL11.glColor4f((float)f5, (float)f5, (float)f5, (float)1.0f);
            int i8 = 0;
            while (i8 * 16 - j3 < 224) {
                random.setSeed(1234 + k2 + i8);
                random.nextInt();
                int j8 = random.nextInt(1 + i3 + l7) + (i3 + l7) / 2;
                int k8 = Block.sand.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                if (j8 > 37 || i3 + l7 == 35) {
                    k8 = Block.bedrock.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                } else if (j8 == 22) {
                    k8 = random.nextInt(2) == 0 ? Block.oreDiamondStone.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0) : Block.oreRedstoneStone.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                } else if (j8 == 10) {
                    k8 = Block.oreIronStone.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                } else if (j8 == 8) {
                    k8 = Block.oreCoalStone.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                } else if (j8 > 4) {
                    k8 = Block.stone.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                } else if (j8 > 0) {
                    k8 = Block.dirt.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
                }
                this.drawTexturedModalRect(i2 + i8 * 16 - j3, j2 + l7 * 16 - i4, k8 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain, k8 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain, 16, 16, TextureFX.tileWidthTerrain, 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain));
                ++i8;
            }
            ++l7;
        }
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3553);
        for (int l2 = 0; l2 < AchievementList.achievementList.size(); ++l2) {
            int c;
            Achievement achievement1 = AchievementList.achievementList.get(l2);
            if (achievement1.parent == null) continue;
            int k3 = achievement1.x * 24 - k + 11 + i2;
            int j4 = achievement1.y * 24 - l + 11 + j2;
            int k4 = achievement1.parent.x * 24 - k + 11 + i2;
            int i5 = achievement1.parent.y * 24 - l + 11 + j2;
            int l5 = 0;
            boolean flag = this.field_27120_x.hasAchievementUnlocked(achievement1);
            boolean flag1 = this.field_27120_x.func_27181_b(achievement1);
            int n = c = Math.sin((double)(System.currentTimeMillis() % 600L) / 600.0 * Math.PI * 2.0) <= 0.6 ? 130 : 255;
            l5 = flag ? -9408400 : (flag1 ? 65280 + (c << 24) : -16777216);
            this.func_27100_a(k3, k4, j4, l5);
            this.func_27099_b(k4, j4, i5, l5);
        }
        StatBase achievement = null;
        ItemEntityRenderer renderitem = new ItemEntityRenderer();
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Lighting.turnOff();
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        for (int l3 = 0; l3 < AchievementList.achievementList.size(); ++l3) {
            Achievement achievement3 = AchievementList.achievementList.get(l3);
            int l4 = achievement3.x * 24 - k;
            int j5 = achievement3.y * 24 - l;
            if (l4 < -24 || j5 < -24 || l4 > 224 || j5 > 155) continue;
            if (this.field_27120_x.hasAchievementUnlocked(achievement3)) {
                float f1 = 1.0f;
                GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
            } else if (this.field_27120_x.func_27181_b(achievement3)) {
                float f2 = Math.sin((double)(System.currentTimeMillis() % 600L) / 600.0 * Math.PI * 2.0) >= 0.6 ? 0.8f : 0.6f;
                GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            } else {
                float f3 = 0.3f;
                GL11.glColor4f((float)f3, (float)f3, (float)f3, (float)1.0f);
            }
            this.mc.renderEngine.bindTexture(j1);
            int i6 = i2 + l4;
            int k6 = j2 + j5;
            if (achievement3.getSpecial()) {
                this.drawTexturedModalRect(i6 - 2, k6 - 2, 26, 202, 26, 26);
            } else {
                this.drawTexturedModalRect(i6 - 2, k6 - 2, 0, 202, 26, 26);
            }
            if (!this.field_27120_x.func_27181_b(achievement3)) {
                float f4 = 0.1f;
                GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
                renderitem.field_27004_a = false;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            renderitem.renderItemIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, new ItemStack(achievement3.itemId, 1, 0), i6 + 3, k6 + 3, 1.0f);
            GL11.glDisable((int)2896);
            if (!this.field_27120_x.func_27181_b(achievement3)) {
                renderitem.field_27004_a = true;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (i < i2 || j < j2 || i >= i2 + 224 || j >= j2 + 155 || i < i6 || i > i6 + 22 || j < k6 || j > k6 + 22) continue;
            achievement = achievement3;
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(j1);
        this.drawTexturedModalRect(k1, l1, 0, 0, this.field_27121_a, this.field_27119_i);
        GL11.glPopMatrix();
        this.zLevel = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        super.drawScreen(i, j, f);
        if (achievement != null) {
            StatBase achievement2 = achievement;
            String s = achievement2.getStatName();
            String s1 = ((Achievement)achievement2).getDescription();
            int k5 = i + 12;
            int j6 = j - 4;
            if (this.field_27120_x.func_27181_b((Achievement)achievement2)) {
                int l6 = Math.max(this.fontRenderer.getStringWidth(s), 120);
                int j7 = this.fontRenderer.func_27277_a(s1, l6);
                if (this.field_27120_x.hasAchievementUnlocked((Achievement)achievement2)) {
                    j7 += 12;
                }
                this.drawGradientRect(k5 - 3, j6 - 3, k5 + l6 + 3, j6 + j7 + 3 + 12, -1073741824, -1073741824);
                this.fontRenderer.func_27278_a(s1, k5, j6 + 12, l6, -6250336);
                if (this.field_27120_x.hasAchievementUnlocked((Achievement)achievement2)) {
                    this.fontRenderer.drawStringWithShadow(I18n.getInstance().translateKey("achievement.taken"), k5, j6 + j7 + 4, -7302913);
                }
            } else {
                int i7 = Math.max(this.fontRenderer.getStringWidth(s), 120);
                String s2 = I18n.getInstance().translateKeyAndFormat("achievement.requires", ((Achievement)achievement2).parent.getStatName());
                int k7 = this.fontRenderer.func_27277_a(s2, i7);
                this.drawGradientRect(k5 - 3, j6 - 3, k5 + i7 + 3, j6 + k7 + 12 + 3, -1073741824, -1073741824);
                this.fontRenderer.func_27278_a(s2, k5, j6 + 12, i7, -9416624);
            }
            this.fontRenderer.drawStringWithShadow(s, k5, j6, this.field_27120_x.func_27181_b((Achievement)achievement2) ? (((Achievement)achievement2).getSpecial() ? -128 : -1) : (((Achievement)achievement2).getSpecial() ? -8355776 : -8355712));
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        Lighting.turnOn();
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }
}

