/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.time.LocalDateTime;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.SavedServer;
import net.minecraft.core.net.SavedServerList;
import org.lwjgl.input.Keyboard;

public class GuiAddServer
extends GuiScreen {
    private GuiButton buttonSave;
    private GuiButton buttonCancel;
    private GuiTextField ipTextField;
    private GuiTextField serverNameTextField;
    private SavedServerList serverList;

    public GuiAddServer(GuiScreen guiscreen, SavedServerList serverList) {
        super(guiscreen);
        this.serverList = serverList;
    }

    @Override
    public void updateScreen() {
        this.ipTextField.updateCursorCounter();
        this.serverNameTextField.updateCursorCounter();
    }

    @Override
    public void initGui() {
        I18n stringtranslate = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.buttonSave = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, stringtranslate.translateKey("addServer.save"));
        this.controlList.add(this.buttonSave);
        this.buttonCancel = new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.cancel"));
        this.controlList.add(this.buttonCancel);
        this.serverNameTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 18, 200, 20, "", "");
        this.serverNameTextField.isFocused = true;
        this.serverNameTextField.setMaxStringLength(32);
        this.ipTextField = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, this.height / 4 - 10 + 50 + 18, 200, 20, "", "");
        this.ipTextField.setMaxStringLength(128);
        this.buttonSave.enabled = false;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (guibutton.id == 0) {
            String serverName = this.serverNameTextField.getText().trim();
            String ipText = this.ipTextField.getText().trim();
            if (serverName.isEmpty()) {
                serverName = "Minecraft Server";
            }
            this.serverList.servers.add(new SavedServer(serverName, ipText, LocalDateTime.now()));
            this.serverList.writeToFile();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i != 14) {
            super.keyTyped(c, i, mouseX, mouseY);
        }
        if (i == 15) {
            if (!this.ipTextField.isFocused && !this.serverNameTextField.isFocused) {
                this.serverNameTextField.isFocused = true;
            } else {
                this.ipTextField.isFocused = !this.ipTextField.isFocused;
                this.serverNameTextField.isFocused = !this.serverNameTextField.isFocused;
            }
            return;
        }
        if (i == 28 && this.buttonSave.enabled) {
            this.buttonPressed(this.buttonSave);
        }
        if (this.ipTextField.isFocused) {
            this.ipTextField.textboxKeyTyped(c, i);
        }
        if (this.serverNameTextField.isFocused) {
            this.serverNameTextField.textboxKeyTyped(c, i);
        }
        this.buttonSave.enabled = this.ipTextField.getText().length() > 0;
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.ipTextField.mouseClicked(x, y, button);
        this.serverNameTextField.mouseClicked(x, y, button);
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        I18n stringtranslate = I18n.getInstance();
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("addServer.title"), this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.serverName"), this.serverNameTextField.xPosition, this.serverNameTextField.yPosition - 14, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("addServer.ipAddress"), this.ipTextField.xPosition, this.ipTextField.yPosition - 14, 0xA0A0A0);
        this.ipTextField.drawTextBox();
        this.serverNameTextField.drawTextBox();
        super.drawScreen(x, y, renderPartialTicks);
    }
}

