/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.minecraft.client.gui.GuiLogOutputHandler;

class GuiLogFormatter
extends Formatter {
    final GuiLogOutputHandler outputHandler;

    GuiLogFormatter(GuiLogOutputHandler guilogoutputhandler) {
        this.outputHandler = guilogoutputhandler;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        Level level = record.getLevel();
        if (level == Level.FINEST) {
            sb.append("[FINEST] ");
        } else if (level == Level.FINER) {
            sb.append("[FINER] ");
        } else if (level == Level.FINE) {
            sb.append("[FINE] ");
        } else if (level == Level.INFO) {
            sb.append("[INFO] ");
        } else if (level == Level.WARNING) {
            sb.append("[WARNING] ");
        } else if (level == Level.SEVERE) {
            sb.append("[SEVERE] ");
        } else if (level == Level.SEVERE) {
            sb.append("[" + level.getLocalizedName() + "] ");
        }
        sb.append(record.getMessage());
        sb.append('\n');
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            StringWriter stringwriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringwriter));
            sb.append(stringwriter.toString());
        }
        return sb.toString();
    }
}

