/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiParticleManager;
import net.minecraft.client.input.InputType;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    final GuiScreen parentScreen;
    protected Minecraft mc;
    public int width;
    public int height;
    public List<GuiButton> controlList = new ArrayList<GuiButton>();
    public boolean allowIngameInput = false;
    protected FontRenderer fontRenderer;
    public GuiParticleManager particleRenderer;
    protected GuiButton selectedButton = null;

    public GuiScreen(GuiScreen parent) {
        this.parentScreen = parent;
    }

    public GuiScreen() {
        this(null);
    }

    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    public <E extends GuiButton> E add(E button) {
        this.controlList.add(button);
        return button;
    }

    public void drawScreen(int x, int y, float renderPartialTicks) {
        for (int i = 0; i < this.controlList.size(); ++i) {
            GuiButton guibutton = this.controlList.get(i);
            guibutton.drawButton(this.mc, x, y);
        }
    }

    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == 14) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (key == 1) {
            this.mc.displayGuiScreen(null);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0) {
            for (int l = 0; l < this.controlList.size(); ++l) {
                GuiButton guibutton = this.controlList.get(l);
                if (!guibutton.mousePressed(this.mc, x, y)) continue;
                this.selectedButton = guibutton;
                this.mc.sndManager.playSound("random.click", SoundType.GUI_SOUNDS, 1.0f, 1.0f);
                if (guibutton.listener != null) {
                    guibutton.listener.listen(guibutton);
                    continue;
                }
                this.buttonPressed(guibutton);
            }
        }
    }

    public void mouseMovedOrUp(int x, int y, int mouseButton) {
        if (this.selectedButton != null && mouseButton == 0) {
            this.buttonReleased(this.selectedButton);
            this.selectedButton.mouseReleased(x, y);
            this.selectedButton = null;
        }
    }

    protected void buttonPressed(GuiButton guibutton) {
    }

    protected void buttonReleased(GuiButton guibutton) {
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        this.particleRenderer = new GuiParticleManager(mc);
        this.mc = mc;
        this.fontRenderer = mc.fontRenderer;
        this.width = width;
        this.height = height;
        this.controlList.clear();
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.width;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
        while (Mouse.next() && this.mc.inputType != InputType.CONTROLLER) {
            if (Mouse.getEventButtonState()) {
                this.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            this.mouseMovedOrUp(mouseX, mouseY, Mouse.getEventButton());
        }
        while (Keyboard.next()) {
            int eventKey = Keyboard.getEventKey();
            char eventChar = Keyboard.getEventCharacter();
            if (eventKey == 0 && Character.isDefined(eventChar)) {
                this.keyTyped(eventChar, eventKey, mouseX, mouseY);
            }
            if (!Keyboard.getEventKeyState()) continue;
            if (eventKey == 87) {
                this.mc.fullscreenHelper.toggleFullscreen();
                return;
            }
            this.keyTyped(eventChar, eventKey, mouseX, mouseY);
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(0);
    }

    public void drawWorldBackground(int i) {
        if (this.mc.theWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.drawBackground(i);
        }
    }

    public void drawBackground(int i) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f + (float)i);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f + (float)i);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0 + i);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0 + i);
        tessellator.draw();
    }

    public void drawCursor() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/gui.png"));
        this.drawTexturedModalRect(this.mc.controllerInput.cursorX - 8.0, this.mc.controllerInput.cursorY - 8.0, 224, 0, 16, 16, 32, 32);
        GL11.glDisable((int)3042);
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void deleteWorld(boolean flag, int i) {
    }

    public void selectNextField() {
    }

    public void selectButtonUp() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition <= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(hoveredButton.yPosition - button.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.yPosition - button.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 < cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonDown() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition >= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(button.yPosition - hoveredButton.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.yPosition - hoveredButton.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 > cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonLeft() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition <= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(hoveredButton.xPosition - button.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.xPosition - button.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 < cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonRight() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition >= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(button.xPosition - hoveredButton.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.xPosition - hoveredButton.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 > cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public float getButtonDistance(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasX(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow((double)(button1.xPosition - cursorX) / 16.0, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasY(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow((double)(button1.yPosition - cursorY) / 16.0, 2.0));
    }

    public void refreshFontRenderer() {
        this.fontRenderer = this.mc.fontRenderer;
    }
}

