/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import net.minecraft.client.gui.GuiAddServer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConnecting;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.SavedServer;
import net.minecraft.core.net.SavedServerList;

public class GuiSelectServer
extends GuiScreen {
    protected String screenTitle = "Select server";
    private boolean selected = false;
    private int selectedServer;
    private SavedServerList savedServerList;
    private GuiServerSlot worldSlotContainer;
    private boolean deleting;
    public GuiButton buttonConnect;
    public GuiButton buttonDirectConnect;
    public GuiButton buttonAdd;
    public GuiButton buttonEdit;
    public GuiButton buttonDelete;
    public GuiButton buttonRefresh;
    public GuiButton buttonCancel;

    public GuiSelectServer(GuiScreen guiscreen) {
        super(guiscreen);
    }

    @Override
    public void initGui() {
        I18n stringtranslate = I18n.getInstance();
        this.screenTitle = stringtranslate.translateKey("selectServer.title");
        this.loadSavedServers();
        this.worldSlotContainer = new GuiServerSlot(this);
        this.worldSlotContainer.registerScrollButtons(this.controlList, 4, 5);
        this.initButtons();
    }

    private void loadSavedServers() {
        this.savedServerList = SavedServerList.readFromFile(new File(Global.accessor.getMinecraftDir() + "/servers.dat"));
        this.selectedServer = -1;
    }

    public void initButtons() {
        I18n trans = I18n.getInstance();
        int x1 = this.width / 2 - 154;
        int y1 = this.height - 52;
        int y2 = this.height - 28;
        this.buttonConnect = this.add(new GuiButton(0, x1, y1, 100, 20, trans.translateKey("selectServer.connect")));
        this.buttonDirectConnect = this.add(new GuiButton(0, x1 + 104, y1, 100, 20, trans.translateKey("selectServer.ip")));
        this.buttonAdd = this.add(new GuiButton(0, x1 + 208, y1, 100, 20, trans.translateKey("selectServer.add")));
        this.buttonEdit = this.add(new GuiButton(0, x1, y2, 74, 20, trans.translateKey("selectServer.edit")));
        this.buttonDelete = this.add(new GuiButton(0, x1 + 78, y2, 74, 20, trans.translateKey("selectServer.delete")));
        this.buttonRefresh = this.add(new GuiButton(0, x1 + 156, y2, 74, 20, trans.translateKey("selectServer.refresh")));
        this.buttonCancel = this.add(new GuiButton(0, x1 + 234, y2, 74, 20, trans.translateKey("gui.cancel")));
        this.setButtonsClickable(false);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button == this.buttonDelete) {
            String serverName = this.savedServerList.servers.get((int)this.selectedServer).nickname;
            if (serverName != null) {
                this.deleting = true;
                I18n trans = I18n.getInstance();
                String s1 = trans.translateKey("selectServer.deleteQuestion");
                String s2 = "'" + serverName + "' " + trans.translateKey("selectWorld.deleteWarning");
                String s3 = trans.translateKey("selectServer.delete");
                String s4 = trans.translateKey("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo(this, s1, s2, s3, s4, this.selectedServer);
                this.mc.displayGuiScreen(guiyesno);
            }
        } else if (button == this.buttonConnect) {
            this.selectServer(this.selectedServer);
        } else if (button == this.buttonDirectConnect) {
            this.mc.displayGuiScreen(new GuiMultiplayer(this));
        } else if (button == this.buttonAdd) {
            this.mc.displayGuiScreen(new GuiAddServer(this, this.savedServerList));
            this.savedServerList.writeToFile();
        } else if (button == this.buttonCancel) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (button == this.buttonRefresh) {
            this.refresh();
        } else if (button == this.buttonEdit) {
            SavedServer savedServer = this.savedServerList.servers.get(this.selectedServer);
            if (savedServer != null) {
                GuiPopup popup = new PopupBuilder(this, 220).closeOnEsc(0).closeOnClickOut(0).closeOnEnter(1).withLabel("selectServer.renameServer").withLabel("selectServer.serverName").withTextField("nameField", savedServer.nickname).withLabel("selectServer.serverIp").withTextField("ipField", savedServer.address).withButtonGroup("done", new String[]{"gui.done"}, new int[]{1}).withButtonGroup("cancel", new String[]{"gui.cancel"}, new int[]{0}).withOnCloseListener((statusCode, results) -> {
                    if (statusCode == 1) {
                        savedServer.nickname = (String)results.get("nameField");
                        savedServer.address = (String)results.get("ipField");
                        this.savedServerList.writeToFile();
                        this.refresh();
                    }
                }).build();
                this.mc.displayGuiScreen(popup);
            }
        } else {
            this.worldSlotContainer.actionPerformed(button);
        }
    }

    public void refresh() {
        this.selectedServer = -1;
        this.loadSavedServers();
        this.setButtonsClickable(false);
    }

    public void setButtonsClickable(boolean selected) {
        this.buttonConnect.enabled = selected;
        this.buttonDelete.enabled = selected;
        this.buttonEdit.enabled = selected;
    }

    public void selectServer(int i) {
        this.mc.displayGuiScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        SavedServer server = this.savedServerList.servers.get(this.selectedServer);
        server.lastPlayed = LocalDateTime.now();
        this.savedServerList.writeToFile();
        String[] as = server.address.split(":");
        this.mc.displayGuiScreen(new GuiConnecting(this.mc, as[0], as.length <= 1 ? 25565 : this.parseIntWithDefault(as[1], 25565)));
    }

    @Override
    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                this.savedServerList.servers.remove(i);
                this.savedServerList.writeToFile();
            }
            this.mc.displayGuiScreen(this);
        }
    }

    private int parseIntWithDefault(String s, int i) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception exception) {
            return i;
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.worldSlotContainer.drawScreen(x, y, renderPartialTicks);
        this.drawStringCentered(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, renderPartialTicks);
    }

    class GuiServerSlot
    extends GuiSlot {
        final GuiSelectServer guiSelectServer;

        public GuiServerSlot(GuiSelectServer parent) {
            super(parent.mc, parent.width, parent.height, 32, parent.height - 64, 36);
            this.guiSelectServer = parent;
        }

        @Override
        protected int getSize() {
            return ((GuiSelectServer)GuiSelectServer.this).savedServerList.servers.size();
        }

        @Override
        protected void elementClicked(int id, boolean flag) {
            GuiSelectServer.this.selectedServer = id;
            boolean enableButtons = GuiSelectServer.this.selectedServer >= 0 && GuiSelectServer.this.selectedServer < this.getSize();
            GuiSelectServer.this.setButtonsClickable(enableButtons);
            if (flag && enableButtons) {
                this.guiSelectServer.selectServer(id);
            }
        }

        @Override
        protected boolean isSelected(int i) {
            return i == GuiSelectServer.this.selectedServer;
        }

        @Override
        protected int getContentHeight() {
            return ((GuiSelectServer)GuiSelectServer.this).savedServerList.servers.size() * 36;
        }

        @Override
        protected void drawBackground() {
            this.guiSelectServer.drawDefaultBackground();
        }

        @Override
        protected void drawSlot(int i, int j, int k, int l, Tessellator tessellator) {
            SavedServer server = ((GuiSelectServer)GuiSelectServer.this).savedServerList.servers.get(i);
            String line1 = server.nickname;
            String line2 = server.address;
            String line3 = "Last played: " + server.lastPlayed.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
            this.guiSelectServer.drawString(this.guiSelectServer.fontRenderer, line1, j + 2, k + 1, 0xFFFFFF);
            this.guiSelectServer.drawString(this.guiSelectServer.fontRenderer, line2, j + 2, k + 12, 0x808080);
            this.guiSelectServer.drawString(this.guiSelectServer.fontRenderer, line3, j + 2, k + 12 + 10, 0x808080);
        }
    }
}

