/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Date;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveFile;

class GuiWorldSlot
extends GuiSlot {
    final GuiSelectWorld parentWorldGui;

    public GuiWorldSlot(GuiSelectWorld guiselectworld) {
        super(guiselectworld.mc, guiselectworld.width, guiselectworld.height, 32, guiselectworld.height - 64, 36);
        this.parentWorldGui = guiselectworld;
    }

    @Override
    protected int getSize() {
        return GuiSelectWorld.getSaveList(this.parentWorldGui).size();
    }

    @Override
    protected void elementClicked(int i, boolean flag) {
        boolean flag1;
        GuiSelectWorld.onElementSelected(this.parentWorldGui, i);
        GuiSelectWorld.getSelectButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1 = GuiSelectWorld.getSelectedWorld(this.parentWorldGui) >= 0 && GuiSelectWorld.getSelectedWorld(this.parentWorldGui) < this.getSize();
        GuiSelectWorld.getRenameButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        GuiSelectWorld.getDeleteButton((GuiSelectWorld)this.parentWorldGui).enabled = flag1;
        if (flag && flag1) {
            this.parentWorldGui.selectWorld(i);
        }
    }

    @Override
    protected boolean isSelected(int i) {
        return i == GuiSelectWorld.getSelectedWorld(this.parentWorldGui);
    }

    @Override
    protected int getContentHeight() {
        return GuiSelectWorld.getSaveList(this.parentWorldGui).size() * 36;
    }

    @Override
    protected void drawBackground() {
        this.parentWorldGui.drawDefaultBackground();
    }

    @Override
    protected void drawSlot(int i, int j, int k, int l, Tessellator tessellator) {
        SaveFile saveFile = GuiSelectWorld.getSaveList(this.parentWorldGui).get(i);
        String s = saveFile.getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            s = GuiSelectWorld.func_22087_f(this.parentWorldGui) + " " + (i + 1);
        }
        String s1 = saveFile.getFileName();
        s1 = s1 + " (" + GuiSelectWorld.getDateFormatter(this.parentWorldGui).format(new Date(saveFile.getLastTimePlayed()));
        long l1 = saveFile.getSizeOnDisk();
        s1 = s1 + ", " + (float)(l1 / 1024L * 100L / 1024L) / 100.0f + " MB)";
        String s2 = "";
        if (saveFile.getNeedsConversion()) {
            s2 = GuiSelectWorld.func_22088_h(this.parentWorldGui) + " " + s2;
        } else {
            LevelData ld = saveFile.getLevelData();
            DimensionData dd = saveFile.getDimensionData()[0];
            I18n st = I18n.getInstance();
            s2 = s2 + st.translateNameKey(Gamemode.gamemodesList[ld.getGamemode()].languageKey);
            if (ld.getCheatsEnabled()) {
                s2 = s2 + " | Cheats";
            }
            s2 = s2 + " | " + st.translateNameKey(dd.getWorldType().getLanguageKey());
        }
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s, j + 2, k + 1, 0xFFFFFF);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s1, j + 2, k + 12, 0x808080);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s2, j + 2, k + 12 + 10, 0x808080);
    }
}

