/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.options.GuiOptionsPageOptionBase;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.core.lang.I18n;

public class GuiOptionsPageGeneral
extends GuiOptionsPageOptionBase {
    GuiTooltip tooltip;
    boolean tooltipHovered = true;

    public GuiOptionsPageGeneral(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
        this.addOptionsCategory("options.category.gameplay", this.gameSettings.FoV, this.gameSettings.difficulty, this.gameSettings.placementMode, this.gameSettings.autoHit, this.gameSettings.viewBobbing);
        this.addOptionsCategory("options.category.ui", this.gameSettings.guiScale, this.gameSettings.screenPadding, this.gameSettings.tooltipStyle, this.gameSettings.fpsInOverlay, this.gameSettings.foodHealthRegenOverlay, this.gameSettings.armorDurabilityOverlay, this.gameSettings.heldItemCountOverlay, this.gameSettings.heldItemTooltips);
        this.addOptionsCategory("options.category.misc", this.gameSettings.discordRichPresence, this.gameSettings.worldHoleFix, this.gameSettings.forceUnicodeFont, this.gameSettings.autosaveTimer);
        this.tooltip = new GuiTooltip(Minecraft.getMinecraft(this));
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        super.drawScreen(x, y, renderPartialTicks);
        if (this.tooltipHovered) {
            I18n st = I18n.getInstance();
            this.tooltip.render(st.translateKey(((TooltipStyle)((Object)this.gameSettings.tooltipStyle.value)).getTranslationKey()), x, y, 0, 0);
            this.tooltipHovered = false;
        }
    }

    @Override
    public void onButtonHovered(GuiButton button, Option<?> option) {
        if (option == this.gameSettings.tooltipStyle) {
            this.tooltipHovered = true;
        }
    }
}

