/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.GuiButtonTexturePack;
import net.minecraft.client.gui.options.GuiOptionsPageBase;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.texturepack.TexturePackBase;
import net.minecraft.core.Global;
import org.lwjgl.Sys;

public class GuiOptionsPageTexturePacks
extends GuiOptionsPageBase {
    List<GuiButtonTexturePack> texturePackButtons = new ArrayList<GuiButtonTexturePack>();
    List<TexturePackBase> texturePacks;
    int mouseX;
    int mouseY;
    GuiButton btnOpenFolder = null;
    String fileLocation = "";
    WatchService fileWatcher = null;

    public GuiOptionsPageTexturePacks(GuiScreen parent, GameSettings settings) {
        super(parent, settings);
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        this.texturePackButtons.clear();
        super.initGui();
        this.mc.texturePackList.updateAvailableTexturePacks();
        this.texturePacks = this.mc.texturePackList.availableTexturePacks();
        for (int i = 0; i < this.texturePacks.size(); ++i) {
            TexturePackBase tp = this.texturePacks.get(i);
            GuiButtonTexturePack button = new GuiButtonTexturePack(1000 + i, 0, 0, 0, 0, tp);
            button.visible = false;
            this.texturePackButtons.add(new GuiButtonTexturePack(1000 + i, 0, 0, 0, 0, tp));
        }
        this.btnOpenFolder = new GuiButton(1, this.width / 2 - 100, this.top + 4, 200, 20, "Open Folder");
        this.controlList.add(this.btnOpenFolder);
        this.fileLocation = new File(Global.accessor.getMinecraftDir(), "texturepacks").getAbsolutePath();
        if (this.fileWatcher == null) {
            try {
                this.fileWatcher = FileSystems.getDefault().newWatchService();
                Path dirPath = new File(this.fileLocation).toPath();
                dirPath.register(this.fileWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        ArrayList btns = new ArrayList(this.controlList);
        this.controlList.addAll(this.texturePackButtons);
        super.mouseClicked(x, y, button);
        this.controlList.clear();
        this.controlList.addAll(btns);
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        if (guibutton == this.btnOpenFolder) {
            Sys.openURL((String)("file://" + this.fileLocation));
        } else {
            int tpIndex;
            super.buttonPressed(guibutton);
            for (tpIndex = 0; tpIndex < this.texturePackButtons.size() && guibutton != this.texturePackButtons.get(tpIndex); ++tpIndex) {
            }
            if (tpIndex >= this.texturePackButtons.size()) {
                return;
            }
            TexturePackBase tp = this.texturePacks.get(tpIndex);
            this.mc.texturePackList.setTexturePack(tp);
            this.mc.renderEngine.refreshTextures();
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        super.drawScreen(x, y, renderPartialTicks);
        this.mouseX = x;
        this.mouseY = y;
        WatchKey key = this.fileWatcher.poll();
        if (key != null) {
            key.pollEvents();
            key.reset();
            this.initGui();
        }
    }

    @Override
    protected void drawPageItems(int x, int y, int width) {
        this.btnOpenFolder.yPosition = y + 4;
        int previousHeights = y + 4 + 20 + 6;
        for (int i = 0; i < this.texturePacks.size(); ++i) {
            GuiButtonTexturePack button = this.texturePackButtons.get(i);
            button.isSelected = this.mc.texturePackList.selectedTexturePack == this.texturePacks.get(i);
            button.width = width;
            button.height = 32;
            button.xPosition = x + width - button.width;
            button.yPosition = previousHeights;
            button.visible = true;
            button.drawButton(this.mc, this.mouseX, this.mouseY);
            previousHeights += button.height + 3;
        }
    }

    @Override
    protected int getTotalPageHeight() {
        return 3 + 35 * this.texturePacks.size();
    }
}

