/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import net.minecraft.client.input.Input;
import net.minecraft.client.input.InputType;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.entity.player.EntityPlayer;

public class KeyboardInput
extends Input {
    private final boolean[] keys = new boolean[11];
    private final GameSettings gameSettings;
    public boolean sneakToggledOn;
    private boolean isAutoWalkOn = false;

    public KeyboardInput(GameSettings gamesettings) {
        this.gameSettings = gamesettings;
    }

    @Override
    public void setKey(int keyCode, boolean isPressed) {
        int inputIndex = -1;
        if (this.gameSettings.keyForward.isKey(keyCode)) {
            inputIndex = 0;
        }
        if (this.gameSettings.keyBack.isKey(keyCode)) {
            inputIndex = 1;
        }
        if (this.gameSettings.keyLeft.isKey(keyCode)) {
            inputIndex = 2;
        }
        if (this.gameSettings.keyRight.isKey(keyCode)) {
            inputIndex = 3;
        }
        if (this.gameSettings.keyJump.isKey(keyCode)) {
            inputIndex = 4;
        }
        if (this.gameSettings.keySneak.isKey(keyCode)) {
            inputIndex = 5;
        }
        if (this.gameSettings.keyLookLeft.isKey(keyCode)) {
            inputIndex = 6;
        }
        if (this.gameSettings.keyLookRight.isKey(keyCode)) {
            inputIndex = 7;
        }
        if (this.gameSettings.keyLookUp.isKey(keyCode)) {
            inputIndex = 8;
        }
        if (this.gameSettings.keyLookDown.isKey(keyCode)) {
            inputIndex = 9;
        }
        if (this.gameSettings.keyAutoWalk.isKey(keyCode)) {
            inputIndex = 10;
        }
        if (inputIndex >= 0) {
            this.keys[inputIndex] = isPressed;
        }
    }

    @Override
    public void releaseAllKeys() {
        for (int i = 0; i < 11; ++i) {
            this.keys[i] = false;
        }
    }

    @Override
    public void tick(EntityPlayer entityplayer) {
        if (this.gameSettings.mc.inputType == InputType.CONTROLLER) {
            if (this.gameSettings.mc.currentScreen == null) {
                this.moveForward = -this.gameSettings.mc.controllerInput.joyLeft.getY();
                this.moveStrafe = -this.gameSettings.mc.controllerInput.joyLeft.getX();
                this.jump = this.gameSettings.mc.controllerInput.buttonA.isPressed();
                if (this.gameSettings.mc.controllerInput.joyRight.getButton().pressedThisFrame()) {
                    this.sneak = !this.sneak;
                }
            } else {
                this.moveForward = 0.0f;
                this.moveStrafe = 0.0f;
                this.jump = false;
            }
        } else {
            this.moveStrafe = 0.0f;
            this.moveForward = 0.0f;
            this.lookPitch = 0.0f;
            this.lookYaw = 0.0f;
            if (this.keys[10]) {
                this.isAutoWalkOn = true;
            }
            if (this.keys[0] || this.isAutoWalkOn) {
                this.moveForward += 1.0f;
                if (this.keys[0]) {
                    this.isAutoWalkOn = false;
                }
            }
            if (this.keys[1]) {
                this.moveForward -= 1.0f;
                this.isAutoWalkOn = false;
            }
            if (this.keys[2]) {
                this.moveStrafe += 1.0f;
                this.isAutoWalkOn = false;
            }
            if (this.keys[3]) {
                this.moveStrafe -= 1.0f;
                this.isAutoWalkOn = false;
            }
            this.jump = this.keys[4];
            this.sneak = (Boolean)this.gameSettings.sneakToggle.value == false ? this.keys[5] : this.sneakToggledOn;
            if (this.keys[6]) {
                this.lookYaw -= 1.0f;
            }
            if (this.keys[7]) {
                this.lookYaw += 1.0f;
            }
            if (this.keys[8]) {
                this.lookPitch -= 1.0f;
            }
            if (this.keys[9]) {
                this.lookPitch += 1.0f;
            }
            this.lookYaw *= ((Float)this.gameSettings.mouseSensitivity.value).floatValue() * 20.0f;
            this.lookPitch *= ((Float)this.gameSettings.mouseSensitivity.value).floatValue() * 20.0f;
            if (this.sneak) {
                this.lookPitch /= 2.0f;
                this.lookYaw /= 2.0f;
            }
        }
        if (this.sneak) {
            this.moveStrafe = (float)((double)this.moveStrafe * 0.3);
            this.moveForward = (float)((double)this.moveForward * 0.3);
        }
    }
}

