/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.b100.utils.ReflectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.option.BooleanOption;
import net.minecraft.client.option.ColorOption;
import net.minecraft.client.option.EnumOption;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.option.ImmersiveModeOption;
import net.minecraft.client.option.IntegerOption;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.RangeOption;
import net.minecraft.client.option.StringOption;
import net.minecraft.client.option.VolumeOption;
import net.minecraft.client.option.enums.Difficulty;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.PlacementMode;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.ITranslatable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

public class GameSettings {
    private static final String[] LIMIT_FRAMERATES = new String[]{"performance.max", "performance.balanced", "performance.powersaver", "performance.vsync"};
    private static final String[] ANIMATIONS = new String[]{"options.animations.off", "options.animations.procedural", "options.animations.custom"};
    public final Minecraft mc;
    private File optionsFile;
    public IntegerOption windowWidth = new IntegerOption(this, "windowWidth", 854);
    public IntegerOption windowHeight = new IntegerOption(this, "windowHeight", 480);
    public VolumeOption masterVolume = new VolumeOption(this, "sound.master", 1.0f, SoundType.GUI_SOUNDS);
    public VolumeOption musicVolume = new VolumeOption(this, "sound.music", 1.0f, SoundType.MUSIC);
    public VolumeOption worldSoundsVolume = new VolumeOption(this, "sound.world", 1.0f, SoundType.WORLD_SOUNDS);
    public VolumeOption entitySoundsVolume = new VolumeOption(this, "sound.entity", 1.0f, SoundType.ENTITY_SOUNDS);
    public VolumeOption caveSoundsVolume = new VolumeOption(this, "sound.cave", 1.0f, SoundType.CAVE_SOUNDS);
    public VolumeOption guiSoundsVolume = new VolumeOption(this, "sound.gui", 1.0f, SoundType.GUI_SOUNDS);
    public VolumeOption weatherSoundsVolume = new VolumeOption(this, "sound.weather", 1.0f, SoundType.WEATHER_SOUNDS);
    public FloatOption FoV = new FloatOption(this, "fov", 0.40140846f);
    public FloatOption mouseSensitivity = new FloatOption(this, "mouseSensitivity", 0.5f);
    public FloatOption screenPadding = new FloatOption(this, "screenPadding", 0.0f);
    public FloatOption gamma = new FloatOption(this, "gamma", 0.5f);
    public BooleanOption fxaa = new BooleanOption(this, "fxaa", false);
    public FloatOption controllerSensitivity = new FloatOption(this, "controllerSensitivity", 0.5f);
    public FloatOption controllerMenuSensitivity = new FloatOption(this, "controllerMenuSensitivity", 0.5f);
    public FloatOption controllerDeadzoneLeft = new FloatOption(this, "controllerDeadzoneL", 0.25f);
    public FloatOption controllerDeadzoneRight = new FloatOption(this, "controllerDeadzoneR", 0.25f);
    public FloatOption blockOutlineWidth = new FloatOption(this, "blockOutlineWidth", 0.5f);
    public BooleanOption invertMouse = new BooleanOption(this, "invertYMouse", false);
    public BooleanOption rawMouseInput = new BooleanOption(this, "rawMouseInput", false);
    public BooleanOption swapMouseButtons = new BooleanOption(this, "swapMouseButtons", false);
    public BooleanOption viewBobbing = new BooleanOption(this, "bobView", true);
    public BooleanOption advancedOpenGL = new BooleanOption(this, "advancedOpengl", false);
    public RangeOption fancyGraphics = new RangeOption(this, "fancyGraphics", 1, 2);
    public BooleanOption treeShadows = new BooleanOption(this, "treeShadows", true);
    public BooleanOption ambientOcclusion = new BooleanOption(this, "ambientOcclusion", true);
    public BooleanOption chunkLoading = new BooleanOption(this, "chunkLoading", false);
    public BooleanOption items3D = new BooleanOption(this, "3Ditems", false);
    public BooleanOption smoothCamera = new BooleanOption(this, "smoothCamera", false);
    public BooleanOption lockCamera = new BooleanOption(this, "lockCamera", false);
    public BooleanOption biomeWater = new BooleanOption(this, "biomeWater", true);
    public BooleanOption vignette = new BooleanOption(this, "vignette", true);
    public BooleanOption showPlayerList = new BooleanOption(this, "showPlayerList", false);
    public BooleanOption slimeParticles = new BooleanOption(this, "slimeParticles", true);
    public BooleanOption disableShaders = new BooleanOption(this, "disableShaders", false);
    public StringOption shaderOverride = new StringOption(this, "shaderOverride", "");
    public BooleanOption autoHit = new BooleanOption(this, "autoHit", true);
    public BooleanOption foodHealthRegenOverlay = new BooleanOption(this, "foodHealthRegenOverlay", true);
    public BooleanOption fpsInOverlay = new BooleanOption(this, "fpsInOverlay", false);
    public BooleanOption controllerSwapShoulderButtons = new BooleanOption(this, "controllerSwapShoulderButtons", false);
    public BooleanOption controllerSwapAB = new BooleanOption(this, "controllerSwapAB", false);
    public BooleanOption controllerSwapXY = new BooleanOption(this, "controllerSwapXY", false);
    public BooleanOption worldHoleFix = new BooleanOption(this, "worldHoleFix", false);
    public BooleanOption clouds = new BooleanOption(this, "clouds", true);
    public BooleanOption armorDurabilityOverlay = new BooleanOption(this, "armorDurabilityOverlay", false);
    public BooleanOption armorProtectionOverlay = new BooleanOption(this, "armorProtectionOverlay", true);
    public BooleanOption heldItemCountOverlay = new BooleanOption(this, "heldItemCountOverlay", false);
    public BooleanOption pauseOnLostFocus = new BooleanOption(this, "pauseOnLostFocus", true);
    public BooleanOption showDebugScreen = new BooleanOption(this, "showDebugScreen", false);
    public BooleanOption showFrameTimes = new BooleanOption(this, "showFrameTimes", false);
    public BooleanOption showItemDurability = new BooleanOption(this, "showItemDurability", false);
    public BooleanOption swapCraftingButtons = new BooleanOption(this, "swapCraftingButtons", false);
    public BooleanOption disableJInput = new BooleanOption(this, "disableJInput", false);
    public BooleanOption enableVbos = new BooleanOption(this, "enableVbos", false);
    public BooleanOption forceUnicodeFont = new BooleanOption(this, "forceUnicodeFont", false);
    public EnumOption<PlacementMode> placementMode = new EnumOption<PlacementMode>(this, "placementMode", PlacementMode.class, PlacementMode.DEFAULT).setIsSlider(false);
    public BooleanOption discordRichPresence = new BooleanOption(this, "discordRichPresence", false);
    public ImmersiveModeOption immersiveMode = new ImmersiveModeOption(this);
    public ColorOption guiBackgroundColor = new ColorOption(this, "guiBackgroundColor", new Color().setARGB(-1072689136));
    public EnumOption<Difficulty> difficulty = new EnumOption<Difficulty>(this, "difficulty", Difficulty.class, Difficulty.NORMAL);
    public IntegerOption thirdPersonView = new IntegerOption(this, "thirdPersonView", 0);
    public EnumOption<RenderDistance> renderDistance = new EnumOption<RenderDistance>(this, "renderDistance", RenderDistance.class, RenderDistance.FAR);
    public RangeOption limitFramerate = new RangeOption(this, "limitFramerate", 0, 4);
    public IntegerOption guiScale = new IntegerOption(this, "guiScale", 0);
    public IntegerOption overlayMode = new IntegerOption(this, "overlayMode", 0);
    public IntegerOption rotationOverlayMode = new IntegerOption(this, "rotationOverlayMode", 0);
    public RangeOption animations = new RangeOption(this, "animations", 2, 3);
    public IntegerOption playerListPosition = new IntegerOption(this, "playerListPosition", 2);
    public BooleanOption heldItemTooltips = new BooleanOption(this, "heldItemTooltips", true);
    public FloatOption colorCorrection = new FloatOption(this, "colorCorrection", 1.0f);
    public BooleanOption sneakToggle = new BooleanOption(this, "sneakToggle", false);
    public FloatOption autosaveTimer = new FloatOption(this, "autosaveTimer", 0.041666668f);
    public BooleanOption disableResize = new BooleanOption(this, "disableResize", false);
    public BooleanOption enableItemDragging = new BooleanOption(this, "enableItemDragging", true);
    public RangeOption bloom = new RangeOption(this, "bloom", 2, 3);
    public EnumOption<RenderScale> renderScale = new EnumOption<RenderScale>(this, "renderScale", RenderScale.class, RenderScale.SCALE_100);
    public BooleanOption heatHaze = new BooleanOption(this, "heatHaze", true);
    public BooleanOption downloadSoundfiles = new BooleanOption(this, "downloadSoundfiles", true);
    public BooleanOption allowSoundOverrides = new BooleanOption(this, "allowSoundOverrides", false);
    public BooleanOption loadAllSounds = new BooleanOption(this, "loadAllSounds", false);
    public BooleanOption overlayShowCoords = new BooleanOption(this, "overlayShowCoords", true);
    public BooleanOption overlayShowDirection = new BooleanOption(this, "overlayShowDirection", true);
    public BooleanOption overlayShowTime = new BooleanOption(this, "overlayShowTime", true);
    public BooleanOption overlayShowSeason = new BooleanOption(this, "overlayShowSeason", true);
    public BooleanOption overlayShowWeather = new BooleanOption(this, "overlayShowWeather", true);
    public BooleanOption overlayShowBiome = new BooleanOption(this, "overlayShowBiome", true);
    public BooleanOption[] overlayElements = new BooleanOption[]{this.overlayShowCoords, this.overlayShowDirection, this.overlayShowTime, this.overlayShowSeason, this.overlayShowWeather, this.overlayShowBiome};
    public StringOption lastServer = new StringOption(this, "lastServer", "");
    public StringOption skin = new StringOption(this, "skin", "Default");
    public StringOption selectedController = new StringOption(this, "selectedController", "");
    public StringOption language = new StringOption(this, "language", "en_US");
    public RangeOption mipmapLevels = new RangeOption(this, "mipmapLevels", 0, 5);
    public EnumOption<MipmapType> mipmapType = new EnumOption<MipmapType>(this, "mipmapType", MipmapType.class, MipmapType.SMOOTH);
    public BooleanOption fullscreen = new BooleanOption(this, "fullscreen", false);
    public BooleanOption borderlessFullscreen = new BooleanOption(this, "borderlessFullscreen", true);
    public BooleanOption startInFullscreen = new BooleanOption(this, "startInFullscreen", true);
    public EnumOption<TooltipStyle> tooltipStyle = new EnumOption<TooltipStyle>(this, "tooltipStyle", TooltipStyle.class);
    public BooleanOption fog = new BooleanOption(this, "fog", true);
    public BooleanOption muteOnLostFocus = new BooleanOption(this, "muteOnLostFocus", false);
    public BooleanOption aurora = new BooleanOption(this, "aurora", true);
    public BooleanOption mobVariants = new BooleanOption(this, "mobVariants", true);
    public KeyBinding keyForward = new KeyBinding("key.forward", 17);
    public KeyBinding keyLeft = new KeyBinding("key.left", 30);
    public KeyBinding keyBack = new KeyBinding("key.back", 31);
    public KeyBinding keyRight = new KeyBinding("key.right", 32);
    public KeyBinding keyJump = new KeyBinding("key.jump", 57);
    public KeyBinding keyInventory = new KeyBinding("key.inventory", 18);
    public KeyBinding keyDrop = new KeyBinding("key.drop", 16);
    public KeyBinding keyChat = new KeyBinding("key.chat", 20);
    public KeyBinding keyToggleFog = new KeyBinding("key.fog", 33);
    public KeyBinding keySneak = new KeyBinding("key.sneak", 42);
    public KeyBinding keyFly = new KeyBinding("key.fly", 29);
    public KeyBinding keyGuidebook = new KeyBinding("key.guidebook", 19);
    public KeyBinding keyHotBarLeft = new KeyBinding("key.hotbar.left", 51);
    public KeyBinding keyHotBarRight = new KeyBinding("key.hotbar.right", 52);
    public KeyBinding keyHotBarSwitch = new KeyBinding("key.hotbar.switch", 15);
    public KeyBinding keyLookLeft = new KeyBinding("key.look.left", 203);
    public KeyBinding keyLookRight = new KeyBinding("key.look.right", 205);
    public KeyBinding keyLookUp = new KeyBinding("key.look.up", 200);
    public KeyBinding keyLookDown = new KeyBinding("key.look.down", 208);
    public KeyBinding keyCenterView = new KeyBinding("key.look.center", 207);
    public KeyBinding keyZoom = new KeyBinding("key.zoom", 46);
    public KeyBinding keyPlayerList = new KeyBinding("key.playerList", 38);
    public KeyBinding keyPhotoMode = new KeyBinding("key.photoMode", 25);
    public KeyBinding keyLockRotation = new KeyBinding("key.lockRotation", 44);
    public KeyBinding keyScreenshot = new KeyBinding("key.screenshot", 60);
    public KeyBinding keyCinematicCamera = new KeyBinding("key.cinematicCamera", 66);
    public KeyBinding keySwitchPerspective = new KeyBinding("key.switchPerspective", 63);
    public KeyBinding keyHideGui = new KeyBinding("key.immersiveMode", 59);
    public KeyBinding keyAutoWalk = new KeyBinding("key.autoWalk", 47);
    public KeyBinding keyToggleOverlay = new KeyBinding("key.toggleOverlay", 62);
    public KeyBinding[] keys = ReflectUtils.getAllObjects(GameSettings.class, KeyBinding.class, this);

    public Option<?>[] getAllOptions() {
        return ReflectUtils.getAllObjects(GameSettings.class, Option.class, this);
    }

    public KeyBinding getKey(int i) {
        return this.keys[i];
    }

    public String getKeyName(int i) {
        i = this.getKey((int)i).key;
        return i == -1 ? "DISABLED" : Keyboard.getKeyName((int)i);
    }

    public String getKeyBindName(int id) {
        return I18n.getInstance().translateKey(this.getKey((int)id).name);
    }

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.loadOptions();
        this.saveOptions();
    }

    public String getDisplayString(Option<?> option) {
        if (option == null) {
            return "";
        }
        I18n trans = I18n.getInstance();
        if (option instanceof FloatOption) {
            Float f = (Float)option.value;
            if (option == this.mouseSensitivity) {
                if (f.floatValue() == 0.0f) {
                    return trans.translateKey("options.mouseSensitivity.min");
                }
                if (f.floatValue() == 1.0f) {
                    return trans.translateKey("options.mouseSensitivity.max");
                }
                return (int)(f.floatValue() * 200.0f) + "%";
            }
            if (option == this.FoV) {
                if (f.floatValue() == 0.0f) {
                    return trans.translateKey("options.fov.min");
                }
                if (f.floatValue() == 1.0f) {
                    return trans.translateKey("options.fov.max");
                }
                return String.valueOf((int)(f.floatValue() * 100.0f + 30.0f));
            }
            if (option == this.screenPadding) {
                int percent = (int)(f.floatValue() * 100.0f);
                return percent + "%";
            }
            if (option == this.gamma) {
                int percent = (int)(f.floatValue() * 200.0f);
                return percent + "%";
            }
            if (option == this.autosaveTimer) {
                int timer = (int)(f.floatValue() * 24.0f);
                if (timer == 0) {
                    return trans.translateKey("options.autosaveTimer.off");
                }
                return timer * 5 + " seconds";
            }
            if (f.floatValue() == 0.0f) {
                return trans.translateKey("options.off");
            }
            return (int)(f.floatValue() * 100.0f) + "%";
        }
        if (option == this.guiScale) {
            if ((Integer)this.guiScale.value == 0) {
                return trans.translateKey("options.guiScale.auto");
            }
            return this.guiScale.value + "x";
        }
        if (option == this.limitFramerate) {
            return trans.translateKey(LIMIT_FRAMERATES[(Integer)this.limitFramerate.value]);
        }
        if (option == this.animations) {
            return trans.translateKey(ANIMATIONS[(Integer)this.animations.value]);
        }
        if (option == this.fancyGraphics) {
            if ((Integer)this.fancyGraphics.value == 1) {
                return trans.translateKey("options.graphics.fancy");
            }
            return trans.translateKey("options.graphics.fast");
        }
        if (option == this.chunkLoading) {
            if (((Boolean)this.chunkLoading.value).booleanValue()) {
                return trans.translateKey("options.chunkloading.dynamic");
            }
            return trans.translateKey("options.chunkloading.static");
        }
        if (option == this.bloom) {
            if ((Integer)this.bloom.value == 0) {
                return trans.translateKey("options.off");
            }
            if ((Integer)this.bloom.value == 1) {
                return trans.translateKey("options.bloom.low");
            }
            if ((Integer)this.bloom.value == 2) {
                return trans.translateKey("options.bloom.high");
            }
        }
        if (option instanceof BooleanOption) {
            Boolean flag = (Boolean)option.value;
            if (flag.booleanValue()) {
                return trans.translateKey("options.on");
            }
            return trans.translateKey("options.off");
        }
        if (option instanceof EnumOption) {
            String key;
            EnumOption enumOption = (EnumOption)option;
            if (enumOption.value instanceof ITranslatable) {
                ITranslatable translatable = (ITranslatable)enumOption.value;
                key = translatable.getTranslationKey();
            } else {
                key = ((Enum)enumOption.value).toString().toLowerCase();
            }
            return trans.translateKey("options." + enumOption.name + "." + key);
        }
        return option.value.toString();
    }

    public void optionChanged(Option<?> option) {
        int max;
        if (option == this.limitFramerate) {
            Display.setVSyncEnabled(((Integer)this.limitFramerate.value == 3 ? 1 : 0) != 0);
        }
        if (option == this.fancyGraphics) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.ambientOcclusion) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.advancedOpenGL) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.biomeWater) {
            this.mc.renderGlobal.loadRenderers();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.treeShadows) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.placementMode && this.mc.thePlayer != null) {
            this.mc.thePlayer.syncPlacementMode();
        }
        if (option == this.animations) {
            this.mc.renderEngine.refreshTextures();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.fullscreen || option == this.borderlessFullscreen) {
            this.mc.fullscreenHelper.updateWindowState();
        }
        if (option == this.guiScale) {
            max = this.mc.resolution.getMaxScale();
            this.guiScale.value = ((Integer)this.guiScale.value + max) % max;
        }
        if (option == this.mipmapType || option == this.mipmapLevels) {
            this.mc.renderEngine.refreshTextures();
        }
        if (option == this.autosaveTimer) {
            max = 24;
            this.autosaveTimer.value = Float.valueOf((((Float)this.autosaveTimer.value).floatValue() + (float)max) % (float)max);
        }
        if (option == this.discordRichPresence && ((Boolean)this.discordRichPresence.value).booleanValue() && this.mc.rpcThread == null) {
            this.mc.rpcThread = new RichPresenceHandlerThread(this.mc);
            this.mc.rpcThread.start();
        }
    }

    public void loadOptions() {
        if (!this.optionsFile.exists()) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            while ((line = br.readLine()) != null) {
                try {
                    String[] as = line.split(":");
                    String key = as[0];
                    String value = as[1];
                    for (Option<?> option : this.getAllOptions()) {
                        if (!option.name.equalsIgnoreCase(key)) continue;
                        option.parse(value);
                    }
                    for (int i = 0; i < this.keys.length; ++i) {
                        if (!key.equals("key_" + this.keys[i].name)) continue;
                        this.keys[i].setKeyCode(Integer.parseInt(value));
                    }
                }
                catch (Exception exception1) {
                    System.out.println("Skipping bad option: " + line);
                }
            }
            br.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (Option<?> option : this.getAllOptions()) {
                printwriter.println(option.name + ":" + option.getValueString());
            }
            for (KeyBinding key : this.keys) {
                printwriter.println("key_" + key.name + ":" + key.keyCode());
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

