/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.IntBuffer;
import net.minecraft.client.GLAllocation;
import org.lwjgl.opengl.GL11;

public class DisplayList {
    private int posX;
    private int posY;
    private int posZ;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private final IntBuffer callList = GLAllocation.createDirectIntBuffer(65536);
    private boolean initialized = false;
    private boolean isFlipped = false;

    public void setToPos(int blockX, int blockY, int blockZ, double offsetX, double offsetY, double offsetZ) {
        this.initialized = true;
        this.callList.clear();
        this.posX = blockX;
        this.posY = blockY;
        this.posZ = blockZ;
        this.offsetX = (float)offsetX;
        this.offsetY = (float)offsetY;
        this.offsetZ = (float)offsetZ;
    }

    public boolean isSetToPos(int posX, int posY, int posZ) {
        if (!this.initialized) {
            return false;
        }
        return posX == this.posX && posY == this.posY && posZ == this.posZ;
    }

    public void addCallToList(int i) {
        this.callList.put(i);
        if (this.callList.remaining() == 0) {
            this.call();
        }
    }

    public void call() {
        if (!this.initialized) {
            return;
        }
        if (!this.isFlipped) {
            this.callList.flip();
            this.isFlipped = true;
        }
        if (this.callList.remaining() > 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)this.posX - this.offsetX), (float)((float)this.posY - this.offsetY), (float)((float)this.posZ - this.offsetZ));
            GL11.glCallLists((IntBuffer)this.callList);
            GL11.glPopMatrix();
        }
    }

    public void clear() {
        this.initialized = false;
        this.isFlipped = false;
    }
}

