/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.render.ChunkRenderer;
import net.minecraft.client.render.ChunkRendererComparator;
import net.minecraft.client.render.DisplayList;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelRenderBlocks;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.sound.block.BlockSound;
import net.minecraft.client.sound.block.BlockSoundDispatcher;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.CameraSorter;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.fx.EntityArrowGoldenFX;
import net.minecraft.core.entity.fx.EntityBubbleFX;
import net.minecraft.core.entity.fx.EntityDiggingFX;
import net.minecraft.core.entity.fx.EntityExplodeFX;
import net.minecraft.core.entity.fx.EntityFireflyFX;
import net.minecraft.core.entity.fx.EntityFlameFX;
import net.minecraft.core.entity.fx.EntityFootStepFX;
import net.minecraft.core.entity.fx.EntityHeartFX;
import net.minecraft.core.entity.fx.EntityLavaFX;
import net.minecraft.core.entity.fx.EntityLeafFX;
import net.minecraft.core.entity.fx.EntityNoteFX;
import net.minecraft.core.entity.fx.EntityPortalFX;
import net.minecraft.core.entity.fx.EntityReddustFX;
import net.minecraft.core.entity.fx.EntitySlimeChunkFX;
import net.minecraft.core.entity.fx.EntitySlimeFX;
import net.minecraft.core.entity.fx.EntitySmokeFX;
import net.minecraft.core.entity.fx.EntitySnowShovelFX;
import net.minecraft.core.entity.fx.EntitySplashFX;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemRecord;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.AuroraProvider;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.weather.Weather;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements LevelListener {
    public static final int RENDER_CHUNK_SIZE = 16;
    public List<TileEntity> tileEntities;
    private World worldObj;
    private RenderEngine renderEngine;
    private List<ChunkRenderer> chunkRenderersToUpdate;
    private ChunkRenderer[] sortedChunkRenderers;
    private ChunkRenderer[] chunkRenderers;
    private int renderChunksWide;
    private int renderChunksTall;
    private int renderChunksDeep;
    private int glRenderListBase;
    private Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    private float lastCloudOffsetX = 0.0f;
    private float lastCloudOffsetZ = 0.0f;
    private float cloudOffsetX = 0.0f;
    private float cloudOffsetZ;
    private float cloudVelocityX;
    private float cloudVelocityZ;
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private RenderDistance renderDistance = null;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private int worldRenderersCheckIndex;
    private List<ChunkRenderer> glRenderLists;
    private DisplayList[] allDisplayLists = new DisplayList[]{new DisplayList(), new DisplayList(), new DisplayList(), new DisplayList()};
    int dummyInt0 = 0;
    int glDummyList;
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    int frustumCheckOffset = 0;
    private float auroraBrightness = 0.0f;
    private float targetAuroraBrightness = Float.NaN;
    private float auroraBrightnessDelta = Float.NaN;

    public RenderGlobal(Minecraft minecraft, RenderEngine renderengine) {
        int z;
        int x;
        this.tileEntities = new ArrayList<TileEntity>();
        this.chunkRenderersToUpdate = new ArrayList<ChunkRenderer>();
        this.dummyBuf50k = new int[50000];
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.glRenderLists = new ArrayList<ChunkRenderer>();
        this.glDummyList = GLAllocation.generateDisplayLists(1);
        this.mc = minecraft;
        this.renderEngine = renderengine;
        int size = 64;
        this.glRenderListBase = GLAllocation.generateDisplayLists(size * size * size * 3);
        this.occlusionEnabled = OpenGLHelper.enableOcclusionCheck;
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(size * size * size);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(size * size * size);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.generateDisplayLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.setupStarsCallList();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte1 = 64;
        int i = 256 / byte1 + 2;
        float y = 16.0f;
        for (x = -byte1 * i; x <= byte1 * i; x += byte1) {
            for (z = -byte1 * i; z <= byte1 * i; z += byte1) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(x, y, z);
                tessellator.addVertex(x + byte1, y, z);
                tessellator.addVertex(x + byte1, y, z + byte1);
                tessellator.addVertex(x, y, z + byte1);
                tessellator.draw();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        y = -16.0f;
        tessellator.startDrawingQuads();
        for (x = -byte1 * i; x <= byte1 * i; x += byte1) {
            for (z = -byte1 * i; z <= byte1 * i; z += byte1) {
                tessellator.addVertex(x + byte1, y, z);
                tessellator.addVertex(x, y, z);
                tessellator.addVertex(x, y, z + byte1);
                tessellator.addVertex(x + byte1, y, z + byte1);
            }
        }
        tessellator.draw();
        GL11.glEndList();
    }

    private void setupStarsCallList() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int i = 0; i < 1500; ++i) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (d4 >= 1.0 || d4 <= 0.01) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d22;
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d17;
                double d21 = d18 * d16 - d19 * d15;
                double d23 = d22 = d19 * d16 + d18 * d15;
                double d24 = d21 * d12 + d20 * d13;
                double d25 = d20 * d12 - d21 * d13;
                double d26 = d25 * d9 - d23 * d10;
                double d27 = d24;
                double d28 = d23 * d9 + d25 * d10;
                tessellator.addVertex(d5 + d26, d6 + d27, d7 + d28);
            }
        }
        tessellator.draw();
    }

    public void changeWorld(World world) {
        if (this.worldObj != null) {
            this.worldObj.removeListener(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        EntityRenderDispatcher.instance.setWorld(world);
        this.worldObj = world;
        this.globalRenderBlocks = new RenderBlocks(world, world);
        this.auroraBrightness = 0.0f;
        this.targetAuroraBrightness = Float.NaN;
        if (world != null) {
            world.addListener(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        int renderDiameterBlocks;
        BlockLeavesBase.setGraphicsLevel((Integer)this.mc.gameSettings.fancyGraphics.value == 1);
        this.renderDistance = (RenderDistance)((Object)this.mc.gameSettings.renderDistance.value);
        if (this.worldObj == null) {
            return;
        }
        if (this.chunkRenderers != null) {
            for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
                chunkRenderer.reset();
            }
        }
        if ((renderDiameterBlocks = this.renderDistance.chunks * 16 * 2) > 400) {
            renderDiameterBlocks = 400;
        }
        this.renderChunksWide = renderDiameterBlocks / 16 + 1;
        this.renderChunksTall = this.worldObj.getHeightBlocks() / 16;
        this.renderChunksDeep = renderDiameterBlocks / 16 + 1;
        this.chunkRenderers = new ChunkRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        this.sortedChunkRenderers = new ChunkRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        int renderListOffset = 0;
        int chunkIndex = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.renderChunksWide;
        this.maxBlockY = this.renderChunksTall;
        this.maxBlockZ = this.renderChunksDeep;
        for (ChunkRenderer cr : this.chunkRenderersToUpdate) {
            cr.needsUpdate = false;
        }
        this.chunkRenderersToUpdate.clear();
        this.tileEntities.clear();
        for (int x = 0; x < this.renderChunksWide; ++x) {
            for (int y = 0; y < this.renderChunksTall; ++y) {
                for (int z = 0; z < this.renderChunksDeep; ++z) {
                    int index = (z * this.renderChunksTall + y) * this.renderChunksWide + x;
                    this.chunkRenderers[index] = new ChunkRenderer(this.renderEngine, this.worldObj, this.tileEntities, x * 16, y * 16, z * 16, 16, this.glRenderListBase + renderListOffset);
                    if (this.occlusionEnabled) {
                        this.chunkRenderers[index].glOcclusionQuery = this.glOcclusionQueryBase.get(chunkIndex);
                    }
                    this.chunkRenderers[index].isWaitingOnOcclusionQuery = false;
                    this.chunkRenderers[index].isVisible = true;
                    this.chunkRenderers[index].isInFrustum = true;
                    this.chunkRenderers[index].chunkIndex = chunkIndex++;
                    this.chunkRenderers[index].markDirty();
                    this.sortedChunkRenderers[index] = this.chunkRenderers[index];
                    this.chunkRenderersToUpdate.add(this.chunkRenderers[index]);
                    renderListOffset += 3;
                }
            }
        }
        if (this.worldObj != null && this.mc.activeCamera != null) {
            this.markRenderersForNewPosition(MathHelper.floor_double(this.mc.activeCamera.getX()), MathHelper.floor_double(this.mc.activeCamera.getY()), MathHelper.floor_double(this.mc.activeCamera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(this.mc.activeCamera));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void renderAurora(ICamera camera, float renderPartialTicks) {
        float dayProgress = this.worldObj.getWorldType().getTimeOfDay(this.worldObj, this.worldObj.getWorldTime(), renderPartialTicks);
        if (dayProgress < 0.5f) {
            return;
        }
        double cameraX = camera.getX(renderPartialTicks);
        double cameraY = camera.getY(renderPartialTicks);
        double cameraZ = camera.getZ(renderPartialTicks);
        double cameraYaw = camera.getYRot(renderPartialTicks);
        float temperature = (float)this.worldObj.getBlockTemperature((int)cameraX, (int)cameraZ);
        float mult = 0.0f;
        if (temperature <= 0.4f || this.worldObj.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) {
            temperature /= 0.4f;
            temperature = -temperature + 1.0f;
            mult += temperature;
        }
        float altitude = (float)this.worldObj.getWorldType().getYPercentage((int)cameraY);
        if ((temperature <= 0.6f || this.worldObj.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.worldObj.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER_ENDLESS) && altitude >= 0.8f) {
            if ((altitude -= 0.8f) > 0.1f) {
                altitude = 0.1f;
            }
            mult += altitude;
        }
        if (mult < 0.0f) {
            mult = 0.0f;
        }
        if (mult > 1.0f) {
            mult = 1.0f;
        }
        if (Float.isNaN(this.targetAuroraBrightness)) {
            this.auroraBrightness = mult;
        }
        this.targetAuroraBrightness = mult;
        float totalDelta = this.targetAuroraBrightness - this.auroraBrightness;
        this.auroraBrightnessDelta = totalDelta / 100.0f;
        this.auroraBrightness += this.auroraBrightnessDelta * renderPartialTicks;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        float scale = 1.0f;
        float auroraY = ((float)(this.worldObj.getWorldType().getMinY() + this.worldObj.getWorldType().getYRange()) + 64.0f) * 2.0f;
        float rotationX = MathHelper.cos((float)(cameraYaw * Math.PI / 180.0));
        float rotationZ = MathHelper.sin((float)(cameraYaw * Math.PI / 180.0));
        this.renderEngine.bindTexture(this.renderEngine.getTexture("%blur%/environment/aurora.png"));
        float time = (float)this.worldObj.getWorldTime() + renderPartialTicks;
        AuroraProvider aurora = this.worldObj.auroraProvider;
        float radius = 512.0f;
        long worldTime = this.worldObj.getWorldTime();
        for (float x = -radius; x < radius; x += 8.0f) {
            for (float z = -radius; z < radius; z += 8.0f) {
                float posX = (float)cameraX + x;
                float posZ = (float)cameraZ + z;
                float distanceSq = x * x + z + z;
                float distanceSqPercentage = distanceSq / (radius * radius + radius * radius);
                distanceSqPercentage = 1.0f - distanceSqPercentage;
                float sample = aurora.getAuroraPresence(posX, posZ, worldTime, dayProgress) * this.auroraBrightness;
                if (sample * 0.3f * distanceSqPercentage < 0.01f) continue;
                Tessellator.instance.startDrawingQuads();
                this.renderAuroraBeam(x * scale, (float)((double)(auroraY * scale) - cameraY * (double)scale) + aurora.getAuroraHeightOffset(posX, posZ, time), z * scale, rotationX, rotationZ, aurora.getAuroraRedOffset(posX, posZ, time), aurora.getAuroraGreenOffset(posX, posZ, time), aurora.getAuroraBlueOffset(posX, posZ, time), scale, sample * 0.3f * distanceSqPercentage);
                Tessellator.instance.draw();
            }
        }
        GL11.glEnable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glDepthFunc((int)515);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
    }

    private void renderAuroraBeam(float x, float y, float z, float xOffset, float zOffset, float redOffset, float greenOffset, float blueOffset, float scale, float transparency) {
        float width = 16.0f;
        GL11.glColor4f((float)(0.0f + redOffset), (float)(1.0f + greenOffset), (float)(0.49803922f + blueOffset), (float)transparency);
        Tessellator tessellator = Tessellator.instance;
        tessellator.addVertexWithUV(x - xOffset * scale * width, y - scale * 256.0f, z - zOffset * scale * width, 1.0, 1.0);
        tessellator.addVertexWithUV(x - xOffset * scale * width, y + scale, z - zOffset * scale * width, 1.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * width, y + scale, z + zOffset * scale * width, 0.0, 0.0);
        tessellator.addVertexWithUV(x + xOffset * scale * width, y - scale * 256.0f, z + zOffset * scale * width, 0.0, 1.0);
    }

    public void renderEntities(ICamera camera, float renderPartialTicks) {
        Entity entity;
        int i;
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
            return;
        }
        TileEntityRenderDispatcher.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, camera, renderPartialTicks);
        EntityRenderDispatcher.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRenderer, camera, this.mc.gameSettings, renderPartialTicks);
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countEntitiesHidden = 0;
        EntityRenderDispatcher.renderPosX = camera.getX(renderPartialTicks);
        EntityRenderDispatcher.renderPosY = camera.getY(renderPartialTicks);
        EntityRenderDispatcher.renderPosZ = camera.getZ(renderPartialTicks);
        TileEntityRenderDispatcher.renderPosX = camera.getX(renderPartialTicks);
        TileEntityRenderDispatcher.renderPosY = camera.getY(renderPartialTicks);
        TileEntityRenderDispatcher.renderPosZ = camera.getZ(renderPartialTicks);
        List<Entity> loadedEntities = this.worldObj.getLoadedEntityList();
        this.countEntitiesTotal = loadedEntities.size();
        for (i = 0; i < this.worldObj.weatherEffects.size(); ++i) {
            entity = this.worldObj.weatherEffects.get(i);
            ++this.countEntitiesRendered;
            if (!entity.shouldRender(camera.getPosition(renderPartialTicks))) continue;
            EntityRenderDispatcher.instance.renderEntity(entity, renderPartialTicks);
        }
        for (i = 0; i < loadedEntities.size(); ++i) {
            entity = loadedEntities.get(i);
            if (this.mc.activeCamera != null && this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).entity == entity && !this.mc.activeCamera.showPlayer() || !entity.shouldRender(camera.getPosition(renderPartialTicks)) || !entity.ignoreFrustumCheck && !camera.getFrustum().isVisible(entity.bb, renderPartialTicks)) continue;
            int floorY = MathHelper.floor_double(entity.y);
            if (floorY < 0) {
                floorY = 0;
            }
            if (floorY >= this.worldObj.getHeightBlocks()) {
                floorY = this.worldObj.getHeightBlocks() - 1;
            }
            if (!this.worldObj.isBlockLoaded(MathHelper.floor_double(entity.x), floorY, MathHelper.floor_double(entity.z))) continue;
            ++this.countEntitiesRendered;
            EntityRenderDispatcher.instance.renderEntity(entity, renderPartialTicks);
        }
        for (TileEntity tileEntity : this.tileEntities) {
            TileEntityRenderDispatcher.instance.renderTileEntity(tileEntity, renderPartialTicks);
        }
    }

    public String getRendererDebugInfo() {
        return "C: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". F: " + this.renderersBeingClipped + ", O: " + this.renderersBeingOccluded + ", E: " + this.renderersSkippingRenderPass;
    }

    public String getEntityDebugInfo() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". B: " + this.countEntitiesHidden + ", I: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    private void markRenderersForNewPosition(int i, int j, int k) {
        i -= 8;
        j -= 8;
        k -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int l = this.renderChunksWide * 16;
        int i1 = l / 2;
        for (int j1 = 0; j1 < this.renderChunksWide; ++j1) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i;
            if (l1 < 0) {
                l1 -= l - 1;
            }
            if ((k1 -= (l1 /= l) * l) < this.minBlockX) {
                this.minBlockX = k1;
            }
            if (k1 > this.maxBlockX) {
                this.maxBlockX = k1;
            }
            for (int i2 = 0; i2 < this.renderChunksDeep; ++i2) {
                int j2 = i2 * 16;
                int k2 = j2 + i1 - k;
                if (k2 < 0) {
                    k2 -= l - 1;
                }
                if ((j2 -= (k2 /= l) * l) < this.minBlockZ) {
                    this.minBlockZ = j2;
                }
                if (j2 > this.maxBlockZ) {
                    this.maxBlockZ = j2;
                }
                for (int l2 = 0; l2 < this.renderChunksTall; ++l2) {
                    int i3 = l2 * 16;
                    if (i3 < this.minBlockY) {
                        this.minBlockY = i3;
                    }
                    if (i3 > this.maxBlockY) {
                        this.maxBlockY = i3;
                    }
                    ChunkRenderer worldrenderer = this.chunkRenderers[(i2 * this.renderChunksTall + l2) * this.renderChunksWide + j1];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.setPosition(k1, i3, j2);
                    if (flag || !worldrenderer.needsUpdate) continue;
                    this.chunkRenderersToUpdate.add(worldrenderer);
                }
            }
        }
    }

    public int sortAndRender(ICamera camera, int renderPass, double renderPartialTicks) {
        double dPosZ;
        double dPosY;
        for (int i = 0; i < 10; ++i) {
            this.worldRenderersCheckIndex = (this.worldRenderersCheckIndex + 1) % this.chunkRenderers.length;
            ChunkRenderer chunkRenderer = this.chunkRenderers[this.worldRenderersCheckIndex];
            if (!chunkRenderer.needsUpdate || this.chunkRenderersToUpdate.contains(chunkRenderer)) continue;
            this.chunkRenderersToUpdate.add(chunkRenderer);
        }
        if (this.mc.gameSettings.renderDistance.value != this.renderDistance) {
            this.loadRenderers();
        }
        if (renderPass == 0) {
            this.renderersLoaded = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double entityPosX = camera.getX((float)renderPartialTicks);
        double entityPosY = camera.getY((float)renderPartialTicks);
        double entityPosZ = camera.getZ((float)renderPartialTicks);
        double dPosX = camera.getX() - this.prevSortX;
        if (dPosX * dPosX + (dPosY = camera.getY() - this.prevSortY) * dPosY + (dPosZ = camera.getZ() - this.prevSortZ) * dPosZ > 16.0) {
            this.prevSortX = camera.getX();
            this.prevSortY = camera.getY();
            this.prevSortZ = camera.getZ();
            this.markRenderersForNewPosition(MathHelper.floor_double(camera.getX()), MathHelper.floor_double(camera.getY()), MathHelper.floor_double(camera.getZ()));
            Arrays.sort(this.sortedChunkRenderers, new CameraSorter(camera));
        }
        Lighting.turnOn();
        int k = 0;
        if (this.occlusionEnabled && ((Boolean)this.mc.gameSettings.advancedOpenGL.value).booleanValue() && renderPass == 0) {
            int min = 0;
            int max = 16;
            this.checkOcclusionQueryResult(min, max);
            for (int i = min; i < max; ++i) {
                this.sortedChunkRenderers[i].isVisible = true;
            }
            k += this.renderSortedRenderers(min, max, renderPass, renderPartialTicks);
            do {
                int byte0 = max;
                if ((max *= 2) > this.sortedChunkRenderers.length) {
                    max = this.sortedChunkRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, max);
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                for (int k1 = byte0; k1 < max; ++k1) {
                    float f3;
                    int l1;
                    if (this.sortedChunkRenderers[k1].skipAllRenderPasses()) {
                        this.sortedChunkRenderers[k1].isInFrustum = false;
                        continue;
                    }
                    if (!this.sortedChunkRenderers[k1].isInFrustum) {
                        this.sortedChunkRenderers[k1].isVisible = true;
                    }
                    if (!this.sortedChunkRenderers[k1].isInFrustum || this.sortedChunkRenderers[k1].isWaitingOnOcclusionQuery || this.cloudOffsetX % (float)(l1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedChunkRenderers[k1].distanceToCameraSquared(camera))) / 128.0f)) != (float)(k1 % l1)) continue;
                    ChunkRenderer worldrenderer1 = this.sortedChunkRenderers[k1];
                    float f4 = (float)((double)worldrenderer1.posXMinus - entityPosX);
                    float f5 = (float)((double)worldrenderer1.posYMinus - entityPosY);
                    float f6 = (float)((double)worldrenderer1.posZMinus - entityPosZ);
                    float f7 = f4 - f;
                    float f8 = f5 - f1;
                    float f9 = f6 - f2;
                    if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                        GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                        f += f7;
                        f1 += f8;
                        f2 += f9;
                    }
                    ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedChunkRenderers[k1].glOcclusionQuery);
                    this.sortedChunkRenderers[k1].callOcclusionQueryList();
                    ARBOcclusionQuery.glEndQueryARB((int)35092);
                    this.sortedChunkRenderers[k1].isWaitingOnOcclusionQuery = true;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                k += this.renderSortedRenderers(byte0, max, renderPass, renderPartialTicks);
            } while (max < this.sortedChunkRenderers.length);
        } else {
            k += this.renderSortedRenderers(0, this.sortedChunkRenderers.length, renderPass, renderPartialTicks);
        }
        return k;
    }

    private void checkOcclusionQueryResult(int min, int max) {
        for (int i = min; i < max; ++i) {
            if (!this.sortedChunkRenderers[i].isWaitingOnOcclusionQuery) continue;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedChunkRenderers[i].glOcclusionQuery, (int)34919, (IntBuffer)this.occlusionResult);
            if (this.occlusionResult.get(0) == 0) continue;
            this.sortedChunkRenderers[i].isWaitingOnOcclusionQuery = false;
            this.occlusionResult.clear();
            ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedChunkRenderers[i].glOcclusionQuery, (int)34918, (IntBuffer)this.occlusionResult);
            this.sortedChunkRenderers[i].isVisible = this.occlusionResult.get(0) != 0;
        }
    }

    private int renderSortedRenderers(int min, int max, int renderPass, double renderPartialTicks) {
        this.glRenderLists.clear();
        int addedWorldRenderers = 0;
        for (int i = min; i < max; ++i) {
            int callList;
            if (renderPass == 0) {
                ++this.renderersLoaded;
                if (this.sortedChunkRenderers[i].skipRenderPass[renderPass]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedChunkRenderers[i].isInFrustum) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedChunkRenderers[i].isVisible) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if (this.sortedChunkRenderers[i].skipRenderPass[renderPass] || !this.sortedChunkRenderers[i].isInFrustum || this.occlusionEnabled && !this.sortedChunkRenderers[i].isVisible || (callList = this.sortedChunkRenderers[i].getGLCallListForPass(renderPass)) < 0) continue;
            this.glRenderLists.add(this.sortedChunkRenderers[i]);
            ++addedWorldRenderers;
        }
        double posX = this.mc.activeCamera.getX((float)renderPartialTicks);
        double posY = this.mc.activeCamera.getY((float)renderPartialTicks);
        double posZ = this.mc.activeCamera.getZ((float)renderPartialTicks);
        int k1 = 0;
        for (DisplayList displayList : this.allDisplayLists) {
            displayList.clear();
        }
        for (ChunkRenderer chunkRenderer : this.glRenderLists) {
            int displayListIndex = -1;
            for (int i = 0; i < k1; ++i) {
                if (!this.allDisplayLists[i].isSetToPos(chunkRenderer.posXMinus, chunkRenderer.posYMinus, chunkRenderer.posZMinus)) continue;
                displayListIndex = i;
            }
            if (displayListIndex < 0) {
                displayListIndex = k1++;
                this.allDisplayLists[displayListIndex].setToPos(chunkRenderer.posXMinus, chunkRenderer.posYMinus, chunkRenderer.posZMinus, posX, posY, posZ);
            }
            this.allDisplayLists[displayListIndex].addCallToList(chunkRenderer.getGLCallListForPass(renderPass));
        }
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable((int)2912);
        }
        this.callAllDisplayLists(renderPass, renderPartialTicks);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable((int)2912);
        }
        return addedWorldRenderers;
    }

    public void callAllDisplayLists(int renderPass, double renderPartialTicks) {
        for (DisplayList displayList : this.allDisplayLists) {
            displayList.call();
        }
    }

    public void updateClouds() {
        float windDirection = this.worldObj.worldType.getWindManager().getWindDirection(this.worldObj, 0.0f, 500.0f, 0.0f);
        float windIntensity = this.worldObj.worldType.getWindManager().getWindIntensity(this.worldObj, 0.0f, 500.0f, 0.0f);
        float dx = -((float)(Math.cos((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        float dz = -((float)(Math.sin((double)windDirection * Math.PI * 2.0) * (double)windIntensity));
        this.cloudVelocityX += dx;
        this.cloudVelocityZ += dz;
        float maxVel = 1.5f;
        if (this.cloudVelocityX > maxVel) {
            this.cloudVelocityX = maxVel;
        }
        if (this.cloudVelocityX < -maxVel) {
            this.cloudVelocityX = -maxVel;
        }
        if (this.cloudVelocityZ > maxVel) {
            this.cloudVelocityZ = maxVel;
        }
        if (this.cloudVelocityZ < -maxVel) {
            this.cloudVelocityZ = -maxVel;
        }
        this.lastCloudOffsetX = this.cloudOffsetX;
        this.lastCloudOffsetZ = this.cloudOffsetZ;
        this.cloudOffsetX += this.cloudVelocityX;
        this.cloudOffsetZ += this.cloudVelocityZ;
    }

    public void drawSky(float renderPartialTicks) {
        if (this.mc.theWorld.dimension == Dimension.nether) {
            return;
        }
        float celestialAngle = this.worldObj.getCelestialAngle(renderPartialTicks);
        GL11.glDisable((int)3553);
        Vec3d vec3d = this.worldObj.getSkyColor(this.mc.activeCamera, renderPartialTicks);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Lighting.turnOn();
        float[] af = this.worldObj.worldType.getSunriseColor(celestialAngle, renderPartialTicks);
        if (af != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(celestialAngle <= 0.5f ? 0.0f : 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            float f10 = af[0];
            float f12 = af[1];
            float f14 = af[2];
            tessellator.startDrawing(6);
            tessellator.setColorRGBA_F(f10, f12, f14, af[3]);
            tessellator.addVertex(0.0, 100.0, 0.0);
            int i = 16;
            tessellator.setColorRGBA_F(af[0], af[1], af[2], 0.0f);
            for (int j = 0; j <= i; ++j) {
                float f20 = (float)j * 3.141593f * 2.0f / (float)i;
                float f21 = MathHelper.sin(f20);
                float f22 = MathHelper.cos(f20);
                tessellator.addVertex(f21 * 120.0f, f22 * 120.0f, -f22 * 40.0f * af[3]);
            }
            tessellator.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        float f6 = 1.0f - (this.worldObj.currentWeather != null && this.worldObj.currentWeather != Weather.overworldClear ? this.worldObj.weatherIntensity * this.worldObj.weatherPower * 1.5f : 0.0f);
        float f9 = 0.0f;
        float f11 = 0.0f;
        float f13 = 0.0f;
        GL11.glTranslatef((float)f9, (float)f11, (float)f13);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(celestialAngle * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        float f15 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/sun.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f15, 100.0, -f15, 0.0, 0.0);
        tessellator.addVertexWithUV(f15, 100.0, -f15, 1.0, 0.0);
        tessellator.addVertexWithUV(f15, 100.0, f15, 1.0, 1.0);
        tessellator.addVertexWithUV(-f15, 100.0, f15, 0.0, 1.0);
        tessellator.draw();
        f15 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain/moon.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f15, -100.0, f15, 1.0, 1.0);
        tessellator.addVertexWithUV(f15, -100.0, f15, 0.0, 1.0);
        tessellator.addVertexWithUV(f15, -100.0, -f15, 0.0, 0.0);
        tessellator.addVertexWithUV(-f15, -100.0, -f15, 1.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3553);
        float f17 = this.worldObj.getStarBrightness(renderPartialTicks) * f6;
        if (f17 > 0.0f) {
            GL11.glColor4f((float)f17, (float)f17, (float)f17, (float)f17);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        if (this.worldObj.worldType.hasGround()) {
            GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)f1, (float)f2, (float)f3);
        }
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderClouds(float renderPartialTicks) {
        if (this.mc.theWorld.dimension == Dimension.nether) {
            return;
        }
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            return;
        }
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            this.renderCloudsFancy(renderPartialTicks);
            return;
        }
        GL11.glDisable((int)2884);
        float cameraY = (float)this.mc.activeCamera.getY(renderPartialTicks);
        int cloudRadius = 32;
        int i = 256 / cloudRadius;
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3d dimensionColor = this.worldObj.getDimensionColor(renderPartialTicks);
        float r = (float)dimensionColor.xCoord;
        float g = (float)dimensionColor.yCoord;
        float b = (float)dimensionColor.zCoord;
        float f6 = 4.8828125E-4f;
        double posX = this.mc.activeCamera.getX(renderPartialTicks) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * renderPartialTicks) * 0.03f);
        double posZ = this.mc.activeCamera.getZ(renderPartialTicks) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * renderPartialTicks) * 0.03f);
        int j = MathHelper.floor_double(posX / 2048.0);
        int k = MathHelper.floor_double(posZ / 2048.0);
        float cloudHeight = this.worldObj.worldType.getCloudHeight() - cameraY + 0.33f;
        float f10 = (float)((posX -= (double)(j * 2048)) * (double)f6);
        float f11 = (float)((posZ -= (double)(k * 2048)) * (double)f6);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r, g, b, 0.8f);
        for (int cloudX = -cloudRadius * i; cloudX < cloudRadius * i; cloudX += cloudRadius) {
            for (int cloudZ = -cloudRadius * i; cloudZ < cloudRadius * i; cloudZ += cloudRadius) {
                tessellator.addVertexWithUV(cloudX + 0, cloudHeight, cloudZ + cloudRadius, (float)(cloudX + 0) * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ + cloudRadius, (float)(cloudX + cloudRadius) * f6 + f10, (float)(cloudZ + cloudRadius) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + cloudRadius, cloudHeight, cloudZ + 0, (float)(cloudX + cloudRadius) * f6 + f10, (float)(cloudZ + 0) * f6 + f11);
                tessellator.addVertexWithUV(cloudX + 0, cloudHeight, cloudZ + 0, (float)(cloudX + 0) * f6 + f10, (float)(cloudZ + 0) * f6 + f11);
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public void renderCloudsFancy(float renderPartialTicks) {
        GL11.glDisable((int)2884);
        float cameraY = (float)this.mc.activeCamera.getY(renderPartialTicks);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double dx = (this.mc.activeCamera.getX(renderPartialTicks) + (double)((this.lastCloudOffsetX + (this.cloudOffsetX - this.lastCloudOffsetX) * renderPartialTicks) * 0.03f)) / (double)cloudWidth;
        double dz = (this.mc.activeCamera.getZ(renderPartialTicks) + (double)((this.lastCloudOffsetZ + (this.cloudOffsetZ - this.lastCloudOffsetZ) * renderPartialTicks) * 0.03f)) / (double)cloudWidth + 0.33;
        float dy = this.worldObj.worldType.getCloudHeight() - cameraY + 0.33f;
        int i = MathHelper.floor_double(dx / 2048.0);
        int j = MathHelper.floor_double(dz / 2048.0);
        dx -= (double)(i * 2048);
        dz -= (double)(j * 2048);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/environment/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3d color = this.worldObj.getDimensionColor(renderPartialTicks);
        float red = (float)color.xCoord;
        float green = (float)color.yCoord;
        float blue = (float)color.zCoord;
        float f9 = (float)(dx * 0.0);
        float f11 = (float)(dz * 0.0);
        float f13 = 0.00390625f;
        f9 = (float)MathHelper.floor_double(dx) * f13;
        f11 = (float)MathHelper.floor_double(dz) * f13;
        float f14 = (float)(dx - (double)MathHelper.floor_double(dx));
        float f15 = (float)(dz - (double)MathHelper.floor_double(dz));
        int cloudWidthScale = 8;
        int radius = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)cloudWidth, (float)1.0f, (float)cloudWidth);
        for (int l = 0; l < 2; ++l) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            tessellator.startDrawingQuads();
            for (int ix = -radius + 1; ix <= radius; ++ix) {
                for (int iz = -radius + 1; iz <= radius; ++iz) {
                    float f17 = ix * cloudWidthScale;
                    float f18 = iz * cloudWidthScale;
                    float cloudX = f17 - f14;
                    float cloudZ = f18 - f15;
                    if (dy > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (dy <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + 0.0f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + (float)cloudWidthScale, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness - f16, cloudZ + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.setColorRGBA_F(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (ix > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        for (int k1 = 0; k1 < cloudWidthScale; ++k1) {
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)k1 + 0.0f, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    if (ix <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        for (int l1 = 0; l1 < cloudWidthScale; ++l1) {
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + (float)cloudWidthScale, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)cloudWidthScale) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + cloudThickness, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)l1 + 1.0f - f16, dy + 0.0f, cloudZ + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        }
                    }
                    tessellator.setColorRGBA_F(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (iz > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        for (int i2 = 0; i2 < cloudWidthScale; ++i2) {
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                        }
                    }
                    if (iz > 1) continue;
                    tessellator.setNormal(0.0f, 0.0f, 1.0f);
                    for (int j2 = 0; j2 < cloudWidthScale; ++j2) {
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + cloudThickness, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + (float)cloudWidthScale, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + (float)cloudWidthScale) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                        tessellator.addVertexWithUV(cloudX + 0.0f, dy + 0.0f, cloudZ + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                    }
                }
            }
            tessellator.draw();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public boolean updateRenderers(ICamera camera) {
        int j2;
        int numLayers = 2;
        ChunkRendererComparator comparator = new ChunkRendererComparator(camera);
        ChunkRenderer[] chunkRenderers = new ChunkRenderer[numLayers];
        ArrayList<ChunkRenderer> arraylist = null;
        int numChunkRenderersToUpdate = this.chunkRenderersToUpdate.size();
        int i1 = 0;
        for (int i = 0; i < numChunkRenderersToUpdate; ++i) {
            ChunkRenderer chunkRenderer = this.chunkRenderersToUpdate.get(i);
            if (chunkRenderer.distanceToCameraSquared(camera) > 256.0f) {
                int k2;
                for (k2 = 0; k2 < numLayers && (chunkRenderers[k2] == null || comparator.compare(chunkRenderers[k2], chunkRenderer) <= 0); ++k2) {
                }
                if (--k2 <= 0) continue;
                int i3 = k2;
                while (--i3 != 0) {
                    chunkRenderers[i3 - 1] = chunkRenderers[i3];
                }
                chunkRenderers[k2] = chunkRenderer;
                continue;
            }
            if (arraylist == null) {
                arraylist = new ArrayList<ChunkRenderer>();
            }
            ++i1;
            arraylist.add(chunkRenderer);
            this.chunkRenderersToUpdate.set(i, null);
        }
        if (arraylist != null) {
            if (arraylist.size() > 1) {
                arraylist.sort(comparator);
            }
            for (int k1 = arraylist.size() - 1; k1 >= 0; --k1) {
                ChunkRenderer worldrenderer2 = (ChunkRenderer)arraylist.get(k1);
                worldrenderer2.updateRenderer();
                worldrenderer2.needsUpdate = false;
            }
        }
        int l1 = 0;
        for (int i2 = numLayers - 1; i2 >= 0; --i2) {
            ChunkRenderer worldrenderer3 = chunkRenderers[i2];
            if (worldrenderer3 == null) continue;
            if (!worldrenderer3.isInFrustum && i2 != numLayers - 1) {
                chunkRenderers[i2] = null;
                chunkRenderers[0] = null;
                break;
            }
            chunkRenderers[i2].updateRenderer();
            chunkRenderers[i2].needsUpdate = false;
            ++l1;
        }
        int l2 = 0;
        int j3 = this.chunkRenderersToUpdate.size();
        for (j2 = 0; j2 != j3; ++j2) {
            ChunkRenderer worldrenderer4 = this.chunkRenderersToUpdate.get(j2);
            if (worldrenderer4 == null) continue;
            boolean flag2 = false;
            for (int k3 = 0; k3 < numLayers && !flag2; ++k3) {
                if (worldrenderer4 != chunkRenderers[k3]) continue;
                flag2 = true;
            }
            if (flag2) continue;
            if (l2 != j2) {
                this.chunkRenderersToUpdate.set(l2, worldrenderer4);
            }
            ++l2;
        }
        while (--j2 >= l2) {
            this.chunkRenderersToUpdate.remove(j2);
        }
        return numChunkRenderersToUpdate == i1 + l1;
    }

    public void drawBlockBreaking(ICamera camera, HitResult hitResult, float renderPartialTicks) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (this.damagePartialTime > 0.0f) {
            GL11.glBlendFunc((int)774, (int)768);
            int j = this.renderEngine.getTexture("/terrain.png");
            GL11.glBindTexture((int)3553, (int)j);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glPushMatrix();
            int k = this.worldObj.getBlockId(hitResult.x, hitResult.y, hitResult.z);
            Block block = k <= 0 ? null : Block.blocksList[k];
            GL11.glDisable((int)3008);
            GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
            GL11.glEnable((int)32823);
            double x = camera.getX(renderPartialTicks);
            double y = camera.getY(renderPartialTicks);
            double z = camera.getZ(renderPartialTicks);
            if (block == null) {
                block = Block.stone;
            }
            GL11.glEnable((int)3008);
            tessellator.startDrawingQuads();
            tessellator.setTranslation(-x, -y, -z);
            tessellator.disableColor();
            BlockModelRenderBlocks.setRenderBlocks(this.globalRenderBlocks);
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
            model.renderWithOverrideTexture(block, hitResult.x, hitResult.y, hitResult.z, Block.texCoordToIndex(0, 15) + (int)(this.damagePartialTime * 10.0f));
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            GL11.glDisable((int)3008);
            GL11.glPolygonOffset((float)0.0f, (float)0.0f);
            GL11.glDisable((int)32823);
            GL11.glEnable((int)3008);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void drawSelectionBox(ICamera camera, HitResult hitResult, float renderPartialTicks) {
        if (this.mc.gameSettings.immersiveMode.drawOutline()) {
            float expand;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float w = this.mc.getOutlineWidth();
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.35f + w * 0.3f));
            GL11.glLineWidth((float)Math.max(4.0f * w * 2.0f, 1.0f));
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            double offsetX = camera.getX(renderPartialTicks);
            double offsetY = camera.getY(renderPartialTicks);
            double offsetZ = camera.getZ(renderPartialTicks);
            if (hitResult.hitType == HitResult.HitType.TILE) {
                expand = 0.002f;
                int j = this.worldObj.getBlockId(hitResult.x, hitResult.y, hitResult.z);
                if (j > 0) {
                    BoundingVolume volume = Block.blocksList[j].getBoundingVolume(this.worldObj, hitResult.x, hitResult.y, hitResult.z);
                    if (volume != null) {
                        this.drawOutlinedVolume(volume, (double)hitResult.x - offsetX, (double)hitResult.y - offsetY, (double)hitResult.z - offsetZ, expand);
                    } else {
                        Block.blocksList[j].setBlockBoundsBasedOnState(this.worldObj, hitResult.x, hitResult.y, hitResult.z);
                        this.drawOutlinedBoundingBox(Block.blocksList[j].getSelectedBoundingBoxFromPool(this.worldObj, hitResult.x, hitResult.y, hitResult.z).expand(expand, expand, expand).getOffsetBoundingBox(-offsetX, -offsetY, -offsetZ));
                    }
                }
            } else if (hitResult.hitType == HitResult.HitType.ENTITY && hitResult.entity.showBoundingBoxOnHover()) {
                expand = 0.004f;
                this.drawOutlinedBoundingBox(hitResult.entity.bb.expand(expand, expand, expand).getOffsetBoundingBox(-offsetX, -offsetY, -offsetZ));
            }
            if (this.mc.debugCollision) {
                expand = 0.002f;
                List<AABB> collidingBoundingBoxes = this.worldObj.getCubes(this.mc.thePlayer, this.mc.thePlayer.bb.expand(expand, expand, expand));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                for (AABB aabb : collidingBoundingBoxes) {
                    this.drawOutlinedBoundingBox(aabb.getOffsetBoundingBox(-offsetX, -offsetY, -offsetZ).expand(expand, expand, expand));
                }
                float entityRadius = 5.0f;
                List<Entity> entitiesNearby = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, this.mc.thePlayer.bb.expand(entityRadius, entityRadius, entityRadius));
                for (Entity e : entitiesNearby) {
                    this.drawOutlinedBoundingBox(e.bb.getOffsetBoundingBox(-offsetX, -offsetY, -offsetZ));
                }
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    public void drawOutlinedBoundingBox(AABB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void drawOutlinedVolume(BoundingVolume volume, double xOffset, double yOffset, double zOffset, float expand) {
        Tessellator t = Tessellator.instance;
        t.startDrawing(1);
        Float[] points = volume.getBakedLineCoords();
        for (int i = 0; i < points.length; i += 3) {
            float expand0 = (points[i + 0].floatValue() - 0.5f) * 2.0f * expand;
            float expand1 = (points[i + 1].floatValue() - 0.5f) * 2.0f * expand;
            float expand2 = (points[i + 2].floatValue() - 0.5f) * 2.0f * expand;
            t.addVertex((double)points[i + 0].floatValue() + xOffset + (double)expand0, (double)points[i + 1].floatValue() + yOffset + (double)expand1, (double)points[i + 2].floatValue() + zOffset + (double)expand2);
        }
        t.draw();
    }

    public void markDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int wrMinX = MathHelper.bucketInt(minX, 16);
        int wrMinY = MathHelper.bucketInt(minY, 16);
        int wrMinZ = MathHelper.bucketInt(minZ, 16);
        int wrMaxX = MathHelper.bucketInt(maxX, 16);
        int wrMaxY = MathHelper.bucketInt(maxY, 16);
        int wrMaxZ = MathHelper.bucketInt(maxZ, 16);
        for (int wrX = wrMinX; wrX <= wrMaxX; ++wrX) {
            int realWrX = wrX % this.renderChunksWide;
            if (realWrX < 0) {
                realWrX += this.renderChunksWide;
            }
            for (int wrY = wrMinY; wrY <= wrMaxY; ++wrY) {
                int realWrY = wrY % this.renderChunksTall;
                if (realWrY < 0) {
                    realWrY += this.renderChunksTall;
                }
                for (int wrZ = wrMinZ; wrZ <= wrMaxZ; ++wrZ) {
                    int realWrZ = wrZ % this.renderChunksDeep;
                    if (realWrZ < 0) {
                        realWrZ += this.renderChunksDeep;
                    }
                    int i = (realWrZ * this.renderChunksTall + realWrY) * this.renderChunksWide + realWrX;
                    ChunkRenderer worldrenderer = this.chunkRenderers[i];
                    if (worldrenderer.needsUpdate) continue;
                    this.chunkRenderersToUpdate.add(worldrenderer);
                    worldrenderer.markDirty();
                }
            }
        }
    }

    @Override
    public void blockChanged(int x, int y, int z) {
        this.markDirty(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void setBlocksDirty(int x0, int y0, int z0, int x1, int y1, int z1) {
        this.markDirty(x0 - 1, y0 - 1, z0 - 1, x1 + 1, y1 + 1, z1 + 1);
    }

    public void clipRenderersByFrustum(CameraFrustum frustum, float renderPartialTicks) {
        for (int i = 0; i < this.chunkRenderers.length; ++i) {
            if (this.chunkRenderers[i].skipAllRenderPasses() || this.chunkRenderers[i].isInFrustum && (i + this.frustumCheckOffset & 0xF) != 0) continue;
            this.chunkRenderers[i].updateInFrustum(frustum, renderPartialTicks);
        }
        ++this.frustumCheckOffset;
    }

    @Override
    public void playStreamingMusic(String soundPath, int x, int y, int z) {
        if (soundPath != null) {
            this.mc.ingameGUI.setRecordPlayingMessage("C418 - " + soundPath);
        }
        this.mc.sndManager.playStreaming(soundPath, x, y, z, 1.0f, 1.0f);
    }

    @Override
    public void playSound(String soundPath, SoundType type, double x, double y, double z, float volume, float pitch) {
        float soundDistance = 16.0f;
        if (volume > 1.0f) {
            soundDistance *= volume;
        }
        if (this.mc.activeCamera.distanceToSqr(x, y, z) < (double)(soundDistance * soundDistance)) {
            this.mc.sndManager.playSound(soundPath, type, (float)x, (float)y, (float)z, volume, pitch);
        }
    }

    @Override
    public void playBlockSoundEffect(Block block, EnumBlockSoundEffectType soundType, double x, double y, double z) {
        if (block == null) {
            return;
        }
        BlockSound sound = (BlockSound)BlockSoundDispatcher.getInstance().getDispatch(block);
        if (sound == null) {
            return;
        }
        String name = soundType == EnumBlockSoundEffectType.MINE ? sound.getBreakSoundName() : sound.getStepSoundName();
        this.playSound(name, SoundType.WORLD_SOUNDS, x, y, z, soundType.modifyVolume(sound.getVolume()), soundType.modifyPitch(sound.getPitch()));
    }

    @Override
    public void addParticle(String particleKey, double x, double y, double z, double motionX, double motionY, double motionZ) {
        this.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, 16.0);
    }

    @Override
    public void addParticle(String particleId, double x, double y, double z, double motionX, double motionY, double motionZ, double maxDistance) {
        double d8;
        double d7;
        if (this.mc == null || this.mc.activeCamera == null || this.mc.effectRenderer == null) {
            return;
        }
        double d6 = this.mc.activeCamera.getX() - x;
        if (d6 * d6 + (d7 = this.mc.activeCamera.getY() - y) * d7 + (d8 = this.mc.activeCamera.getZ() - z) * d8 > maxDistance * maxDistance) {
            return;
        }
        if (particleId.equals("bubble")) {
            this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("smoke")) {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("note")) {
            this.mc.effectRenderer.addEffect(new EntityNoteFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("portal")) {
            this.mc.effectRenderer.addEffect(new EntityPortalFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("explode")) {
            this.mc.effectRenderer.addEffect(new EntityExplodeFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("flame")) {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, x, y, z, motionX, motionY, motionZ, EntityFlameFX.Type.ORANGE));
        } else if (particleId.equals("blueflame")) {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, x, y, z, motionX, motionY, motionZ, EntityFlameFX.Type.BLUE));
        } else if (particleId.equals("soulflame")) {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, x, y, z, motionX, motionY, motionZ, EntityFlameFX.Type.SOUL));
        } else if (particleId.equals("lava")) {
            this.mc.effectRenderer.addEffect(new EntityLavaFX(this.worldObj, x, y, z));
        } else if (particleId.equals("footstep")) {
            this.mc.effectRenderer.addEffect(new EntityFootStepFX(this.renderEngine, this.worldObj, x, y, z));
        } else if (particleId.equals("splash")) {
            this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("largesmoke")) {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, x, y, z, motionX, motionY, motionZ, 2.5f));
        } else if (particleId.equals("reddust")) {
            this.mc.effectRenderer.addEffect(new EntityReddustFX(this.worldObj, x, y, z, (float)motionX, (float)motionY, (float)motionZ));
        } else if (particleId.equals("snowballpoof")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x, y, z, Item.ammoSnowball));
        } else if (particleId.equals("snowshovel")) {
            this.mc.effectRenderer.addEffect(new EntitySnowShovelFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("slime")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x, y, z, Item.slimeball));
        } else if (particleId.equals("heart")) {
            this.mc.effectRenderer.addEffect(new EntityHeartFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("slimechunk")) {
            if (((Boolean)this.mc.gameSettings.slimeParticles.value).booleanValue()) {
                this.mc.effectRenderer.addEffect(new EntitySlimeChunkFX(this.worldObj, x, y, z, Item.slimeball));
            }
        } else if (particleId.equals("fireflyGreen")) {
            this.mc.effectRenderer.addEffect(new EntityFireflyFX(this.worldObj, x, y, z, motionX, motionY, motionZ, 2.5f, 0));
        } else if (particleId.equals("fireflyBlue")) {
            this.mc.effectRenderer.addEffect(new EntityFireflyFX(this.worldObj, x, y, z, motionX, motionY, motionZ, 2.5f, 1));
        } else if (particleId.equals("fireflyOrange")) {
            this.mc.effectRenderer.addEffect(new EntityFireflyFX(this.worldObj, x, y, z, motionX, motionY, motionZ, 2.5f, 2));
        } else if (particleId.equals("fireflyRed")) {
            this.mc.effectRenderer.addEffect(new EntityFireflyFX(this.worldObj, x, y, z, motionX, motionY, motionZ, 2.5f, 3));
        } else if (particleId.equals("arrowtrail")) {
            this.mc.effectRenderer.addEffect(new EntityArrowGoldenFX(this.worldObj, x, y, z, motionX, motionY, motionZ));
        } else if (particleId.equals("arrowbreak")) {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, x, y, z, Item.ammoArrowPurple));
        } else if (particleId.equals("fallingleaf")) {
            int id = this.worldObj.getBlockId((int)x, (int)y, (int)z);
            if (id != 0) {
                this.mc.effectRenderer.addEffect(new EntityLeafFX(this.worldObj, x, y, z, motionX, motionY, motionZ).func_4041_a((int)x, (int)y, (int)z));
            }
        } else if (particleId.equals("boatbreak")) {
            this.mc.effectRenderer.addEffect(new EntityDiggingFX(this.worldObj, x, y, z, motionX, motionY, motionZ, Block.planksOak, 0, 0));
        }
    }

    @Override
    public void allChanged() {
        for (ChunkRenderer chunkRenderer : this.chunkRenderers) {
            if (!chunkRenderer.isChunkLit || chunkRenderer.needsUpdate) continue;
            this.chunkRenderersToUpdate.add(chunkRenderer);
            chunkRenderer.markDirty();
        }
    }

    @Override
    public void tileEntityChanged(int x, int y, int z, TileEntity tileEntity) {
    }

    public void deleteRenderListBase() {
        GLAllocation.deleteDisplayList(this.glRenderListBase);
    }

    @Override
    public void levelEvent(EntityPlayer player, int id, int x, int y, int z, int data) {
        Random random = this.worldObj.rand;
        switch (id) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, x, y, z, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, x, y, z, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, x, y, z, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int j1 = data % 3 - 1;
                int k1 = data / 3 % 3 - 1;
                double d = (double)x + (double)j1 * 0.6 + 0.5;
                double d1 = (double)y + 0.5;
                double d2 = (double)z + (double)k1 * 0.6 + 0.5;
                for (int l1 = 0; l1 < 10; ++l1) {
                    double d3 = random.nextDouble() * 0.2 + 0.01;
                    double d4 = d + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k1 * 0.5;
                    double d5 = d1 + (random.nextDouble() - 0.5) * 0.5;
                    double d6 = d2 + (double)k1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d7 = (double)j1 * d3 + random.nextGaussian() * 0.01;
                    double d8 = -0.03 + random.nextGaussian() * 0.01;
                    double d9 = (double)k1 * d3 + random.nextGaussian() * 0.01;
                    this.addParticle("smoke", d4, d5, d6, d7, d8, d9);
                }
                break;
            }
            case 2001: {
                int i2 = data;
                if (i2 > 0) {
                    Block block = Block.blocksList[i2];
                    this.playBlockSoundEffect(block, EnumBlockSoundEffectType.MINE, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(x, y, z, data, this.worldObj.getBlockMetadata(x, y, z));
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[data] instanceof ItemRecord) {
                    this.worldObj.playRecord(((ItemRecord)Item.itemsList[data]).recordName, x, y, z);
                    break;
                }
                this.worldObj.playRecord(null, x, y, z);
                break;
            }
            case 1006: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
                break;
            }
            case 1007: {
                this.worldObj.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, this.worldObj.rand.nextFloat() * 0.25f + 0.6f);
            }
        }
    }

    @Override
    public void entityAdded(Entity entity) {
    }

    @Override
    public void entityRemoved(Entity entity) {
    }
}

