/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseFilter;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.render.EffectRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.EntityCameraIsometric;
import net.minecraft.client.render.camera.EntityCameraSleeping;
import net.minecraft.client.render.camera.EntityCameraThirdPersonFront;
import net.minecraft.client.render.camera.EntityCameraThirdPersonRear;
import net.minecraft.client.render.colorizer.ColorizerWater;
import net.minecraft.client.render.culling.Frustum;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.core.HitResult;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.fx.EntityRainFX;
import net.minecraft.core.entity.fx.EntitySmokeFX;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.Weather;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class WorldRenderer {
    public static final long nsPerSecond = 1000000000L;
    public static int anaglyphField;
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int rendererUpdateCount;
    private Entity pointedEntity = null;
    private MouseFilter mouseFilterXAxis = new MouseFilter();
    private MouseFilter mouseFilterYAxis = new MouseFilter();
    private MouseFilter mouseFilterDummy1 = new MouseFilter();
    private MouseFilter mouseFilterDummy2 = new MouseFilter();
    private MouseFilter mouseFilterDummy3 = new MouseFilter();
    private MouseFilter mouseFilterDummy4 = new MouseFilter();
    private float cameraDistance = 4.0f;
    private float cameraDistanceO = 4.0f;
    private float field_22226_t = 0.0f;
    private float field_22225_u = 0.0f;
    private float field_22224_v = 0.0f;
    private float field_22223_w = 0.0f;
    private float field_22222_x = 0.0f;
    private float field_22221_y = 0.0f;
    private float field_22220_z = 0.0f;
    private float field_22230_A = 0.0f;
    private double cameraZoom = 1.0;
    private double cameraYaw = 0.0;
    private double cameraPitch = 0.0;
    private long prevFrameTime = System.currentTimeMillis();
    private long systemTime = 0L;
    private Random random = new Random();
    private int rainSoundCounter = 0;
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float fogColor2;
    private float fogColor1;

    public WorldRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemRenderer = new ItemRenderer(minecraft);
    }

    public void updateRenderer() {
        this.fogColor2 = this.fogColor1;
        this.cameraDistanceO = this.cameraDistance;
        this.field_22225_u = this.field_22226_t;
        this.field_22223_w = this.field_22224_v;
        this.field_22221_y = this.field_22222_x;
        this.field_22230_A = this.field_22220_z;
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.mc.activeCamera.tick();
        float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
        fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower;
        float brightnessAtCamera = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(this.mc.activeCamera.getX(1.0f)), MathHelper.floor_double(this.mc.activeCamera.getY(1.0f)), MathHelper.floor_double(this.mc.activeCamera.getZ(1.0f)));
        if (this.mc.fullbright) {
            brightnessAtCamera = 1.0f;
        }
        float f1 = (float)(3 - ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).legacyValue) * fogModifier / 3.0f;
        float f2 = brightnessAtCamera * (1.0f - f1) + f1;
        this.fogColor1 += (f2 - this.fogColor1) * 0.1f;
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
    }

    public void getMouseOver(float partialTicks) {
        if (this.mc.activeCamera == null) {
            return;
        }
        if (this.mc.theWorld == null) {
            return;
        }
        double blockReach = this.mc.playerController.getBlockReachDistance();
        double entityReach = this.mc.playerController.getEntityReachDistance();
        Vec3d pos1 = this.mc.thePlayer.getPosition(partialTicks);
        Vec3d look = this.mc.thePlayer.getViewVector(partialTicks);
        Vec3d pos2 = pos1.addVector(look.xCoord * blockReach, look.yCoord * blockReach, look.zCoord * blockReach);
        this.mc.objectMouseOver = this.mc.theWorld.checkBlockCollisionBetweenPoints(pos1, pos2);
        pos1 = this.mc.thePlayer.getPosition(partialTicks);
        look = this.mc.thePlayer.getViewVector(partialTicks);
        pos2 = pos1.addVector(look.xCoord * entityReach, look.yCoord * entityReach, look.zCoord * entityReach);
        double hitBlockDistance = 1000.0;
        if (this.mc.objectMouseOver != null) {
            hitBlockDistance = pos1.distanceTo(this.mc.objectMouseOver.location);
        }
        this.pointedEntity = null;
        float expand = 1.0f;
        AABB entitySearchBox = this.mc.thePlayer.bb.addCoord(look.xCoord * entityReach, look.yCoord * entityReach, look.zCoord * entityReach).expand(expand, expand, expand);
        List<Entity> entities = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, entitySearchBox);
        double pointedEntityDistance = 0.0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (!entity.isSelectable()) continue;
            float hitRadius = entity.getPickRadius();
            AABB hitBox = entity.bb.expand(hitRadius, hitRadius, hitRadius);
            if (hitBox.isVecInside(pos1)) {
                this.pointedEntity = entity;
                pointedEntityDistance = 0.0;
                continue;
            }
            HitResult hitResult = hitBox.func_1169_a(pos1, pos2);
            if (hitResult == null) continue;
            double entityDistance = pos1.distanceTo(hitResult.location);
            if (this.pointedEntity != null && !(entityDistance < pointedEntityDistance)) continue;
            this.pointedEntity = entity;
            pointedEntityDistance = entityDistance;
        }
        if (pointedEntityDistance > hitBlockDistance || pointedEntityDistance > entityReach) {
            this.pointedEntity = null;
        }
        if (this.pointedEntity != null) {
            this.mc.objectMouseOver = new HitResult(this.pointedEntity);
        }
    }

    private float getFOVModifier(float renderPartialTicks, boolean isModifiedByFOV) {
        EntityLiving entityliving = null;
        if (this.mc.activeCamera instanceof EntityCamera) {
            entityliving = ((EntityCamera)this.mc.activeCamera).entity;
        }
        float f1 = 70.0f;
        if (isModifiedByFOV) {
            f1 = (int)(this.mc.activeCamera.getFov() * 100.0 + 30.0);
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.water, renderPartialTicks)) {
            f1 -= 10.0f;
        }
        if (entityliving != null && entityliving.health <= 0) {
            float f2 = (float)entityliving.deathTime + renderPartialTicks;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return f1 + this.field_22221_y + (this.field_22222_x - this.field_22221_y) * renderPartialTicks;
    }

    private void hurtCameraEffect(float renderPartialTicks) {
        if (!(this.mc.activeCamera instanceof EntityCamera)) {
            return;
        }
        EntityLiving entityliving = ((EntityCamera)this.mc.activeCamera).entity;
        float f1 = (float)entityliving.hurtTime - renderPartialTicks;
        if (entityliving.health <= 0) {
            float f2 = (float)entityliving.deathTime + renderPartialTicks;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f1 < 0.0f) {
            return;
        }
        f1 /= (float)entityliving.maxHurtTime;
        f1 = MathHelper.sin(f1 * f1 * f1 * f1 * 3.141593f);
        float f3 = entityliving.attackedAtYaw;
        GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void setupViewBobbing(float renderPartialTicks) {
        if (this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)((EntityCamera)this.mc.activeCamera).entity;
            float f1 = entityplayer.walkDist - entityplayer.walkDistO;
            float f2 = -(entityplayer.walkDist + f1 * renderPartialTicks);
            float f3 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * renderPartialTicks;
            float f4 = entityplayer.prevCameraPitch + (entityplayer.cameraPitch - entityplayer.prevCameraPitch) * renderPartialTicks;
            if (entityplayer.isSkating) {
                f2 *= 0.25f;
                f4 *= 0.25f;
            }
            GL11.glTranslatef((float)(MathHelper.sin(f2 * 3.141593f) * f3 * 0.5f), (float)(-Math.abs(MathHelper.cos(f2 * 3.141593f) * f3)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(f2 * 3.141593f) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos(f2 * 3.141593f - 0.2f) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void setupCamera(float renderPartialTicks) {
        if (this.mc.activeCamera instanceof EntityCamera) {
            EntityLiving entityliving = ((EntityCamera)this.mc.activeCamera).entity;
            if (this.mc.currentScreen instanceof GuiPhotoMode) {
                this.mc.activeCamera = new EntityCameraIsometric(this.mc, entityliving);
            } else if (entityliving.isPlayerSleeping()) {
                if (!(this.mc.activeCamera instanceof EntityCameraSleeping)) {
                    this.mc.activeCamera = new EntityCameraSleeping(this.mc, entityliving, MathHelper.floor_double(entityliving.x), MathHelper.floor_double(entityliving.y), MathHelper.floor_double(entityliving.z), this.mc.activeCamera.getX(renderPartialTicks), this.mc.activeCamera.getY(renderPartialTicks), this.mc.activeCamera.getZ(renderPartialTicks), this.mc.activeCamera.getYRot(renderPartialTicks), this.mc.activeCamera.getXRot(renderPartialTicks));
                }
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !(this.mc.activeCamera instanceof EntityCameraFirstPerson)) {
                this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, entityliving);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 1 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonRear)) {
                this.mc.activeCamera = new EntityCameraThirdPersonRear(this.mc, entityliving);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 2 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonFront)) {
                this.mc.activeCamera = new EntityCameraThirdPersonFront(this.mc, entityliving);
            }
        }
    }

    private void orientCamera(float renderPartialTicks) {
        this.setupCamera(renderPartialTicks);
        this.mc.activeCamera.applyGlTransformations();
        if (!(this.mc.currentScreen instanceof GuiPhotoMode) && !((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
            GL11.glRotatef((float)((float)this.mc.activeCamera.getXRot(renderPartialTicks)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(this.mc.activeCamera.getYRot(renderPartialTicks) + 180.0)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            GL11.glRotatef((float)((GuiPhotoMode)this.mc.currentScreen).getTilt(renderPartialTicks), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(45.0f + 45.0f * ((GuiPhotoMode)this.mc.currentScreen).getRotation(renderPartialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupCameraTransform(float renderPartialTicks) {
        float f2;
        this.farPlaneDistance = ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).chunks * 16;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f1 = 0.07f;
        float fov = this.getFOVModifier(renderPartialTicks, true);
        if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
            fov *= 0.45f;
        }
        if (this.mc.currentScreen instanceof GuiPhotoMode) {
            double div = Math.pow(2.0, ((GuiPhotoMode)this.mc.currentScreen).getZoom(renderPartialTicks));
            GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glOrtho((double)0.0, (double)((double)this.mc.resolution.width / div), (double)0.0, (double)((double)this.mc.resolution.height / div), (double)(this.farPlaneDistance * -2.0f), (double)(this.farPlaneDistance * 2.0f));
            GL11.glTranslatef((float)((GuiPhotoMode)this.mc.currentScreen).getPanX(renderPartialTicks), (float)(-((GuiPhotoMode)this.mc.currentScreen).getPanY(renderPartialTicks)), (float)0.0f);
        } else if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
            GLU.gluPerspective((float)fov, (float)((float)this.mc.resolution.width / (float)this.mc.resolution.height), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        } else {
            GLU.gluPerspective((float)fov, (float)((float)this.mc.resolution.width / (float)this.mc.resolution.height), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.hurtCameraEffect(renderPartialTicks);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue() && !(this.mc.currentScreen instanceof GuiPhotoMode)) {
            this.setupViewBobbing(renderPartialTicks);
        }
        if ((f2 = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * renderPartialTicks) > 0.0f) {
            float f3 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f3 *= f3;
            GL11.glRotatef((float)(((float)this.rendererUpdateCount + renderPartialTicks) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / f3), (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-((float)this.rendererUpdateCount + renderPartialTicks) * 20.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.orientCamera(renderPartialTicks);
    }

    private void setupPlayerCamera(float renderPartialTicks) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(renderPartialTicks, false);
        if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
            fov *= 0.45f;
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glScalef((float)1.0f, (float)1.0f, (float)0.01f);
        if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
        }
        GLU.gluPerspective((float)fov, (float)((float)this.mc.resolution.width / (float)this.mc.resolution.height), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glPushMatrix();
        this.hurtCameraEffect(renderPartialTicks);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(renderPartialTicks);
        }
        if (!((Integer)this.mc.gameSettings.thirdPersonView.value != 0 || this.mc.currentScreen instanceof GuiPhotoMode || !(this.mc.activeCamera instanceof EntityCamera) || ((EntityCamera)this.mc.activeCamera).entity.isPlayerSleeping() || !this.mc.gameSettings.immersiveMode.drawHand() || this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null)) {
            this.itemRenderer.renderItemInFirstPerson(renderPartialTicks);
        }
        GL11.glPopMatrix();
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).entity.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(renderPartialTicks);
            this.hurtCameraEffect(renderPartialTicks);
        }
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(renderPartialTicks);
        }
    }

    public void updateCameraAndRender(float renderPartialTicks) {
        if (this.mc.inGameHasFocus) {
            if (this.mc.inputType == InputType.KEYBOARD && Mouse.isGrabbed()) {
                float f1 = ((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() * 0.6f + 0.2f;
                float f2 = f1 * f1 * f1 * 8.0f;
                if (this.mc.gameSettings.keyZoom.isPressed() && this.mc.currentScreen == null) {
                    f2 *= 0.25f;
                }
                float f3 = (float)this.mc.mouseInput.deltaX * f2;
                float f4 = (float)this.mc.mouseInput.deltaY * f2;
                int l = 1;
                if (((Boolean)this.mc.gameSettings.invertMouse.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)this.mc.gameSettings.smoothCamera.value).booleanValue()) {
                    f3 = this.mouseFilterXAxis.func_22386_a(f3, 0.05f * f2);
                    f4 = this.mouseFilterYAxis.func_22386_a(f4, 0.05f * f2);
                }
                this.mc.thePlayer.interpolateTurn(f3, f4 * (float)l);
            }
            if (this.mc.inputType == InputType.CONTROLLER) {
                double speed = Time.delta * 2000.0 * (double)(((Float)this.mc.gameSettings.controllerSensitivity.value).floatValue() + 0.5f);
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.interpolateTurn((float)x, (float)y);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        int width = this.mc.resolution.scaledWidth;
        int height = this.mc.resolution.scaledHeight;
        int mouseX = Mouse.getX() * width / this.mc.resolution.width;
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.height - 1;
        int c = 200;
        if ((Integer)this.mc.gameSettings.limitFramerate.value == 1) {
            c = 120;
        }
        if ((Integer)this.mc.gameSettings.limitFramerate.value == 2) {
            c = 40;
        }
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        if (this.mc.theWorld != null) {
            long l1;
            this.mc.render.beginRenderWorld();
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 0) {
                this.renderWorld(renderPartialTicks, 0L);
            } else {
                this.renderWorld(renderPartialTicks, this.systemTime + 1000000000L / (long)c);
            }
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 2 && (l1 = (this.systemTime + 1000000000L / (long)c - System.nanoTime()) / 1000000L) > 0L && l1 < 500L) {
                try {
                    Thread.sleep(l1);
                }
                catch (InterruptedException interruptedexception) {
                    interruptedexception.printStackTrace();
                }
            }
            this.systemTime = System.nanoTime();
            this.mc.render.endRenderWorld();
            this.mc.ingameGUI.renderGameOverlay(renderPartialTicks, this.mc.currentScreen != null, mouseX, mouseY);
        } else {
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            this.setupScaledResolution();
            if ((Integer)this.mc.gameSettings.limitFramerate.value == 2) {
                long l2 = (this.systemTime + (long)(1000000000 / c) - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedexception1) {
                        interruptedexception1.printStackTrace();
                    }
                }
            }
            this.systemTime = System.nanoTime();
        }
        if (this.mc.currentScreen != null) {
            GL11.glClear((int)256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.drawScreen(mouseX, mouseY, renderPartialTicks);
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawCursor();
            }
            if (this.mc.currentScreen != null && this.mc.currentScreen.particleRenderer != null) {
                this.mc.currentScreen.particleRenderer.render(renderPartialTicks);
            }
        }
    }

    public void renderWorld(float renderPartialTicks, long updateRenderersUntil) {
        long l1;
        RenderGlobal renderGlobal = this.mc.renderGlobal;
        EffectRenderer effectRenderer = this.mc.effectRenderer;
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.getMouseOver(renderPartialTicks);
        EntityLiving activeEntity = null;
        if (this.mc.activeCamera instanceof EntityCamera) {
            activeEntity = ((EntityCamera)this.mc.activeCamera).entity;
        }
        if (activeEntity != null) {
            double viewEntityX = activeEntity.xOld + (activeEntity.x - activeEntity.xOld) * (double)renderPartialTicks;
            double viewEntityZ = activeEntity.zOld + (activeEntity.z - activeEntity.zOld) * (double)renderPartialTicks;
            IChunkProvider iChunkProvider = this.mc.theWorld.getChunkProvider();
            if (iChunkProvider instanceof ChunkProviderStatic) {
                ChunkProviderStatic chunkProviderStatic = (ChunkProviderStatic)iChunkProvider;
                int chunkX = MathHelper.floor_float((int)viewEntityX) >> 4;
                int chunkZ = MathHelper.floor_float((int)viewEntityZ) >> 4;
                chunkProviderStatic.setCurrentChunkOver(chunkX, chunkZ);
            }
        }
        this.updateFogColor(renderPartialTicks);
        GL11.glClear((int)16640);
        GL11.glEnable((int)2884);
        this.setupCameraTransform(renderPartialTicks);
        Frustum.getFrustum();
        if (((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).renderSky) {
            this.setupFog(-1, renderPartialTicks);
            renderGlobal.drawSky(renderPartialTicks);
        }
        GL11.glEnable((int)2912);
        this.setupFog(1, renderPartialTicks);
        if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
            GL11.glShadeModel((int)7425);
        }
        this.mc.renderGlobal.clipRenderersByFrustum(this.mc.activeCamera.getFrustum(), renderPartialTicks);
        if (((Boolean)this.mc.gameSettings.aurora.value).booleanValue() && this.mc.theWorld.getWorldType().hasAurora()) {
            renderGlobal.renderAurora(this.mc.activeCamera, renderPartialTicks);
        }
        while (!this.mc.renderGlobal.updateRenderers(this.mc.activeCamera) && updateRenderersUntil != 0L && (l1 = updateRenderersUntil - System.nanoTime()) >= 0L && l1 <= 1000000000L) {
        }
        this.setupFog(0, renderPartialTicks);
        GL11.glEnable((int)2912);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
        Lighting.turnOn();
        renderGlobal.sortAndRender(this.mc.activeCamera, 0, renderPartialTicks);
        GL11.glShadeModel((int)7424);
        Lighting.turnOff();
        renderGlobal.renderEntities(this.mc.activeCamera, renderPartialTicks);
        effectRenderer.renderParticlesAtOrigin(renderPartialTicks);
        Lighting.turnOn();
        this.setupFog(0, renderPartialTicks);
        effectRenderer.renderParticles(this.mc.activeCamera, renderPartialTicks);
        if (this.mc.objectMouseOver != null) {
            GL11.glDisable((int)3008);
            renderGlobal.drawBlockBreaking(this.mc.activeCamera, this.mc.objectMouseOver, renderPartialTicks);
            renderGlobal.drawSelectionBox(this.mc.activeCamera, this.mc.objectMouseOver, renderPartialTicks);
            GL11.glEnable((int)3008);
        }
        GL11.glBlendFunc((int)770, (int)771);
        this.setupFog(0, renderPartialTicks);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
        if ((Integer)this.mc.gameSettings.fancyGraphics.value == 1) {
            if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
                GL11.glShadeModel((int)7425);
            }
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            int i1 = renderGlobal.sortAndRender(this.mc.activeCamera, 1, renderPartialTicks);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (i1 > 0) {
                renderGlobal.callAllDisplayLists(1, renderPartialTicks);
            }
            GL11.glShadeModel((int)7424);
        } else {
            renderGlobal.sortAndRender(this.mc.activeCamera, 1, renderPartialTicks);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.renderRainSnow(renderPartialTicks);
        GL11.glDisable((int)2912);
        if (this.pointedEntity == null) {
            // empty if block
        }
        if (((Boolean)this.mc.gameSettings.clouds.value).booleanValue()) {
            this.setupFog(0, renderPartialTicks);
            GL11.glEnable((int)2912);
            renderGlobal.renderClouds(renderPartialTicks);
            GL11.glDisable((int)2912);
        }
        this.setupFog(1, renderPartialTicks);
        if (this.cameraZoom == 1.0) {
            this.setupPlayerCamera(renderPartialTicks);
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    private void addRainParticles() {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.spawnRainParticles) {
            return;
        }
        float f = this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower;
        if ((Integer)this.mc.gameSettings.fancyGraphics.value != 1) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        World world = this.mc.theWorld;
        int cameraX = MathHelper.floor_double(this.mc.activeCamera.getX());
        int cameraY = MathHelper.floor_double(this.mc.activeCamera.getY());
        int cameraZ = MathHelper.floor_double(this.mc.activeCamera.getZ());
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        block0: for (int i1 = 0; i1 < (int)(100.0f * f * f); ++i1) {
            int randX = cameraX + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int randZ = cameraZ + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int y = world.findTopSolidBlock(randX, randZ);
            int i2 = world.getBlockId(randX, y - 1, randZ);
            Biome biome = world.getBlockBiome(randX, y, randZ);
            for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                if (biome.blockedWeathers[q] == weather) continue block0;
            }
            if (y > cameraY + byte0 || y < cameraY - byte0) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (i2 <= 0) continue;
            if (Block.blocksList[i2].blockMaterial == Material.lava) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(world, (float)randX + f1, (double)((float)y + 0.1f) - Block.blocksList[i2].minY, (float)randZ + f2, 0.0, 0.0, 0.0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)randX + f1;
                d1 = (double)((float)y + 0.1f) - Block.blocksList[i2].minY;
                d2 = (float)randZ + f2;
            }
            this.mc.effectRenderer.addEffect(new EntityRainFX(world, (float)randX + f1, (double)((float)y + 0.1f) - Block.blocksList[i2].minY, (float)randZ + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > this.mc.activeCamera.getY() + 1.0 && world.getHeightValue(MathHelper.floor_double(this.mc.activeCamera.getX()), MathHelper.floor_double(this.mc.activeCamera.getZ())) > MathHelper.floor_double(this.mc.activeCamera.getY())) {
                this.mc.theWorld.playSoundEffect(SoundType.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.1f * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower * 0.5f, 0.5f);
            } else {
                this.mc.theWorld.playSoundEffect(SoundType.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.2f * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower * 0.5f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float renderPartialTicks) {
        Weather weather = this.mc.theWorld.getCurrentWeather();
        if (weather == null || !weather.isPrecipitation) {
            return;
        }
        World world = this.mc.theWorld;
        int posX = MathHelper.floor_double(this.mc.activeCamera.getX());
        int posY = MathHelper.floor_double(this.mc.activeCamera.getY());
        int posZ = MathHelper.floor_double(this.mc.activeCamera.getZ());
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture(weather.texturePath));
        double nextPosX = this.mc.activeCamera.getX(renderPartialTicks);
        double nextPosY = this.mc.activeCamera.getY(renderPartialTicks);
        double nextPosZ = this.mc.activeCamera.getZ(renderPartialTicks);
        int floorPosY = MathHelper.floor_double(nextPosY);
        int radiusEffect = 10;
        if (weather.precipitationType == 1) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block1: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int i3;
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
                        if (biomegenbase.blockedWeathers[q] == weather) continue block1;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if ((i3 = y) < floorPosY) {
                        i3 = floorPosY;
                    }
                    int k3 = posY - radiusEffect;
                    int i4 = posY + radiusEffect;
                    if (k3 < y) {
                        k3 = y;
                    }
                    if (i4 < y) {
                        i4 = y;
                    }
                    float f3 = 1.0f;
                    if (k3 == i4) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f5 = (float)this.rendererUpdateCount + renderPartialTicks;
                    float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + renderPartialTicks) / 512.0f;
                    float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d5 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d6 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f11 = MathHelper.sqrt_double(d5 * d5 + d6 * d6) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f12 = world.getLightBrightness(x, i3, z);
                    if (this.mc.fullbright) {
                        f12 = 1.0f;
                    }
                    GL11.glColor4f((float)f12, (float)f12, (float)f12, (float)(((1.0f - f11 * f11) * 0.3f + 0.5f) * world.weatherIntensity * world.weatherPower));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, k3, (double)z + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, k3, (double)z + 0.5, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, i4, (double)z + 0.5, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 0, i4, (double)z + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 0, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 1, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 1, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 0, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (weather.precipitationType == 0) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block4: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase1 = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase1.blockedWeathers.length; ++q) {
                        if (biomegenbase1.blockedWeathers[q] == weather) continue block4;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < y) {
                        j3 = y;
                    }
                    if (l3 < y) {
                        l3 = y;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f4 = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + renderPartialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)(((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherIntensity - 0.1f) * world.weatherPower));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (weather.precipitationType == 2) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block7: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int topSolidY = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, topSolidY, z);
                    for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] == weather) continue block7;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < topSolidY) {
                        j3 = topSolidY;
                    }
                    if (l3 < topSolidY) {
                        l3 = topSolidY;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float vOffset = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + renderPartialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)(((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherIntensity - 0.1f) * world.weatherPower));
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    public void setupScaledResolution() {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidthExact, (double)this.mc.resolution.scaledHeightExact, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void updateFogColor(float renderPartialTicks) {
        World world = this.mc.theWorld;
        float f1 = 1.0f / (float)(4 - ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).legacyValue);
        f1 = 1.0f - (float)Math.pow(f1, 0.25);
        Vec3d vec3d = world.getSkyColor(this.mc.activeCamera, renderPartialTicks);
        float f2 = (float)vec3d.xCoord;
        float f3 = (float)vec3d.yCoord;
        float f4 = (float)vec3d.zCoord;
        Vec3d vec3d1 = world.getFogColor(renderPartialTicks);
        this.fogColorRed = (float)vec3d1.xCoord;
        this.fogColorGreen = (float)vec3d1.yCoord;
        this.fogColorBlue = (float)vec3d1.zCoord;
        this.fogColorRed += (f2 - this.fogColorRed) * f1;
        this.fogColorGreen += (f3 - this.fogColorGreen) * f1;
        this.fogColorBlue += (f4 - this.fogColorBlue) * f1;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, world.weatherIntensity * world.weatherPower);
            this.fogColorRed = out[0];
            this.fogColorGreen = out[1];
            this.fogColorBlue = out[2];
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.water, renderPartialTicks)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
            if (((Boolean)this.mc.gameSettings.biomeWater.value).booleanValue()) {
                int x = MathHelper.floor_double(this.mc.activeCamera.getX(renderPartialTicks));
                int z = MathHelper.floor_double(this.mc.activeCamera.getZ(renderPartialTicks));
                double temp = world.getBlockTemperature(x, z);
                double humid = world.getBlockHumidity(x, z);
                int waterColor = ColorizerWater.getWaterColor(temp, humid);
                float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(waterColor & 0xFF) / 255.0f;
                if (red < 0.0f) {
                    red = 0.0f;
                }
                if (red > 1.0f) {
                    red = 1.0f;
                }
                if (green < 0.0f) {
                    green = 0.0f;
                }
                if (green > 1.0f) {
                    green = 1.0f;
                }
                if (blue < 0.0f) {
                    blue = 0.0f;
                }
                if (blue > 1.0f) {
                    blue = 1.0f;
                }
                this.fogColorRed = red * 0.5f;
                this.fogColorGreen = green * 0.5f;
                this.fogColorBlue = blue * 0.5f;
            }
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.lava, renderPartialTicks)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float f10 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * renderPartialTicks;
        this.fogColorRed *= f10;
        this.fogColorGreen *= f10;
        this.fogColorBlue *= f10;
        GL11.glClearColor((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void setupFog(int i, float renderPartialTicks) {
        GL11.glFog((int)2918, (FloatBuffer)this.getFogColor(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 0.5f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.water, renderPartialTicks)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.lava, renderPartialTicks)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
        } else {
            float maxFogDistance = RenderDistance.EXTREME.chunks * 16;
            float fogDistance = this.farPlaneDistance;
            float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
            if (fogDistance > maxFogDistance * (fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherIntensity * this.mc.theWorld.weatherPower)) {
                fogDistance = maxFogDistance * fogModifier;
            }
            if (this.mc.currentScreen instanceof GuiPhotoMode) {
                fogDistance = this.farPlaneDistance * ((GuiPhotoMode)this.mc.currentScreen).getFog(renderPartialTicks);
            }
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(fogDistance * 0.25f));
            GL11.glFogf((int)2916, (float)fogDistance);
            GL11.glFogf((int)2914, (float)1.0f);
            if (i < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(fogDistance * 0.8f));
            }
            if (OpenGLHelper.enableSphericalFog) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.theWorld.dimension == Dimension.nether) {
                GL11.glFogf((int)2915, (float)0.0f);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer getFogColor(float r, float g, float b, float a) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(r).put(g).put(b).put(a);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

