/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

public abstract class DynamicTexture {
    public final int resolution;
    public final int textureIndex;
    public final int tileWidth;
    public final int tileHeight;
    public final byte[] imageData;
    protected boolean anaglyphEnabled = false;

    public DynamicTexture(int textureIndex, int resolution, int tileWidth) {
        this(textureIndex, resolution, tileWidth, tileWidth);
    }

    public DynamicTexture(int textureIndex, int resolution, int tileWidth, int tileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.textureIndex = textureIndex;
        this.resolution = resolution;
        this.imageData = new byte[resolution * resolution * 4];
    }

    public abstract void update();

    public abstract String getTextureName();

    public static int pmod(int a, int b) {
        while (a < 0) {
            a += b;
        }
        return a %= b;
    }

    public static void putPixel(byte[] array, int i, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        array[i * 4 + 0] = (byte)r;
        array[i * 4 + 1] = (byte)g;
        array[i * 4 + 2] = (byte)b;
        array[i * 4 + 3] = (byte)a;
    }

    public static void transferPixel(byte[] array1, int i, byte[] array2, int j) {
        array2[j * 4 + 0] = array1[i * 4 + 0];
        array2[j * 4 + 1] = array1[i * 4 + 1];
        array2[j * 4 + 2] = array1[i * 4 + 2];
        array2[j * 4 + 3] = array1[i * 4 + 3];
    }
}

