/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ImageParser;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.TextureFX;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public abstract class EntityRenderer<T extends Entity> {
    protected EntityRenderDispatcher renderDispatcher;
    protected float shadowSize = 0.0f;
    protected float shadowOpacity = 1.0f;

    public abstract void doRender(T var1, double var2, double var4, double var6, float var8, float var9);

    protected void loadTexture(String texturePath) {
        RenderEngine renderEngine = this.renderDispatcher.renderEngine;
        renderEngine.bindTexture(renderEngine.getTexture(texturePath));
    }

    private void renderFire(T entity, double d, double d1, double d2, float renderPartialTicks) {
        GL11.glDisable((int)2896);
        int i = Block.texCoordToIndex(15, 1);
        int j = i % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = i / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float f1 = (float)j / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f3 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f5 = (float)k / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f7 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        float f9 = ((Entity)entity).bbWidth * 1.4f;
        GL11.glScalef((float)f9, (float)f9, (float)f9);
        this.loadTexture("/terrain.png");
        Tessellator tessellator = Tessellator.instance;
        float f10 = 0.5f;
        float f11 = 0.0f;
        float f12 = ((Entity)entity).bbHeight;
        float f13 = (float)(((Entity)entity).y - ((Entity)entity).bb.minY);
        GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f12) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f14 = 0.0f;
        int l = 0;
        tessellator.startDrawingQuads();
        while (f12 > 0.0f) {
            float f8;
            float f6;
            float f4;
            float f2;
            if (l % 2 == 0) {
                f2 = (float)j / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)k / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            } else {
                f2 = (float)j / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)(k + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)(k + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            }
            if (l / 2 % 2 == 0) {
                float f15 = f4;
                f4 = f2;
                f2 = f15;
            }
            tessellator.addVertexWithUV(f10 - f11, 0.0f - f13, f14, f4, f8);
            tessellator.addVertexWithUV(-f10 - f11, 0.0f - f13, f14, f2, f8);
            tessellator.addVertexWithUV(-f10 - f11, 1.4f - f13, f14, f2, f6);
            tessellator.addVertexWithUV(f10 - f11, 1.4f - f13, f14, f4, f6);
            f12 -= 0.45f;
            f13 -= 0.45f;
            f10 *= 0.9f;
            f14 += 0.03f;
            ++l;
        }
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(T entity, double posX, double posY, double posZ, float opacity, float renderPartialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderEngine renderengine = this.renderDispatcher.renderEngine;
        renderengine.bindTexture(renderengine.getTexture("%clamp%/misc/shadow.png"));
        World world = this.getWorld();
        GL11.glDepthMask((boolean)false);
        double lerpX = ((Entity)entity).xOld + (((Entity)entity).x - ((Entity)entity).xOld) * (double)renderPartialTicks;
        double lerpY = ((Entity)entity).yOld + (((Entity)entity).y - ((Entity)entity).yOld) * (double)renderPartialTicks + (double)((Entity)entity).getShadowHeightOffs();
        double lerpZ = ((Entity)entity).zOld + (((Entity)entity).z - ((Entity)entity).zOld) * (double)renderPartialTicks;
        int minX = MathHelper.floor_double(lerpX - (double)this.shadowSize);
        int maxX = MathHelper.floor_double(lerpX + (double)this.shadowSize);
        int minY = MathHelper.floor_double(lerpY - (double)this.shadowSize);
        int maxY = MathHelper.floor_double(lerpY);
        int minZ = MathHelper.floor_double(lerpZ - (double)this.shadowSize);
        int maxZ = MathHelper.floor_double(lerpZ + (double)this.shadowSize);
        double dxLerp = posX - lerpX;
        double dyLerp = posY - lerpY;
        double dzLerp = posZ - lerpZ;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int blockX = minX; blockX <= maxX; ++blockX) {
            for (int blockY = minY; blockY <= maxY; ++blockY) {
                for (int blockZ = minZ; blockZ <= maxZ; ++blockZ) {
                    int blockId = world.getBlockId(blockX, blockY - 1, blockZ);
                    if (blockId <= 0 || world.getBlockLightValue(blockX, blockY, blockZ) <= 3) continue;
                    this.renderShadowOnBlock(Block.blocksList[blockId], posX, posY + (double)((Entity)entity).getShadowHeightOffs(), posZ, blockX, blockY, blockZ, opacity, this.shadowSize, dxLerp, dyLerp + (double)((Entity)entity).getShadowHeightOffs(), dzLerp);
                }
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorld() {
        return this.renderDispatcher.world;
    }

    private void renderShadowOnBlock(Block block, double d, double d1, double d2, int i, int j, int k, float opacity, float size, double d3, double d4, double d5) {
        double d6;
        Tessellator tessellator = Tessellator.instance;
        if (!block.renderAsNormalBlock()) {
            return;
        }
        double brightness = this.getWorld().getLightBrightness(i, j, k);
        if (Minecraft.getMinecraft((Object)this).fullbright) {
            brightness = 1.0;
        }
        if ((d6 = ((double)opacity - (d1 - ((double)j + d4)) / 2.0) * 0.5 * brightness) < 0.0) {
            return;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)d6);
        double d7 = (double)i + block.minX + d3;
        double d8 = (double)i + block.maxX + d3;
        double d9 = (double)j + block.minY + d4 + 0.015625;
        double d10 = (double)k + block.minZ + d5;
        double d11 = (double)k + block.maxZ + d5;
        float f2 = (float)((d - d7) / 2.0 / (double)size + 0.5);
        float f3 = (float)((d - d8) / 2.0 / (double)size + 0.5);
        float f4 = (float)((d2 - d10) / 2.0 / (double)size + 0.5);
        float f5 = (float)((d2 - d11) / 2.0 / (double)size + 0.5);
        tessellator.addVertexWithUV(d7, d9, d10, f2, f4);
        tessellator.addVertexWithUV(d7, d9, d11, f2, f5);
        tessellator.addVertexWithUV(d8, d9, d11, f3, f5);
        tessellator.addVertexWithUV(d8, d9, d10, f3, f4);
    }

    public static void renderOffsetAABB(AABB axisalignedbb, double d, double d1, double d2) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setTranslation(d, d1, d2);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AABB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void setRenderDispatcher(EntityRenderDispatcher dispatcher) {
        this.renderDispatcher = dispatcher;
    }

    public void doRenderShadowAndFire(T entity, double x, double y, double z, float f, float renderPartialTicks) {
        double distance;
        float opacity;
        if (this.renderDispatcher.gameSettings != null && (Integer)this.renderDispatcher.gameSettings.fancyGraphics.value == 1 && this.shadowSize > 0.0f && (opacity = (float)((1.0 - (distance = this.renderDispatcher.distanceToLerpSquared(((Entity)entity).x, ((Entity)entity).y, ((Entity)entity).z)) / 256.0) * (double)this.shadowOpacity)) > 0.0f) {
            this.renderShadow(entity, x, y, z, opacity, renderPartialTicks);
        }
        if (((Entity)entity).isOnFire()) {
            this.renderFire(entity, x, y, z, renderPartialTicks);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.renderDispatcher.getFontRenderer();
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        return this.renderDispatcher.renderEngine.loadDownloadableTexture(url, localTexture, imageParser);
    }
}

