/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.Polygon;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.Vertex;
import org.lwjgl.opengl.GL11;

public class Cube {
    private Vertex[] vertices;
    private Polygon[] polygons;
    private final int xTexOffs;
    private final int yTexOffs;
    private final int texWidth;
    private final int texHeight;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    private boolean compiled = false;
    private int list = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean unknownField = false;

    public Cube(int xTexOffs, int yTexOffs, int texWidth, int texHeight) {
        this.xTexOffs = xTexOffs;
        this.yTexOffs = yTexOffs;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
    }

    public Cube(int xTexOffs, int yTexOffs) {
        this(xTexOffs, yTexOffs, 64, 32);
    }

    public void addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ) {
        this.addBox(minX, minY, minZ, sizeX, sizeY, sizeZ, 0.0f);
    }

    public void addBox(float x0, float y0, float z0, int w, int h, int d, float expandAmount) {
        this.vertices = new Vertex[8];
        this.polygons = new Polygon[6];
        float x1 = x0 + (float)w;
        float y1 = y0 + (float)h;
        float z1 = z0 + (float)d;
        x0 -= expandAmount;
        y0 -= expandAmount;
        z0 -= expandAmount;
        x1 += expandAmount;
        y1 += expandAmount;
        z1 += expandAmount;
        if (this.mirror) {
            float temp = x1;
            x1 = x0;
            x0 = temp;
        }
        Vertex u0 = new Vertex(x0, y0, z0, 0.0f, 0.0f);
        Vertex u1 = new Vertex(x1, y0, z0, 0.0f, 8.0f);
        Vertex u2 = new Vertex(x1, y1, z0, 8.0f, 8.0f);
        Vertex u3 = new Vertex(x0, y1, z0, 8.0f, 0.0f);
        Vertex l0 = new Vertex(x0, y0, z1, 0.0f, 0.0f);
        Vertex l1 = new Vertex(x1, y0, z1, 0.0f, 8.0f);
        Vertex l2 = new Vertex(x1, y1, z1, 8.0f, 8.0f);
        Vertex l3 = new Vertex(x0, y1, z1, 8.0f, 0.0f);
        this.vertices[0] = u0;
        this.vertices[1] = u1;
        this.vertices[2] = u2;
        this.vertices[3] = u3;
        this.vertices[4] = l0;
        this.vertices[5] = l1;
        this.vertices[6] = l2;
        this.vertices[7] = l3;
        this.polygons[0] = new Polygon(new Vertex[]{l1, u1, u2, l2}, this.xTexOffs + d + w, this.yTexOffs + d, this.xTexOffs + d + w + d, this.yTexOffs + d + h, this.texWidth, this.texHeight);
        this.polygons[1] = new Polygon(new Vertex[]{u0, l0, l3, u3}, this.xTexOffs, this.yTexOffs + d, this.xTexOffs + d, this.yTexOffs + d + h, this.texWidth, this.texHeight);
        this.polygons[2] = new Polygon(new Vertex[]{l1, l0, u0, u1}, this.xTexOffs + d, this.yTexOffs, this.xTexOffs + d + w, this.yTexOffs + d, this.texWidth, this.texHeight);
        this.polygons[3] = new Polygon(new Vertex[]{l2, l3, u3, u2}, this.xTexOffs + d + w, this.yTexOffs, this.xTexOffs + d + w + w, this.yTexOffs + d, this.texWidth, this.texHeight);
        this.polygons[3].invertNormal = true;
        this.polygons[4] = new Polygon(new Vertex[]{u1, u0, u3, u2}, this.xTexOffs + d, this.yTexOffs + d, this.xTexOffs + d + w, this.yTexOffs + d + h, this.texWidth, this.texHeight);
        this.polygons[5] = new Polygon(new Vertex[]{l0, l1, l2, l3}, this.xTexOffs + d + w + d, this.yTexOffs + d, this.xTexOffs + d + w + d + w, this.yTexOffs + d + h, this.texWidth, this.texHeight);
        if (this.mirror) {
            for (Polygon p : this.polygons) {
                p.flipFace();
            }
        }
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setRot(float x, float y, float z) {
        this.xRot = x;
        this.yRot = y;
        this.zRot = z;
    }

    public void render(float scale) {
        if (this.unknownField) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
            if (this.zRot != 0.0f) {
                GL11.glRotatef((float)(this.zRot * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.yRot != 0.0f) {
                GL11.glRotatef((float)(this.yRot * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.xRot != 0.0f) {
                GL11.glRotatef((float)(this.xRot * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.list);
            GL11.glPopMatrix();
        } else if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
            GL11.glCallList((int)this.list);
            GL11.glTranslatef((float)(-this.x * scale), (float)(-this.y * scale), (float)(-this.z * scale));
        } else {
            GL11.glCallList((int)this.list);
        }
    }

    public void renderWithRotation(float scale) {
        if (this.unknownField) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
        if (this.yRot != 0.0f) {
            GL11.glRotatef((float)(this.yRot * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.xRot != 0.0f) {
            GL11.glRotatef((float)(this.xRot * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.zRot != 0.0f) {
            GL11.glRotatef((float)(this.zRot * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.list);
        GL11.glPopMatrix();
    }

    public void postRender(float scale) {
        if (this.unknownField) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compile(scale);
        }
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
            if (this.zRot != 0.0f) {
                GL11.glRotatef((float)(this.zRot * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.yRot != 0.0f) {
                GL11.glRotatef((float)(this.yRot * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.xRot != 0.0f) {
                GL11.glRotatef((float)(this.xRot * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)(this.x * scale), (float)(this.y * scale), (float)(this.z * scale));
        }
    }

    private void compile(float scale) {
        this.list = GLAllocation.generateDisplayLists(1);
        GL11.glNewList((int)this.list, (int)4864);
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.polygons.length; ++i) {
            this.polygons[i].draw(tessellator, scale);
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

