/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

public class ModelBiped
extends ModelBase {
    public Cube bipedHead;
    public Cube bipedHeadOverlay;
    public Cube bipedBody;
    public Cube bipedRightArm;
    public Cube bipedLeftArm;
    public Cube bipedRightLeg;
    public Cube bipedLeftLeg;
    public Cube bipedEars;
    public Cube bipedCloak = new Cube(0, 0);
    public boolean field_1279_h = false;
    public boolean field_1278_i = false;
    public boolean isSneak = false;

    public ModelBiped() {
        this(0.0f);
    }

    public ModelBiped(float f) {
        this(f, 0.0f);
    }

    public ModelBiped(float f, float f1) {
        this.bipedCloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, f);
        this.bipedEars = new Cube(24, 0);
        this.bipedEars.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, f);
        this.bipedHead = new Cube(0, 0);
        this.bipedHead.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, f);
        this.bipedHead.setPos(0.0f, 0.0f + f1, 0.0f);
        this.bipedHeadOverlay = new Cube(32, 0);
        this.bipedHeadOverlay.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, f + 0.5f);
        this.bipedHeadOverlay.setPos(0.0f, 0.0f + f1, 0.0f);
        this.bipedBody = new Cube(16, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, f);
        this.bipedBody.setPos(0.0f, 0.0f + f1, 0.0f);
        this.bipedRightArm = new Cube(40, 16);
        this.bipedRightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, f);
        this.bipedRightArm.setPos(-5.0f, 2.0f + f1, 0.0f);
        this.bipedLeftArm = new Cube(40, 16);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, f);
        this.bipedLeftArm.setPos(5.0f, 2.0f + f1, 0.0f);
        this.bipedRightLeg = new Cube(0, 16);
        this.bipedRightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, f);
        this.bipedRightLeg.setPos(-2.0f, 12.0f + f1, 0.0f);
        this.bipedLeftLeg = new Cube(0, 16);
        this.bipedLeftLeg.mirror = true;
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, f);
        this.bipedLeftLeg.setPos(2.0f, 12.0f + f1, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.setRotationAngles(limbSwing, limbYaw, ticksExisted, headYaw, headPitch, scale);
        this.bipedHead.render(scale);
        this.bipedBody.render(scale);
        this.bipedRightArm.render(scale);
        this.bipedLeftArm.render(scale);
        this.bipedRightLeg.render(scale);
        this.bipedLeftLeg.render(scale);
        this.bipedHeadOverlay.render(scale);
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.bipedHead.yRot = headYaw / 57.29578f;
        this.bipedHead.xRot = headPitch / 57.29578f;
        this.bipedHeadOverlay.yRot = this.bipedHead.yRot;
        this.bipedHeadOverlay.xRot = this.bipedHead.xRot;
        this.bipedRightArm.xRot = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 2.0f * limbYaw * 0.5f;
        this.bipedLeftArm.xRot = MathHelper.cos(limbSwing * 0.6662f) * 2.0f * limbYaw * 0.5f;
        this.bipedRightArm.zRot = 0.0f;
        this.bipedLeftArm.zRot = 0.0f;
        this.bipedRightLeg.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.bipedLeftLeg.xRot = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
        this.bipedRightLeg.yRot = 0.0f;
        this.bipedLeftLeg.yRot = 0.0f;
        if (this.isRiding) {
            this.bipedRightArm.xRot += -0.6283185f;
            this.bipedLeftArm.xRot += -0.6283185f;
            this.bipedRightLeg.xRot = -1.256637f;
            this.bipedLeftLeg.xRot = -1.256637f;
            this.bipedRightLeg.yRot = 0.3141593f;
            this.bipedLeftLeg.yRot = -0.3141593f;
        }
        if (this.field_1279_h) {
            this.bipedLeftArm.xRot = this.bipedLeftArm.xRot * 0.5f - 0.3141593f;
        }
        if (this.field_1278_i) {
            this.bipedRightArm.xRot = this.bipedRightArm.xRot * 0.5f - 0.3141593f;
        }
        this.bipedRightArm.yRot = 0.0f;
        this.bipedLeftArm.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.bipedBody.yRot = MathHelper.sin(MathHelper.sqrt_float(f6) * 3.141593f * 2.0f) * 0.2f;
            this.bipedRightArm.z = MathHelper.sin(this.bipedBody.yRot) * 5.0f;
            this.bipedRightArm.x = -MathHelper.cos(this.bipedBody.yRot) * 5.0f;
            this.bipedLeftArm.z = -MathHelper.sin(this.bipedBody.yRot) * 5.0f;
            this.bipedLeftArm.x = MathHelper.cos(this.bipedBody.yRot) * 5.0f;
            this.bipedRightArm.yRot += this.bipedBody.yRot;
            this.bipedLeftArm.yRot += this.bipedBody.yRot;
            this.bipedLeftArm.xRot += this.bipedBody.yRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin(f6 * 3.141593f);
            float f8 = MathHelper.sin(this.onGround * 3.141593f) * -(this.bipedHead.xRot - 0.7f) * 0.75f;
            this.bipedRightArm.xRot = (float)((double)this.bipedRightArm.xRot - ((double)f7 * 1.2 + (double)f8));
            this.bipedRightArm.yRot += this.bipedBody.yRot * 2.0f;
            this.bipedRightArm.zRot = MathHelper.sin(this.onGround * 3.141593f) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.xRot = 0.5f;
            this.bipedRightLeg.xRot -= 0.0f;
            this.bipedLeftLeg.xRot -= 0.0f;
            this.bipedRightArm.xRot += 0.4f;
            this.bipedLeftArm.xRot += 0.4f;
            this.bipedRightLeg.z = 4.0f;
            this.bipedLeftLeg.z = 4.0f;
            this.bipedRightLeg.y = 9.0f;
            this.bipedLeftLeg.y = 9.0f;
            this.bipedHead.y = 1.0f;
            this.bipedHeadOverlay.y = 1.0f;
        } else {
            this.bipedBody.xRot = 0.0f;
            this.bipedRightLeg.z = 0.0f;
            this.bipedLeftLeg.z = 0.0f;
            this.bipedRightLeg.y = 12.0f;
            this.bipedLeftLeg.y = 12.0f;
            this.bipedHead.y = 0.0f;
            this.bipedHeadOverlay.y = 0.0f;
        }
        this.bipedRightArm.zRot += MathHelper.cos(ticksExisted * 0.09f) * 0.05f + 0.05f;
        this.bipedLeftArm.zRot -= MathHelper.cos(ticksExisted * 0.09f) * 0.05f + 0.05f;
        this.bipedRightArm.xRot += MathHelper.sin(ticksExisted * 0.067f) * 0.05f;
        this.bipedLeftArm.xRot -= MathHelper.sin(ticksExisted * 0.067f) * 0.05f;
    }

    public void renderCloak(float f) {
        this.bipedCloak.render(f);
    }
}

