/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

public class ModelChicken
extends ModelBase {
    public Cube head;
    public Cube body;
    public Cube rightLeg;
    public Cube leftLeg;
    public Cube rightWing;
    public Cube leftWing;
    public Cube bill;
    public Cube chin;

    public ModelChicken() {
        int byte0 = 16;
        this.head = new Cube(0, 0);
        this.head.addBox(-2.0f, -6.0f, -2.0f, 4, 6, 3, 0.0f);
        this.head.setPos(0.0f, -1 + byte0, -4.0f);
        this.bill = new Cube(14, 0);
        this.bill.addBox(-2.0f, -4.0f, -4.0f, 4, 2, 2, 0.0f);
        this.bill.setPos(0.0f, -1 + byte0, -4.0f);
        this.chin = new Cube(14, 4);
        this.chin.addBox(-1.0f, -2.0f, -3.0f, 2, 2, 2, 0.0f);
        this.chin.setPos(0.0f, -1 + byte0, -4.0f);
        this.body = new Cube(0, 9);
        this.body.addBox(-3.0f, -4.0f, -3.0f, 6, 8, 6, 0.0f);
        this.body.setPos(0.0f, 0 + byte0, 0.0f);
        this.rightLeg = new Cube(26, 0);
        this.rightLeg.addBox(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.rightLeg.setPos(-2.0f, 3 + byte0, 1.0f);
        this.leftLeg = new Cube(26, 0);
        this.leftLeg.addBox(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.leftLeg.setPos(1.0f, 3 + byte0, 1.0f);
        this.rightWing = new Cube(24, 13);
        this.rightWing.addBox(0.0f, 0.0f, -3.0f, 1, 4, 6);
        this.rightWing.setPos(-4.0f, -3 + byte0, 0.0f);
        this.leftWing = new Cube(24, 13);
        this.leftWing.addBox(-1.0f, 0.0f, -3.0f, 1, 4, 6);
        this.leftWing.setPos(4.0f, -3 + byte0, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.setRotationAngles(limbSwing, limbYaw, ticksExisted, headYaw, headPitch, scale);
        this.head.render(scale);
        this.bill.render(scale);
        this.chin.render(scale);
        this.body.render(scale);
        this.rightLeg.render(scale);
        this.leftLeg.render(scale);
        this.rightWing.render(scale);
        this.leftWing.render(scale);
    }

    @Override
    public void setRotationAngles(float limbSwing, float limbYaw, float ticksExisted, float headYaw, float headPitch, float scale) {
        this.head.xRot = -(headPitch / 57.29578f);
        this.head.yRot = headYaw / 57.29578f;
        this.bill.xRot = this.head.xRot;
        this.bill.yRot = this.head.yRot;
        this.chin.xRot = this.head.xRot;
        this.chin.yRot = this.head.yRot;
        this.body.xRot = 1.570796f;
        this.rightLeg.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.leftLeg.xRot = MathHelper.cos(limbSwing * 0.6662f + 3.141593f) * 1.4f * limbYaw;
        this.rightWing.zRot = ticksExisted;
        this.leftWing.zRot = -ticksExisted;
    }
}

