/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import java.io.File;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.Framebuffer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.Texture;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderExternal;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.core.Global;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShadersRenderer
extends Renderer {
    protected final Framebuffer worldFramebuffer = new Framebuffer();
    protected final Texture worldFramebufferTex = new Texture();
    protected final Texture worldFramebufferDepth = new Texture();
    protected final Framebuffer gameFramebuffer = new Framebuffer();
    protected final Texture gameFramebufferTex = new Texture();
    protected final Texture gameFramebufferDepth = new Texture();
    protected final Shader postShader = new Shader();
    protected final Shader finalShader = new Shader();
    protected ShaderProvider internal = new ShaderProviderInternal("/shaders/");
    public int fbWidth;
    public int fbHeight;

    public ShadersRenderer(Minecraft minecraft) {
        super(minecraft);
        if (!Shaders.enableShaders) {
            throw new RuntimeException("Shaders disabled!");
        }
    }

    @Override
    public void beginRenderGame() {
        OpenGLHelper.checkError("pre begin render game");
        this.setupFramebuffer();
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
        GL20.glUseProgram((int)0);
        GL11.glViewport((int)0, (int)0, (int)this.fbWidth, (int)this.fbHeight);
        OpenGLHelper.checkError("begin render game");
    }

    @Override
    public void endRenderGame() {
        OpenGLHelper.checkError("pre end render game");
        GL11.glViewport((int)0, (int)0, (int)this.fbWidth, (int)this.fbHeight);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        if (this.finalShader.isEnabled()) {
            this.finalShader.bind();
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.gameFramebufferTex.bind();
            this.finalShader.uniformInt("colortex0", 0);
            Shaders.setUniforms(this.mc, this.finalShader);
            Shaders.drawFullscreenRect();
            GL20.glUseProgram((int)0);
        }
        OpenGLHelper.checkError("end render game");
    }

    @Override
    public void beginRenderWorld() {
        OpenGLHelper.checkError("pre begin render world");
        this.setupFramebuffer();
        this.worldFramebuffer.bind();
        GL11.glViewport((int)0, (int)0, (int)this.renderWidth, (int)this.renderHeight);
        GL20.glUseProgram((int)0);
        OpenGLHelper.checkError("begin render world");
    }

    @Override
    public void endRenderWorld() {
        OpenGLHelper.checkError("pre end render world");
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
        if (this.postShader.isEnabled()) {
            this.postShader.bind();
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.worldFramebufferTex.bind();
            this.postShader.uniformInt("colortex0", 0);
            ARBMultitexture.glActiveTextureARB((int)33985);
            this.worldFramebufferDepth.bind();
            this.postShader.uniformInt("depthtex0", 1);
            ARBMultitexture.glActiveTextureARB((int)33984);
            this.mc.ppm.enabled = true;
            Shaders.setUniforms(this.mc, this.postShader);
            this.mc.ppm.enabled = false;
        } else {
            GL20.glUseProgram((int)0);
            this.worldFramebufferTex.bind();
        }
        GL11.glViewport((int)0, (int)0, (int)this.fbWidth, (int)this.fbHeight);
        Shaders.drawFullscreenRect();
        GL20.glUseProgram((int)0);
        GL11.glEnable((int)3008);
        OpenGLHelper.checkError("end render world");
    }

    public void setupFramebuffer() {
        double renderScale = (float)((RenderScale)((Object)this.mc.gameSettings.renderScale.value)).scale;
        int scaledWidth = (int)(renderScale * (double)this.mc.resolution.width);
        int scaledHeight = (int)(renderScale * (double)this.mc.resolution.height);
        if (this.fbWidth != this.mc.resolution.width || this.fbHeight != this.mc.resolution.height || this.renderWidth != scaledWidth || this.renderHeight != scaledHeight || !this.gameFramebuffer.isGenerated() || !this.worldFramebuffer.isGenerated()) {
            this.worldFramebuffer.generate();
            this.worldFramebufferTex.generate();
            this.worldFramebufferDepth.generate();
            this.gameFramebuffer.generate();
            this.gameFramebufferTex.generate();
            this.gameFramebufferDepth.generate();
            this.fbWidth = this.mc.resolution.width;
            this.fbHeight = this.mc.resolution.height;
            this.renderWidth = scaledWidth;
            this.renderHeight = scaledHeight;
            boolean filtering = ((RenderScale)((Object)this.mc.gameSettings.renderScale.value)).useLinearFiltering;
            int filterMode = filtering ? 9729 : 9728;
            System.out.println("Display: " + this.fbWidth + " x " + this.fbHeight + ", Render: " + this.renderWidth + " x " + this.renderHeight);
            this.worldFramebuffer.bind();
            this.worldFramebufferTex.bind();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.renderWidth, (int)this.renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)filterMode);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filterMode);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.worldFramebufferTex.id(), (int)0);
            this.worldFramebufferDepth.bind();
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.renderWidth, (int)this.renderHeight, (int)0, (int)6402, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)filterMode);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filterMode);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.worldFramebufferDepth.id(), (int)0);
            this.gameFramebuffer.bind();
            this.gameFramebufferTex.bind();
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.gameFramebufferTex.id(), (int)0);
            this.gameFramebufferDepth.bind();
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)this.fbWidth, (int)this.fbHeight, (int)0, (int)6402, (int)5121, (ByteBuffer)null);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.gameFramebufferDepth.id(), (int)0);
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        }
    }

    @Override
    public void reload() {
        System.out.println("Reloading Shaders...");
        GL20.glUseProgram((int)0);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
        OpenGLHelper.checkError("pre shader reload");
        this.postShader.delete();
        this.finalShader.delete();
        ShaderProvider shaderProvider = this.getShader();
        if (shaderProvider != null) {
            this.finalShader.compile(shaderProvider, "base");
            this.postShader.compile(shaderProvider, "post");
        }
        OpenGLHelper.checkError("shader reload");
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        this.gameFramebufferDepth.delete();
        this.gameFramebufferTex.delete();
        this.worldFramebuffer.delete();
        this.worldFramebufferDepth.delete();
        this.worldFramebufferTex.delete();
    }

    @Override
    public void create() {
    }

    public ShaderProvider getShader() {
        String override = (String)this.mc.gameSettings.shaderOverride.value;
        if (override != null && override.length() > 0) {
            return new ShaderProviderExternal(new File(Global.accessor.getMinecraftDir(), "shaders/" + override));
        }
        return this.internal;
    }
}

