/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;

public abstract class TexturePackBase {
    public String texturePackFileName;
    public String firstDescriptionLine;
    public String secondDescriptionLine;
    public String packId;

    public void readZipFile() {
    }

    public void closeTexturePackFile() {
    }

    public void readTexturePackInfo(Minecraft minecraft) throws IOException {
    }

    public void disposeOfTexturePack(Minecraft minecraft) {
    }

    public void bindThumbnailTexture(Minecraft minecraft) {
    }

    public InputStream getResourceAsStream(String s) {
        return TexturePackBase.class.getResourceAsStream(s);
    }

    public String[] getFilesInDirectory(String directory) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        try {
            Path myPath;
            URI uri = TexturePackBase.class.getResource(directory).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                myPath = fileSystem.getPath(directory, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    paths.add(directory + ((Path)it.next()).getFileName().toString());
                }
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paths.toArray(new String[0]);
    }

    public abstract boolean hasFile(String var1);
}

