/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texturepack.TexturePackBase;
import org.lwjgl.opengl.GL11;

public class TexturePackCustom
extends TexturePackBase {
    private ZipFile texturePackZipFile;
    private int texturePackName = -1;
    private BufferedImage texturePackThumbnail;
    private final File texturePackFile;

    public TexturePackCustom(File file) {
        this.texturePackFileName = file.getName();
        this.texturePackFile = file;
    }

    private String truncatePackDescription(String s) {
        if (s != null && s.length() > 34) {
            s = s.substring(0, 34);
        }
        return s;
    }

    @Override
    public void readTexturePackInfo(Minecraft minecraft) throws IOException {
        if (this.texturePackFile.isFile()) {
            try (ZipFile zipfile = new ZipFile(this.texturePackFile);){
                InputStream inputstream2;
                try {
                    inputstream2 = zipfile.getInputStream(zipfile.getEntry("pack.txt"));
                    try {
                        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream2));
                        this.firstDescriptionLine = this.truncatePackDescription(bufferedreader.readLine());
                        this.secondDescriptionLine = this.truncatePackDescription(bufferedreader.readLine());
                        bufferedreader.close();
                    }
                    finally {
                        if (inputstream2 != null) {
                            inputstream2.close();
                        }
                    }
                }
                catch (Exception inputstream2) {
                    // empty catch block
                }
                try {
                    inputstream2 = zipfile.getInputStream(zipfile.getEntry("pack.png"));
                    try {
                        this.texturePackThumbnail = ImageIO.read(inputstream2);
                    }
                    finally {
                        if (inputstream2 != null) {
                            inputstream2.close();
                        }
                    }
                }
                catch (Exception inputstream3) {
                    // empty catch block
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        } else if (this.texturePackFile.isDirectory()) {
            FileInputStream inputstream4;
            try {
                inputstream4 = new FileInputStream(new File(this.texturePackFile, "pack.txt"));
                try {
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream4));
                    this.firstDescriptionLine = this.truncatePackDescription(bufferedreader.readLine());
                    this.secondDescriptionLine = this.truncatePackDescription(bufferedreader.readLine());
                    bufferedreader.close();
                }
                finally {
                    ((InputStream)inputstream4).close();
                }
            }
            catch (Exception inputstream4) {
                // empty catch block
            }
            try {
                inputstream4 = new FileInputStream(new File(this.texturePackFile, "pack.png"));
                try {
                    this.texturePackThumbnail = ImageIO.read(inputstream4);
                }
                finally {
                    ((InputStream)inputstream4).close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.deleteTexture(this.texturePackName);
        }
        this.closeTexturePackFile();
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackName < 0) {
            this.texturePackName = minecraft.renderEngine.allocateAndSetupTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.bindTexture(this.texturePackName);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/unknown_pack.png"));
        }
    }

    @Override
    public void readZipFile() {
        try {
            this.texturePackZipFile = new ZipFile(this.texturePackFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeTexturePackFile() {
        try {
            this.texturePackZipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.texturePackZipFile = null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        block8: {
            if (this.texturePackFile.isFile()) {
                String zipEntryPath = path;
                if (path.startsWith("/")) {
                    zipEntryPath = path.substring(1);
                }
                try {
                    ZipEntry zipentry = this.texturePackZipFile.getEntry(zipEntryPath);
                    if (zipentry != null) {
                        return this.texturePackZipFile.getInputStream(zipentry);
                    }
                    break block8;
                }
                catch (Exception ignored) {
                    return TexturePackBase.class.getResourceAsStream(path);
                }
            }
            try {
                File file = new File(this.texturePackFile, path);
                if (file.exists()) {
                    return new FileInputStream(file);
                }
            }
            catch (Exception ignored) {
                return TexturePackBase.class.getResourceAsStream(path);
            }
        }
        return TexturePackBase.class.getResourceAsStream(path);
    }

    @Override
    public String[] getFilesInDirectory(String directory) {
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (this.texturePackFile.isFile()) {
            ZipEntry dirEntry = this.texturePackZipFile.getEntry(directory);
            if (dirEntry != null) {
                if (dirEntry.isDirectory()) {
                    ArrayList<String> files = new ArrayList<String>();
                    Enumeration<? extends ZipEntry> e = this.texturePackZipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        if (!entry.getName().startsWith(directory)) continue;
                        files.add(entry.getName());
                    }
                    return files.toArray(new String[0]);
                }
                return new String[]{directory};
            }
            return super.getFilesInDirectory(directory);
        }
        File file = new File(this.texturePackFile, directory);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    String[] fileStrings = new String[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        fileStrings[i] = directory + files[i].getName();
                    }
                    return fileStrings;
                }
                return new String[0];
            }
            return new String[]{directory};
        }
        return super.getFilesInDirectory(directory);
    }

    @Override
    public boolean hasFile(String file) {
        if (this.texturePackFile.isFile()) {
            boolean h = false;
            try (ZipFile zipfile = new ZipFile(this.texturePackFile);){
                h = zipfile.getEntry(file.substring(1)) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return h;
        }
        return new File(this.texturePackFile, file).exists();
    }
}

