/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiItemDragHandler
extends Gui {
    public final Minecraft mc;
    public final GuiContainer container;
    public final GuiRenderItem guiRenderItem;
    private int renderOffsetX;
    private int renderOffsetY;
    private boolean pressedLeftWithModifiers = false;
    private boolean pressedRightWithModifiers = false;
    private int cancelButtonRelease = -1;
    private int draggingButton = -1;
    private ItemStack draggingItemStack;
    private final List<Slot> draggedSlots = new ArrayList<Slot>();
    private ItemStack renderItemStack;
    private int renderItemStackCount;
    private Slot lastClickSlot = null;
    private long lastClickTime = 0L;
    private boolean lastClickHoldingItem = false;
    private boolean doubleClick = false;

    public GuiItemDragHandler(Minecraft minecraft, GuiContainer container, GuiRenderItem renderItem) {
        this.mc = minecraft;
        this.container = container;
        this.guiRenderItem = renderItem;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.renderOffsetX = 0;
        this.renderOffsetY = 0;
        if (this.isDragging()) {
            Slot slot = this.getSlotAt(mouseX, mouseY);
            this.onDragOverSlot(slot);
            if (this.draggedSlots.size() > 1) {
                this.renderItemStack = this.draggingItemStack.copy();
                this.renderItemStack.stackSize = 1;
                if (this.draggingButton == 0) {
                    this.renderItemStackCount = this.draggingItemStack.stackSize / this.draggedSlots.size();
                }
                if (this.draggingButton == 1) {
                    this.renderItemStackCount = 1;
                }
                for (int i = 0; i < this.draggedSlots.size(); ++i) {
                    this.drawSlotOverlayWhileDragging(this.draggedSlots.get(i));
                }
                this.renderItemStack.stackSize = this.draggingItemStack.stackSize - this.draggedSlots.size() * this.renderItemStackCount;
            }
        }
    }

    private void onDragOverSlot(Slot slot) {
        if (slot == null) {
            return;
        }
        if (this.draggedSlots.size() >= this.draggingItemStack.stackSize) {
            return;
        }
        if (slot.canPutStackInSlot(this.draggingItemStack) && slot.enableDragAndPickup() && (slot.getStack() == null || slot.getStack().canStackWith(this.draggingItemStack)) && !this.draggedSlots.contains(slot)) {
            this.draggedSlots.add(slot);
        }
    }

    private void drawSlotOverlayWhileDragging(Slot slot) {
        if (slot == null) {
            throw new NullPointerException("Slot is null");
        }
        if (this.draggingItemStack == null) {
            throw new NullPointerException("Stack is null!");
        }
        ItemStack stack = slot.getStack();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawRectWidthHeight(this.renderOffsetX + slot.xDisplayPosition, this.renderOffsetY + slot.yDisplayPosition, 16, 16, -2130706433);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        this.renderItemStack.stackSize = this.renderItemStackCount;
        if (stack != null) {
            this.renderItemStack.stackSize = Math.min(this.renderItemStack.getMaxStackSize(), this.renderItemStack.stackSize + stack.stackSize);
        }
        this.guiRenderItem.render(this.renderItemStack, slot.xDisplayPosition, slot.yDisplayPosition);
    }

    public void mouseEvent(int x, int y, int button, boolean pressed) {
        boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        boolean control = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean alt = Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
        boolean space = Keyboard.isKeyDown((int)57);
        boolean mod = shift || control || alt || space;
        Slot slot = this.getSlotAt(x, y);
        if (button == 0 || button == 1) {
            if (pressed) {
                if (mod) {
                    if (button == 0) {
                        this.pressedLeftWithModifiers = true;
                    }
                    if (button == 1) {
                        this.pressedRightWithModifiers = true;
                    }
                    this.container.clickInventory(x, y, button);
                } else {
                    this.mousePressed(x, y, slot, button);
                }
            } else {
                if (button == 0 && this.pressedLeftWithModifiers) {
                    this.pressedLeftWithModifiers = false;
                    return;
                }
                if (button == 1 && this.pressedRightWithModifiers) {
                    this.pressedRightWithModifiers = false;
                    return;
                }
                this.mouseReleased(x, y, slot, button);
            }
        } else if (pressed) {
            this.container.clickInventory(x, y, button);
        }
    }

    public void click(InventoryAction action, int[] args) {
        this.mc.playerController.doInventoryAction(this.container.inventorySlots.windowId, action, args, this.mc.thePlayer);
    }

    private void mousePressed(int x, int y, Slot slot, int button) {
        ItemStack stack = this.getGrabbedItem();
        if (button == 0) {
            long now = System.currentTimeMillis();
            long sinceLast = now - this.lastClickTime;
            this.doubleClick = this.lastClickSlot != null && this.lastClickSlot == slot && sinceLast < 250L && stack != null && !this.lastClickHoldingItem;
            this.lastClickSlot = slot;
            this.lastClickTime = now;
            boolean bl = this.lastClickHoldingItem = stack != null;
        }
        if (stack == null) {
            this.container.clickInventory(x, y, button);
            this.cancelButtonRelease = button;
        } else if (!this.isDragging()) {
            this.draggingButton = button;
            this.draggingItemStack = stack;
            this.draggedSlots.clear();
        }
    }

    private void mouseReleased(int x, int y, Slot slot, int button) {
        ItemStack stack = this.getGrabbedItem();
        if (stack == null) {
            return;
        }
        if (this.cancelButtonRelease != -1) {
            int cancelButton = this.cancelButtonRelease;
            this.cancelButtonRelease = -1;
            if (cancelButton == button) {
                return;
            }
        }
        boolean doClick = true;
        if (button == 0 && this.doubleClick && slot != null && slot.enableDragAndPickup()) {
            doClick = false;
            this.pickupSimilarItems(slot);
            this.doubleClick = false;
            this.stopDragging();
        }
        if (this.isDragging()) {
            if (button == this.draggingButton) {
                if (this.draggedSlots.size() > 0) {
                    this.spreadItemsAcrossDraggedSlots(x, y, button);
                    doClick = false;
                }
            } else {
                this.cancelButtonRelease = this.draggingButton;
                doClick = false;
            }
            this.stopDragging();
        }
        if (doClick) {
            this.container.clickInventory(x, y, button);
        }
    }

    private void stopDragging() {
        this.draggingButton = -1;
        this.draggingItemStack = null;
        this.draggedSlots.clear();
    }

    private void spreadItemsAcrossDraggedSlots(int x, int y, int mode) {
        if (this.draggedSlots.size() < 1) {
            return;
        }
        if (this.draggedSlots.size() == 1) {
            this.container.clickInventory(x, y, mode);
            return;
        }
        InventoryAction action = mode != 0 ? InventoryAction.DRAG_ITEMS_ONE : InventoryAction.DRAG_ITEMS_ALL;
        int[] slots = new int[this.draggedSlots.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = this.draggedSlots.get((int)i).id;
        }
        this.mc.playerController.doInventoryAction(this.container.inventorySlots.windowId, action, slots, this.mc.thePlayer);
    }

    private void pickupSimilarItems(Slot slot) {
        if (!slot.enableDragAndPickup()) {
            return;
        }
        this.mc.playerController.doInventoryAction(this.container.inventorySlots.windowId, InventoryAction.PICKUP_SIMILAR, null, this.mc.thePlayer);
    }

    public boolean isDragging() {
        return this.draggingButton != -1;
    }

    private Slot getSlotAt(int x, int y) {
        return this.container.getSlotAtPosition(x, y);
    }

    private ItemStack getGrabbedItem() {
        return this.mc.thePlayer.inventory.getHeldItemStack();
    }

    public boolean isSlotDragged(Slot slot) {
        return this.draggedSlots.size() > 1 && this.draggedSlots.contains(slot);
    }

    public ItemStack getHeldItemRenderOverride() {
        if (this.isDragging() && this.draggedSlots.size() > 1) {
            return this.renderItemStack;
        }
        return null;
    }
}

