/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

public class Timer {
    public float ticksPerSecond;
    private double lastTime;
    public int frames;
    public float alpha;
    public float fps = 1.0f;
    public float ticks = 0.0f;
    private long currentTime;
    private long msPerTick;
    private long passedTime;
    private double averageFrameTime = 1.0;

    public Timer(float ticksPerSecond) {
        this.ticksPerSecond = ticksPerSecond;
        this.currentTime = System.currentTimeMillis();
        this.msPerTick = System.nanoTime() / 1000000L;
    }

    public void advanceTime() {
        long currentTime = System.currentTimeMillis();
        long timeDelta = currentTime - this.currentTime;
        long nanoTime = System.nanoTime() / 1000000L;
        double d = (double)nanoTime / 1000.0;
        if (timeDelta > 1000L) {
            this.lastTime = d;
        } else if (timeDelta < 0L) {
            this.lastTime = d;
        } else {
            this.passedTime += timeDelta;
            if (this.passedTime > 1000L) {
                long l3 = nanoTime - this.msPerTick;
                double d2 = (double)this.passedTime / (double)l3;
                this.averageFrameTime += (d2 - this.averageFrameTime) * 0.2;
                this.msPerTick = nanoTime;
                this.passedTime = 0L;
            }
            if (this.passedTime < 0L) {
                this.msPerTick = nanoTime;
            }
        }
        this.currentTime = currentTime;
        double d1 = (d - this.lastTime) * this.averageFrameTime;
        this.lastTime = d;
        if (d1 < 0.0) {
            d1 = 0.0;
        }
        if (d1 > 1.0) {
            d1 = 1.0;
        }
        this.ticks = (float)((double)this.ticks + d1 * (double)this.fps * (double)this.ticksPerSecond);
        this.frames = (int)this.ticks;
        this.ticks -= (float)this.frames;
        if (this.frames > 10) {
            this.frames = 10;
        }
        this.alpha = this.ticks;
    }
}

