/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.core.achievement.AchievementMap;
import net.minecraft.core.achievement.stat.IStatType;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatTypeDistance;
import net.minecraft.core.achievement.stat.StatTypeSimple;
import net.minecraft.core.achievement.stat.StatTypeTime;
import net.minecraft.core.lang.I18n;

public class StatBase {
    public final int statId;
    final String statName;
    public boolean clientside = false;
    public String statGuid;
    private final IStatType statType;
    private static NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
    public static IStatType statTypeSimple = new StatTypeSimple();
    private static DecimalFormat decimalFormat = new DecimalFormat("########0.00");
    public static IStatType statTypeTime = new StatTypeTime();
    public static IStatType statTypeDistance = new StatTypeDistance();

    public StatBase(int i, String s, IStatType istattype) {
        this.statId = i;
        this.statName = s;
        this.statType = istattype;
    }

    public StatBase(int i, String s) {
        this(i, s, statTypeSimple);
    }

    public String getStatName() {
        return I18n.getInstance().translateKey(this.statName);
    }

    public StatBase setClientside() {
        this.clientside = true;
        return this;
    }

    public StatBase registerStat() {
        if (StatList.statMap.containsKey(this.statId)) {
            throw new RuntimeException("Duplicate stat id: \"" + StatList.statMap.get(this.statId).getStatName() + "\" and \"" + this.statName + "\" at id " + this.statId);
        }
        StatList.statList1.add(this);
        StatList.statMap.put(this.statId, this);
        this.statGuid = AchievementMap.getGuid(this.statId);
        return this;
    }

    public boolean isAchievement() {
        return false;
    }

    public String makeString(int i) {
        return this.statType.makeString(i);
    }

    public String toString() {
        return this.statName;
    }

    static NumberFormat getNumberFormat() {
        return numberFormat;
    }

    static DecimalFormat getDecimalFormat() {
        return decimalFormat;
    }
}

