/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.b100.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.HitResult;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.BlockAlgae;
import net.minecraft.core.block.BlockAxisAligned;
import net.minecraft.core.block.BlockBasket;
import net.minecraft.core.block.BlockBed;
import net.minecraft.core.block.BlockBedrock;
import net.minecraft.core.block.BlockBlastFurnace;
import net.minecraft.core.block.BlockButton;
import net.minecraft.core.block.BlockCactus;
import net.minecraft.core.block.BlockCake;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.block.BlockChestLegacy;
import net.minecraft.core.block.BlockChestPainted;
import net.minecraft.core.block.BlockClay;
import net.minecraft.core.block.BlockCobweb;
import net.minecraft.core.block.BlockCrops;
import net.minecraft.core.block.BlockDeadBush;
import net.minecraft.core.block.BlockDetectorRail;
import net.minecraft.core.block.BlockDirtPath;
import net.minecraft.core.block.BlockDispenser;
import net.minecraft.core.block.BlockDoor;
import net.minecraft.core.block.BlockFarmland;
import net.minecraft.core.block.BlockFence;
import net.minecraft.core.block.BlockFenceChainlink;
import net.minecraft.core.block.BlockFenceGate;
import net.minecraft.core.block.BlockFenceGatePainted;
import net.minecraft.core.block.BlockFencePainted;
import net.minecraft.core.block.BlockFire;
import net.minecraft.core.block.BlockFlag;
import net.minecraft.core.block.BlockFlower;
import net.minecraft.core.block.BlockFluidFlowing;
import net.minecraft.core.block.BlockFluidStill;
import net.minecraft.core.block.BlockFurnace;
import net.minecraft.core.block.BlockGlass;
import net.minecraft.core.block.BlockGlassTinted;
import net.minecraft.core.block.BlockGlowStone;
import net.minecraft.core.block.BlockGrass;
import net.minecraft.core.block.BlockGrassScorched;
import net.minecraft.core.block.BlockGravel;
import net.minecraft.core.block.BlockIce;
import net.minecraft.core.block.BlockIgneousNetherrack;
import net.minecraft.core.block.BlockJukeBox;
import net.minecraft.core.block.BlockLadder;
import net.minecraft.core.block.BlockLamp;
import net.minecraft.core.block.BlockLanternFirefly;
import net.minecraft.core.block.BlockLayerBase;
import net.minecraft.core.block.BlockLayerLeaves;
import net.minecraft.core.block.BlockLayerSlate;
import net.minecraft.core.block.BlockLayerSnow;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.block.BlockLeavesBirch;
import net.minecraft.core.block.BlockLeavesCherry;
import net.minecraft.core.block.BlockLeavesCherryFlowering;
import net.minecraft.core.block.BlockLeavesEucalyptus;
import net.minecraft.core.block.BlockLeavesOak;
import net.minecraft.core.block.BlockLeavesPine;
import net.minecraft.core.block.BlockLeavesRetro;
import net.minecraft.core.block.BlockLeavesShrub;
import net.minecraft.core.block.BlockLever;
import net.minecraft.core.block.BlockLog;
import net.minecraft.core.block.BlockMesh;
import net.minecraft.core.block.BlockMobSpawner;
import net.minecraft.core.block.BlockMoss;
import net.minecraft.core.block.BlockMotionSensor;
import net.minecraft.core.block.BlockMud;
import net.minecraft.core.block.BlockMushroom;
import net.minecraft.core.block.BlockNote;
import net.minecraft.core.block.BlockOreCoal;
import net.minecraft.core.block.BlockOreDiamond;
import net.minecraft.core.block.BlockOreGold;
import net.minecraft.core.block.BlockOreIron;
import net.minecraft.core.block.BlockOreLapis;
import net.minecraft.core.block.BlockOreNetherCoal;
import net.minecraft.core.block.BlockOreRedstone;
import net.minecraft.core.block.BlockOverlayPebbles;
import net.minecraft.core.block.BlockPistonBase;
import net.minecraft.core.block.BlockPistonHead;
import net.minecraft.core.block.BlockPistonMoving;
import net.minecraft.core.block.BlockPlanksPainted;
import net.minecraft.core.block.BlockPortal;
import net.minecraft.core.block.BlockPressurePlate;
import net.minecraft.core.block.BlockPumpkin;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.block.BlockRedstone;
import net.minecraft.core.block.BlockRedstoneRepeater;
import net.minecraft.core.block.BlockRedstoneTorch;
import net.minecraft.core.block.BlockRedstoneWire;
import net.minecraft.core.block.BlockSand;
import net.minecraft.core.block.BlockSaplingBirch;
import net.minecraft.core.block.BlockSaplingCherry;
import net.minecraft.core.block.BlockSaplingEucalyptus;
import net.minecraft.core.block.BlockSaplingOak;
import net.minecraft.core.block.BlockSaplingPine;
import net.minecraft.core.block.BlockSaplingRetro;
import net.minecraft.core.block.BlockSaplingShrub;
import net.minecraft.core.block.BlockSign;
import net.minecraft.core.block.BlockSlab;
import net.minecraft.core.block.BlockSlabMarble;
import net.minecraft.core.block.BlockSlabPainted;
import net.minecraft.core.block.BlockSlippery;
import net.minecraft.core.block.BlockSnow;
import net.minecraft.core.block.BlockSoulSand;
import net.minecraft.core.block.BlockSpikes;
import net.minecraft.core.block.BlockSpinifex;
import net.minecraft.core.block.BlockSponge;
import net.minecraft.core.block.BlockStairs;
import net.minecraft.core.block.BlockStairsPainted;
import net.minecraft.core.block.BlockStone;
import net.minecraft.core.block.BlockSugarcane;
import net.minecraft.core.block.BlockTNT;
import net.minecraft.core.block.BlockTallGrass;
import net.minecraft.core.block.BlockTorch;
import net.minecraft.core.block.BlockTrapDoor;
import net.minecraft.core.block.BlockTrommel;
import net.minecraft.core.block.BlockWool;
import net.minecraft.core.block.BlockWorkbench;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumFireflyColour;
import net.minecraft.core.enums.EnumMobType;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.ItemToolShears;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.item.block.ItemBlockAlgae;
import net.minecraft.core.item.block.ItemBlockChestLegacy;
import net.minecraft.core.item.block.ItemBlockLadder;
import net.minecraft.core.item.block.ItemBlockLamp;
import net.minecraft.core.item.block.ItemBlockLayer;
import net.minecraft.core.item.block.ItemBlockLayerLeaves;
import net.minecraft.core.item.block.ItemBlockLeaves;
import net.minecraft.core.item.block.ItemBlockPainted;
import net.minecraft.core.item.block.ItemBlockPiston;
import net.minecraft.core.item.block.ItemBlockSlab;
import net.minecraft.core.item.block.ItemBlockSlabPainted;
import net.minecraft.core.item.block.ItemBlockStairsPainted;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.BoundingVolume;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class Block
implements ITaggable<Block>,
IItemConvertible {
    public static final Block[] blocksList;
    public static final boolean[] tickOnLoad;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] lightOpacity;
    public static final boolean[] canBlockGrass;
    public static final int[] lightValue;
    public static final boolean[] neighborNotifyOnMetadataChangeDisabled;
    public static final Map<String, Integer> keyToIdMap;
    public static int highestBlockId;
    public static final Block stone;
    public static final Block basalt;
    public static final Block limestone;
    public static final Block granite;
    public static final Block marble;
    public static final Block slate;
    public static final Block permafrost;
    public static final Block cobbleStone;
    public static final Block cobbleStoneMossy;
    public static final Block cobbleBasalt;
    public static final Block cobbleLimestone;
    public static final Block cobbleGranite;
    public static final Block cobblePermafrost;
    public static final Block stonePolished;
    public static final Block granitePolished;
    public static final Block limestonePolished;
    public static final Block basaltPolished;
    public static final Block slatePolished;
    public static final Block pillarMarble;
    public static final Block capstoneMarble;
    public static final Block sandstone;
    public static final Block stoneCarved;
    public static final Block graniteCarved;
    public static final Block limestoneCarved;
    public static final Block basaltCarved;
    public static final Block planksOak;
    public static final Block planksOakPainted;
    public static final Block torchCoal;
    public static final Block ladderOak;
    public static final Block fencePlanksOak;
    public static final Block fencePlanksOakPainted;
    public static final Block fencegatePlanksOak;
    public static final Block fencegatePlanksOakPainted;
    public static final Block bookshelfPlanksOak;
    public static final Block wool;
    public static final Block brickClay;
    public static final Block brickStonePolished;
    public static final Block brickStonePolishedMossy;
    public static final Block brickSandstone;
    public static final Block brickGold;
    public static final Block brickLapis;
    public static final Block brickBasalt;
    public static final Block brickLimestone;
    public static final Block brickGranite;
    public static final Block brickMarble;
    public static final Block brickSlate;
    public static final Block brickStone;
    public static final Block brickPermafrost;
    public static final Block brickIron;
    public static final Block slabPlanksOak;
    public static final Block slabCobbleStone;
    public static final Block slabSandstone;
    public static final Block slabBrickStonePolished;
    public static final Block slabStonePolished;
    public static final Block slabBrickMarble;
    public static final Block slabBrickClay;
    public static final Block slabCapstoneMarble;
    public static final Block slabCobbleBasalt;
    public static final Block slabCobbleLimestone;
    public static final Block slabCobbleGranite;
    public static final Block slabBrickBasalt;
    public static final Block slabBrickLimestone;
    public static final Block slabBrickGranite;
    public static final Block slabPlanksOakPainted;
    public static final Block slabBrickSlate;
    public static final Block slabBrickStone;
    public static final Block slabGranitePolished;
    public static final Block slabLimestonePolished;
    public static final Block slabBasaltPolished;
    public static final Block stairsPlanksOak;
    public static final Block stairsCobbleStone;
    public static final Block stairsBrickStonePolished;
    public static final Block stairsBrickMarble;
    public static final Block stairsCobbleBasalt;
    public static final Block stairsCobbleLimestone;
    public static final Block stairsCobbleGranite;
    public static final Block stairsBrickBasalt;
    public static final Block stairsBrickLimestone;
    public static final Block stairsBrickGranite;
    public static final Block stairsBrickClay;
    public static final Block stairsPlanksOakPainted;
    public static final Block stairsBrickSlate;
    public static final Block stairsBrickStone;
    public static final Block obsidian;
    public static final Block glass;
    public static final Block glassTinted;
    public static final Block grass;
    public static final Block grassRetro;
    public static final Block grassScorched;
    public static final Block pathDirt;
    public static final Block dirt;
    public static final Block dirtScorched;
    public static final Block dirtScorchedRich;
    public static final Block mud;
    public static final Block mudBaked;
    public static final Block spongeDry;
    public static final Block spongeWet;
    public static final Block mossStone;
    public static final Block mossBasalt;
    public static final Block mossLimestone;
    public static final Block mossGranite;
    public static final Block sand;
    public static final Block gravel;
    public static final Block bedrock;
    public static final Block fluidWaterFlowing;
    public static final Block fluidWaterStill;
    public static final Block fluidLavaFlowing;
    public static final Block fluidLavaStill;
    public static final Block logOak;
    public static final Block logPine;
    public static final Block logBirch;
    public static final Block logCherry;
    public static final Block logEucalyptus;
    public static final Block logOakMossy;
    public static final Block leavesOak;
    public static final Block leavesOakRetro;
    public static final Block leavesPine;
    public static final Block leavesBirch;
    public static final Block leavesCherry;
    public static final Block leavesEucalyptus;
    public static final Block leavesShrub;
    public static final Block leavesCherryFlowering;
    public static final Block saplingOak;
    public static final Block saplingOakRetro;
    public static final Block saplingPine;
    public static final Block saplingBirch;
    public static final Block saplingCherry;
    public static final Block saplingEucalyptus;
    public static final Block saplingShrub;
    public static final Block tallgrass;
    public static final Block tallgrassFern;
    public static final Block deadbush;
    public static final Block spinifex;
    public static final Block algae;
    public static final Block flowerYellow;
    public static final Block flowerRed;
    public static final Block mushroomBrown;
    public static final Block mushroomRed;
    public static final Block oreCoalStone;
    public static final Block oreCoalBasalt;
    public static final Block oreCoalLimestone;
    public static final Block oreCoalGranite;
    public static final Block oreIronStone;
    public static final Block oreIronBasalt;
    public static final Block oreIronLimestone;
    public static final Block oreIronGranite;
    public static final Block oreGoldStone;
    public static final Block oreGoldBasalt;
    public static final Block oreGoldLimestone;
    public static final Block oreGoldGranite;
    public static final Block oreLapisStone;
    public static final Block oreLapisBasalt;
    public static final Block oreLapisLimestone;
    public static final Block oreLapisGranite;
    public static final Block oreRedstoneStone;
    public static final Block oreRedstoneBasalt;
    public static final Block oreRedstoneLimestone;
    public static final Block oreRedstoneGranite;
    public static final Block oreRedstoneGlowingStone;
    public static final Block oreRedstoneGlowingBasalt;
    public static final Block oreRedstoneGlowingLimestone;
    public static final Block oreRedstoneGlowingGranite;
    public static final Block oreDiamondStone;
    public static final Block oreDiamondBasalt;
    public static final Block oreDiamondLimestone;
    public static final Block oreDiamondGranite;
    public static final Block oreNethercoalNetherrack;
    public static final Block blockCoal;
    public static final Block blockIron;
    public static final Block blockGold;
    public static final Block blockLapis;
    public static final Block blockRedstone;
    public static final Block blockDiamond;
    public static final Block blockNetherCoal;
    public static final Block blockSteel;
    public static final Block blockQuartz;
    public static final Block blockOlivine;
    public static final Block blockCharcoal;
    public static final Block wireRedstone;
    public static final Block torchRedstoneIdle;
    public static final Block torchRedstoneActive;
    public static final Block buttonStone;
    public static final Block leverCobbleStone;
    public static final Block pressureplateStone;
    public static final Block pressureplatePlanksOak;
    public static final Block pressureplateCobbleStone;
    public static final Block motionsensorIdle;
    public static final Block motionsensorActive;
    public static final Block repeaterIdle;
    public static final Block repeaterActive;
    public static final Block pistonBase;
    public static final Block pistonBaseSticky;
    public static final Block pistonHead;
    public static final Block pistonMoving;
    public static final Block noteblock;
    public static final Block rail;
    public static final Block railPowered;
    public static final Block railDetector;
    public static final Block spikes;
    public static final Block dispenserCobbleStone;
    public static final Block trapdoorPlanksOak;
    public static final Block trapdoorIron;
    public static final Block trapdoorGlass;
    public static final Block tnt;
    public static final Block doorPlanksOakBottom;
    public static final Block doorPlanksOakTop;
    public static final Block doorIronBottom;
    public static final Block doorIronTop;
    public static final Block mesh;
    public static final Block bed;
    public static final Block cobweb;
    public static final Block fire;
    public static final Block mobspawner;
    public static final Block mobspawnerDeactivated;
    public static final Block workbench;
    public static final Block furnaceStoneIdle;
    public static final Block furnaceStoneActive;
    public static final Block furnaceBlastIdle;
    public static final Block furnaceBlastActive;
    public static final Block trommelIdle;
    public static final Block trommelActive;
    public static final Block chestLegacy;
    public static final Block chestLegacyPainted;
    public static final Block chestPlanksOak;
    public static final Block chestPlanksOakPainted;
    public static final Block basket;
    public static final Block cropsWheat;
    public static final Block farmlandDirt;
    public static final Block signPostPlanksOak;
    public static final Block signWallPlanksOak;
    public static final Block flag;
    public static final Block layerSnow;
    public static final Block layerLeavesOak;
    public static final Block layerSlate;
    public static final Block ice;
    public static final Block permaice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block sugarcane;
    public static final Block jukebox;
    public static final Block pumpkin;
    public static final Block pumpkinCarvedIdle;
    public static final Block pumpkinCarvedActive;
    public static final Block netherrack;
    public static final Block netherrackIgneous;
    public static final Block soulsand;
    public static final Block glowstone;
    public static final Block portalNether;
    public static final Block portalParadise;
    public static final Block cake;
    public static final Block lampIdle;
    public static final Block lampActive;
    public static final Block lanternFireflyGreen;
    public static final Block lanternFireflyBlue;
    public static final Block lanternFireflyOrange;
    public static final Block lanternFireflyRed;
    public static final Block overlayPebbles;
    public static final Block fenceChainlink;
    public int[] atlasIndices = new int[6];
    public final int id;
    protected float blockHardness;
    protected float blastResistance;
    protected boolean blockConstructorCalled = true;
    protected boolean enableStats = true;
    protected boolean isLitInteriorSurface;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public float blockParticleGravity = 1.0f;
    public final Material blockMaterial;
    public float movementScale = 0.6f;
    protected String key;
    public boolean hasOverbright = false;
    public Block dropOverride = null;
    public boolean immovable = false;

    public Block(String key, int id, Material material) {
        this.id = id;
        if (blocksList[id] != null) {
            throw new IllegalArgumentException("Slot " + id + " is already occupied by " + blocksList[id] + " when adding " + this);
        }
        this.blockMaterial = material;
        Block.blocksList[id] = this;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[id] = this.isOpaqueCube();
        Block.lightOpacity[id] = this.isOpaqueCube() || this.blocksLight() ? 255 : 0;
        Block.canBlockGrass[id] = !material.blocksLight();
        Block.isBlockContainer[id] = false;
        this.setKey(key);
        if (highestBlockId < id) {
            highestBlockId = id;
        }
    }

    protected Block withDisabledNeighborNotifyOnMetadataChange() {
        Block.neighborNotifyOnMetadataChangeDisabled[this.id] = true;
        return this;
    }

    protected void initializeBlock() {
    }

    protected Block withLightOpacity(int opacity) {
        Block.lightOpacity[this.id] = opacity;
        return this;
    }

    protected Block withLightValue(float lightValue) {
        Block.lightValue[this.id] = (int)(15.0f * lightValue);
        return this;
    }

    protected Block withLightValue(int lightValue) {
        Block.lightValue[this.id] = lightValue;
        return this;
    }

    protected Block withImmovableFlagSet() {
        this.immovable = true;
        return this;
    }

    protected Block withBlastResistance(float blastResistance) {
        this.blastResistance = blastResistance * 3.0f;
        return this;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean canPlaceOnSurface() {
        return this.renderAsNormalBlock();
    }

    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        return this.renderAsNormalBlock();
    }

    public boolean canPlaceOnSurfaceOfBlock(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    protected Block withHardness(float blockHardness) {
        this.blockHardness = blockHardness;
        if (this.blastResistance < blockHardness * 5.0f) {
            this.blastResistance = blockHardness * 5.0f;
        }
        return this;
    }

    protected Block setDropOverride(Block block) {
        this.dropOverride = block;
        return this;
    }

    protected Block withLitInteriorSurface(boolean isLit) {
        this.isLitInteriorSurface = isLit;
        return this;
    }

    protected Block withSetUnbreakable() {
        this.withHardness(-1.0f);
        return this;
    }

    public float getHardness() {
        return this.blockHardness;
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this)};
        }
        return null;
    }

    public Block withTexCoords(int x, int y) {
        return this.withTexCoords(x, y, x, y, x, y, x, y, x, y, x, y);
    }

    public Block withTexCoords(int topBottomX, int topBottomY, int sidesX, int sidesY) {
        return this.withTexCoords(topBottomX, topBottomY, topBottomX, topBottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public Block withTexCoords(int topX, int topY, int bottomX, int bottomY, int sidesX, int sidesY) {
        return this.withTexCoords(topX, topY, bottomX, bottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public Block withTexCoords(int topX, int topY, int bottomX, int bottomY, int northX, int northY, int eastX, int eastY, int southX, int southY, int westX, int westY) {
        this.atlasIndices[Side.TOP.getId()] = Block.texCoordToIndex(topX, topY);
        this.atlasIndices[Side.BOTTOM.getId()] = Block.texCoordToIndex(bottomX, bottomY);
        this.atlasIndices[Side.NORTH.getId()] = Block.texCoordToIndex(northX, northY);
        this.atlasIndices[Side.EAST.getId()] = Block.texCoordToIndex(eastX, eastY);
        this.atlasIndices[Side.SOUTH.getId()] = Block.texCoordToIndex(southX, southY);
        this.atlasIndices[Side.WEST.getId()] = Block.texCoordToIndex(westX, westY);
        return this;
    }

    public static int texCoordToIndex(int x, int y) {
        return x + y * Global.TEXTURE_ATLAS_WIDTH_TILES;
    }

    protected Block setTickOnLoad(boolean tickOnLoad) {
        Block.tickOnLoad[this.id] = tickOnLoad;
        return this;
    }

    public void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return blockAccess.getBrightness(x, y, z, lightValue[this.id]);
    }

    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Side side1 = Side.getSideById(side);
        if (side1 == Side.BOTTOM && this.minY > 0.0) {
            return true;
        }
        if (side1 == Side.TOP && this.maxY < 1.0) {
            return true;
        }
        if (side1 == Side.NORTH && this.minZ > 0.0) {
            return true;
        }
        if (side1 == Side.SOUTH && this.maxZ < 1.0) {
            return true;
        }
        if (side1 == Side.WEST && this.minX > 0.0) {
            return true;
        }
        if (side1 == Side.EAST && this.maxX < 1.0) {
            return true;
        }
        return !blockAccess.isBlockOpaqueCube(x, y, z);
    }

    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return this.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    public boolean getIsBlockSolid(WorldSource blockAccess, int x, int y, int z, Side side) {
        return blockAccess.getBlockMaterial(x, y, z).isSolid();
    }

    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, blockAccess.getBlockMetadata(x, y, z));
    }

    public int getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        return -1;
    }

    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return this.atlasIndices[side.getId()];
    }

    public AABB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return AABB.getBoundingBoxFromPool((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (double)y + this.maxY, (double)z + this.maxZ);
    }

    public BoundingVolume getBoundingVolume(World world, int x, int y, int z) {
        return null;
    }

    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AABB aabb, ArrayList<AABB> aabbList) {
        AABB aabbFromPool = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        if (aabbFromPool != null && aabb.intersectsWith(aabbFromPool)) {
            aabbList.add(aabbFromPool);
        }
    }

    public boolean collidesWithEntity(Entity entity) {
        return true;
    }

    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AABB.getBoundingBoxFromPool((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (double)y + this.maxY, (double)z + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public void onBlockAdded(EntityPlayer entityPlayer, World world, int x, int y, int z) {
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
    }

    public boolean renderFullbright() {
        return false;
    }

    public float blockStrength(EntityPlayer player) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!player.canHarvestBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this) / this.blockHardness / 30.0f;
    }

    public boolean getImmovable() {
        return this.immovable;
    }

    public float getBlastResistance(Entity entity) {
        return this.blastResistance / 5.0f;
    }

    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3d start, Vec3d end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        start = start.addVector(-x, -y, -z);
        end = end.addVector(-x, -y, -z);
        Vec3d vec3d2 = start.getIntermediateWithXValue(end, this.minX);
        Vec3d vec3d3 = start.getIntermediateWithXValue(end, this.maxX);
        Vec3d vec3d4 = start.getIntermediateWithYValue(end, this.minY);
        Vec3d vec3d5 = start.getIntermediateWithYValue(end, this.maxY);
        Vec3d vec3d6 = start.getIntermediateWithZValue(end, this.minZ);
        Vec3d vec3d7 = start.getIntermediateWithZValue(end, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3d vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || start.squareDistanceTo(vec3d2) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || start.squareDistanceTo(vec3d3) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || start.squareDistanceTo(vec3d4) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || start.squareDistanceTo(vec3d5) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || start.squareDistanceTo(vec3d6) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || start.squareDistanceTo(vec3d7) < start.squareDistanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        Side side = Side.NONE;
        if (vec3d8 == vec3d2) {
            side = Side.WEST;
        }
        if (vec3d8 == vec3d3) {
            side = Side.EAST;
        }
        if (vec3d8 == vec3d4) {
            side = Side.BOTTOM;
        }
        if (vec3d8 == vec3d5) {
            side = Side.TOP;
        }
        if (vec3d8 == vec3d6) {
            side = Side.NORTH;
        }
        if (vec3d8 == vec3d7) {
            side = Side.SOUTH;
        }
        return new HitResult(x, y, z, side, vec3d8.addVector(x, y, z));
    }

    private boolean isVecInsideYZBounds(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3d vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        return this.canPlaceBlockAt(world, x, y, z);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceInsideBlock(x, y, z);
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
    }

    public void velocityToAddToEntity(World world, int x, int y, int z, Entity entity, Vec3d entityVelocity) {
    }

    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
    }

    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        return false;
    }

    public void setBlockBoundsForItemRender() {
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int x, int y, int z, int meta, TileEntity tileEntity) {
        Item heldItem;
        entityplayer.addStat(StatList.mineBlockStatArray[this.id], 1);
        ItemStack heldItemStack = entityplayer.inventory.getCurrentItem();
        Item item = heldItem = heldItemStack != null ? Item.itemsList[heldItemStack.itemID] : null;
        if (heldItem != null) {
            if (heldItem.isSilkTouch() && entityplayer.canHarvestBlock(this)) {
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, tileEntity);
                return;
            }
            if (heldItem instanceof ItemToolShears && this.hasTag(BlockTags.SHEARS_DO_SILK_TOUCH)) {
                ItemToolShears heldShears = (ItemToolShears)heldItem;
                this.dropBlockWithCause(world, EnumDropCause.SILK_TOUCH, x, y, z, meta, tileEntity);
                heldShears.onBlockSheared(entityplayer, heldItemStack);
                return;
            }
        }
        if (entityplayer.canHarvestBlock(this)) {
            this.dropBlockWithCause(world, EnumDropCause.PROPER_TOOL, x, y, z, meta, tileEntity);
        } else {
            this.dropBlockWithCause(world, EnumDropCause.IMPROPER_TOOL, x, y, z, meta, tileEntity);
        }
    }

    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (world.isClientSide) {
            return;
        }
        ItemStack[] drops = this.getBreakResult(world, cause, x, y, z, meta, tileEntity);
        if (drops != null && drops.length > 0) {
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                for (int i = 0; i < drop.stackSize; ++i) {
                    world.dropItem(x, y, z, new ItemStack(drop.itemID, 1, drop.getMetadata(), drop.tag));
                }
            }
        }
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return true;
    }

    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
    }

    public void setKey(String key) {
        this.key = "tile." + key;
        keyToIdMap.put(this.key, this.id);
    }

    public String getKey() {
        return this.key;
    }

    public String getLanguageKey(int meta) {
        return this.getKey();
    }

    public void playBlock(World world, int x, int y, int z, int instrument, int pitch) {
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block withDisabledStats() {
        this.enableStats = false;
        return this;
    }

    public int getMobilityFlag() {
        return this.blockMaterial.getPushReaction();
    }

    public static boolean isBuried(World world, int x, int y, int z) {
        boolean buried = true;
        if (lightOpacity[world.getBlockId(x + 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x - 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y, z + 1)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y, z - 1)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y + 1, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y - 1, z)] <= 2) {
            buried = false;
        }
        return buried;
    }

    public static boolean getIsLitInteriorSurface(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y, z);
        return l != 0 && Block.blocksList[l].isLitInteriorSurface;
    }

    public Block withOverbright() {
        this.hasOverbright = true;
        return this;
    }

    public static boolean getHasOverbright(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        return id != 0 && Block.blocksList[id].hasOverbright;
    }

    @SafeVarargs
    public final Block withTags(Tag<Block> ... tags) {
        for (Tag<Block> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    public boolean hasTag(Tag<Block> tag) {
        return tag.appliesTo(this);
    }

    public static boolean hasTag(int id, Tag<Block> tag) {
        if (id < 0) {
            return false;
        }
        Block block = blocksList[id];
        if (block == null) {
            return false;
        }
        return block.hasTag(tag);
    }

    public boolean isClimbable(World world, int x, int y, int z) {
        return false;
    }

    public static Block getBlock(int id) {
        return blocksList[id];
    }

    public static Block getBlockByName(String name) {
        Utils.requireNonNull(name);
        if (name.startsWith("tile.")) {
            name = name.substring(5);
        }
        for (Block block : blocksList) {
            String otherName;
            if (block == null || !name.equalsIgnoreCase(otherName = block.key.substring(5))) continue;
            return block;
        }
        return null;
    }

    @Override
    public boolean isIn(Tag<Block> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public Item asItem() {
        return Item.itemsList[this.id];
    }

    @Override
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }

    static {
        int i;
        blocksList = new Block[16384];
        tickOnLoad = new boolean[blocksList.length];
        opaqueCubeLookup = new boolean[blocksList.length];
        isBlockContainer = new boolean[blocksList.length];
        lightOpacity = new int[blocksList.length];
        canBlockGrass = new boolean[blocksList.length];
        lightValue = new int[blocksList.length];
        neighborNotifyOnMetadataChangeDisabled = new boolean[blocksList.length];
        keyToIdMap = new HashMap<String, Integer>();
        highestBlockId = 0;
        stone = new BlockStone("stone", 1).withTexCoords(1, 0).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        basalt = new BlockStone("basalt", 2).withTexCoords(6, 10).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        limestone = new BlockStone("limestone", 3).withTexCoords(9, 10).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        granite = new BlockStone("granite", 4).withTexCoords(9, 11).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        marble = new Block("marble", 5, Material.stone).withTexCoords(9, 12).withHardness(1.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slate = new Block("slate", 6, Material.stone).withTexCoords(8, 13, 7, 13).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        permafrost = new BlockStone("permafrost", 7).withTexCoords(11, 15).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        cobbleStone = new Block("cobble.stone", 10, Material.stone).withTexCoords(0, 1).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        cobbleStoneMossy = new Block("cobble.stone.mossy", 11, Material.stone).withTexCoords(4, 2).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        cobbleBasalt = new Block("cobble.basalt", 12, Material.stone).withTexCoords(7, 10).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        cobbleLimestone = new Block("cobble.limestone", 13, Material.stone).withTexCoords(10, 10).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        cobbleGranite = new Block("cobble.granite", 14, Material.stone).withTexCoords(10, 11).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        cobblePermafrost = new Block("cobble.permafrost", 15, Material.stone).withTexCoords(12, 15).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stonePolished = new Block("stone.polished", 860, Material.stone).withTexCoords(6, 0, 5, 1).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        granitePolished = new Block("granite.polished", 861, Material.stone).withTexCoords(4, 13, 2, 13).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        limestonePolished = new Block("limestone.polished", 862, Material.stone).withTexCoords(3, 13, 2, 12).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        basaltPolished = new Block("basalt.polished", 863, Material.stone).withTexCoords(5, 13, 2, 14).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slatePolished = new Block("slate.polished", 864, Material.stone).withTexCoords(8, 14, 7, 14).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        pillarMarble = new BlockAxisAligned("pillar.marble", 20, Material.stone).withTexCoords(11, 13, 11, 12).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        capstoneMarble = new Block("capstone.marble", 21, Material.stone).withTexCoords(9, 14, 9, 14, 9, 13).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        sandstone = new Block("sandstone", 30, Material.stone).withTexCoords(0, 11, 0, 13, 0, 12).withHardness(0.8f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_PICKAXE);
        stoneCarved = new Block("stone.carved", 40, Material.stone).withTexCoords(6, 0, 5, 0).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        graniteCarved = new Block("granite.carved", 41, Material.stone).withTexCoords(4, 13, 4, 14).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        limestoneCarved = new Block("limestone.carved", 42, Material.stone).withTexCoords(3, 13, 3, 14).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        basaltCarved = new Block("basalt.carved", 43, Material.stone).withTexCoords(5, 13, 5, 14).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        planksOak = new Block("planks.oak", 50, Material.wood).withTexCoords(4, 0).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        planksOakPainted = new BlockPlanksPainted("planks.oak.painted", 51).withTexCoords(2, 3).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        torchCoal = new BlockTorch("torch.coal", 60).withTexCoords(0, 5).withHardness(0.0f).withLightValue(0.9375f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        ladderOak = new BlockLadder("ladder.oak", 70).withTexCoords(3, 5).withHardness(0.4f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        fencePlanksOak = new BlockFence("fence.planks.oak", 80).withTexCoords(4, 0).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE, BlockTags.CAN_HANG_OFF);
        fencePlanksOakPainted = new BlockFencePainted("fence.planks.oak.painted", 81).withTexCoords(2, 3).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE, BlockTags.CAN_HANG_OFF);
        fencegatePlanksOak = new BlockFenceGate("fencegate.planks.oak", 90).withTexCoords(4, 0).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        fencegatePlanksOakPainted = new BlockFenceGatePainted("fencegate.planks.oak.painted", 91).withTexCoords(2, 3).withHardness(2.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        bookshelfPlanksOak = new Block("bookshelf.planks.oak", 100, Material.wood).withTexCoords(4, 0, 3, 2).withHardness(1.5f).withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        wool = new BlockWool("wool", 110).withTexCoords(0, 4).withHardness(0.8f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_SHEARS);
        brickClay = new Block("brick.clay", 120, Material.stone).withTexCoords(7, 0).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickStonePolished = new Block("brick.stone.polished", 121, Material.stone).withTexCoords(10, 8).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickStonePolishedMossy = new Block("brick.stone.polished.mossy", 122, Material.stone).withTexCoords(11, 8).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickSandstone = new Block("brick.sandstone", 123, Material.stone).withTexCoords(0, 14).withHardness(0.8f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickGold = new Block("brick.gold", 124, Material.metal).withTexCoords(9, 9).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickLapis = new Block("brick.lapis", 125, Material.stone).withTexCoords(9, 8).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickBasalt = new Block("brick.basalt", 126, Material.stone).withTexCoords(8, 10).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickLimestone = new Block("brick.limestone", 127, Material.stone).withTexCoords(11, 10).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickGranite = new Block("brick.granite", 128, Material.stone).withTexCoords(11, 11).withHardness(2.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickMarble = new Block("brick.marble", 129, Material.stone).withTexCoords(10, 13).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickSlate = new Block("brick.slate", 130, Material.stone).withTexCoords(6, 13).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickStone = new Block("brick.stone", 131, Material.stone).withTexCoords(12, 9).withHardness(1.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickPermafrost = new Block("brick.permafrost", 132, Material.stone).withTexCoords(13, 15).withHardness(1.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        brickIron = new Block("brick.iron", 133, Material.metal).withTexCoords(8, 8).withHardness(5.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabPlanksOak = new BlockSlab(planksOak, 140).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_AXE);
        slabCobbleStone = new BlockSlab(cobbleStone, 141).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabSandstone = new BlockSlab(sandstone, 142).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickStonePolished = new BlockSlab(brickStonePolished, 143).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabStonePolished = new BlockSlab(stoneCarved, 144).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickMarble = new BlockSlab(brickMarble, 145).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickClay = new BlockSlab(brickClay, 146).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabCapstoneMarble = new BlockSlabMarble(capstoneMarble, 147).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabCobbleBasalt = new BlockSlab(cobbleBasalt, 148).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabCobbleLimestone = new BlockSlab(cobbleLimestone, 149).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabCobbleGranite = new BlockSlab(cobbleGranite, 150).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickBasalt = new BlockSlab(brickBasalt, 151).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickLimestone = new BlockSlab(brickLimestone, 152).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickGranite = new BlockSlab(brickGranite, 153).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabPlanksOakPainted = new BlockSlabPainted(planksOakPainted, 154).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_AXE);
        slabBrickSlate = new BlockSlab(brickSlate, 155).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBrickStone = new BlockSlab(brickStone, 156).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabGranitePolished = new BlockSlab(graniteCarved, 157).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabLimestonePolished = new BlockSlab(limestoneCarved, 158).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        slabBasaltPolished = new BlockSlab(basaltCarved, 159).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsPlanksOak = new BlockStairs(planksOak, 160).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_AXE);
        stairsCobbleStone = new BlockStairs(cobbleStone, 161).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickStonePolished = new BlockStairs(brickStonePolished, 162).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickMarble = new BlockStairs(brickMarble, 163).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsCobbleBasalt = new BlockStairs(cobbleBasalt, 164).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsCobbleLimestone = new BlockStairs(cobbleLimestone, 165).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsCobbleGranite = new BlockStairs(cobbleGranite, 166).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickBasalt = new BlockStairs(brickBasalt, 167).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickLimestone = new BlockStairs(brickLimestone, 168).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickGranite = new BlockStairs(brickGranite, 169).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickClay = new BlockStairs(brickClay, 170).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsPlanksOakPainted = new BlockStairsPainted(planksOakPainted, 171).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_AXE);
        stairsBrickSlate = new BlockStairs(brickSlate, 172).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        stairsBrickStone = new BlockStairs(brickStone, 173).withDisabledNeighborNotifyOnMetadataChange().withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        obsidian = new Block("obsidian", 180, Material.stone).withTexCoords(5, 2).withHardness(10.0f).withBlastResistance(2000.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        glass = new BlockGlass("glass", 190, Material.glass, false).withTexCoords(1, 3).withHardness(0.3f);
        glassTinted = new BlockGlassTinted("glass.tinted", 191).withTexCoords(6, 12).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange();
        grass = new BlockGrass("grass", 200, Material.grass).withTexCoords(0, 0, 2, 0, 3, 0).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.PASSIVE_MOBS_SPAWN, BlockTags.FIREFLIES_CAN_SPAWN, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH, BlockTags.CAVE_GEN_REPLACES_SURFACE);
        grassRetro = new BlockGrass("grass.retro", 201, Material.grass).withTexCoords(8, 1, 2, 0, 6, 3).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.PASSIVE_MOBS_SPAWN, BlockTags.FIREFLIES_CAN_SPAWN, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH, BlockTags.CAVE_GEN_REPLACES_SURFACE);
        grassScorched = new BlockGrassScorched("grass.scorched", 202, Material.grass).withTexCoords(16, 11, 13, 8, 17, 11).withHardness(0.6f).setDropOverride(dirtScorched).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH, BlockTags.PASSIVE_MOBS_SPAWN, BlockTags.FIREFLIES_CAN_SPAWN);
        pathDirt = new BlockDirtPath("path.dirt", 210).withTexCoords(4, 6, 2, 0, 5, 6).withHardness(0.5f).withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_SHOVEL);
        dirt = new Block("dirt", 220, Material.dirt).withTexCoords(2, 0).withHardness(0.5f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH);
        dirtScorched = new Block("dirt.scorched", 221, Material.dirt).withTexCoords(13, 8).withHardness(0.5f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.GROWS_CACTI, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH);
        dirtScorchedRich = new Block("dirt.scorched.rich", 222, Material.dirt).withTexCoords(12, 8).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE, BlockTags.GROWS_CACTI, BlockTags.CAVES_CUT_THROUGH);
        mud = new BlockMud("mud", 225, Material.dirt, false).withTexCoords(22, 0).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_CACTI, BlockTags.GROWS_TREES, BlockTags.CAVES_CUT_THROUGH);
        mudBaked = new BlockMud("mud.baked", 226, Material.stone, true).withTexCoords(23, 0).withHardness(1.5f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_CACTI);
        spongeDry = new BlockSponge("sponge.dry", 230, false).withTexCoords(0, 3).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHEARS);
        spongeWet = new BlockSponge("sponge.wet", 231, true).withTexCoords(11, 9).withHardness(1.0f).withTags(BlockTags.MINEABLE_BY_SHEARS);
        mossStone = new BlockMoss("moss.stone", 240).withTexCoords(1, 0).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE);
        mossBasalt = new BlockMoss("moss.basalt", 241).withTexCoords(6, 10).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE);
        mossLimestone = new BlockMoss("moss.limestone", 242).withTexCoords(9, 10).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE);
        mossGranite = new BlockMoss("moss.granite", 243).withTexCoords(9, 11).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.GROWS_FLOWERS, BlockTags.GROWS_SUGAR_CANE);
        sand = new BlockSand("sand", 250).withTexCoords(2, 1).withHardness(0.5f).withTags(BlockTags.MINEABLE_BY_SHOVEL, BlockTags.GROWS_SUGAR_CANE, BlockTags.GROWS_CACTI, BlockTags.CAVES_CUT_THROUGH);
        gravel = new BlockGravel("gravel", 251).withTexCoords(3, 1).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL);
        bedrock = new BlockBedrock("bedrock", 260, Material.stone).withTexCoords(1, 1).withSetUnbreakable().withBlastResistance(6000000.0f).withDisabledStats();
        fluidWaterFlowing = new BlockFluidFlowing("fluid.water.flowing", 270, Material.water).withTexCoords(14, 12, 13, 12, 14, 12).withHardness(100.0f).withLightOpacity(3).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.IS_WATER, BlockTags.PLACE_OVERWRITES, BlockTags.NOT_IN_CREATIVE_MENU);
        fluidWaterStill = new BlockFluidStill("fluid.water.still", 271, Material.water).withTexCoords(13, 12, 14, 12).withHardness(100.0f).withLightOpacity(3).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.IS_WATER, BlockTags.PLACE_OVERWRITES, BlockTags.NOT_IN_CREATIVE_MENU);
        fluidLavaFlowing = new BlockFluidFlowing("fluid.lava.flowing", 272, Material.lava).withTexCoords(14, 14, 13, 14, 14, 14).withHardness(0.0f).withLightValue(1.0f).withLightOpacity(255).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.IS_LAVA, BlockTags.PLACE_OVERWRITES, BlockTags.NOT_IN_CREATIVE_MENU);
        fluidLavaStill = new BlockFluidStill("fluid.lava.still", 273, Material.lava).withTexCoords(13, 14, 14, 14).withHardness(100.0f).withLightValue(1.0f).withLightOpacity(255).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.IS_LAVA, BlockTags.PLACE_OVERWRITES, BlockTags.NOT_IN_CREATIVE_MENU);
        logOak = new BlockLog("log.oak", 280).withTexCoords(1, 20, 0, 20).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        logPine = new BlockLog("log.pine", 281).withTexCoords(1, 23, 0, 23).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        logBirch = new BlockLog("log.birch", 282).withTexCoords(1, 24, 0, 24).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        logCherry = new BlockLog("log.cherry", 283).withTexCoords(1, 25, 0, 25).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        logEucalyptus = new BlockLog("log.eucalyptus", 284).withTexCoords(1, 26, 0, 26).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        logOakMossy = new BlockLog("log.oak.mossy", 285).withTexCoords(1, 21, 0, 21).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        leavesOak = new BlockLeavesOak("leaves.oak", 290).withTexCoords(2, 20).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesOakRetro = new BlockLeavesRetro("leaves.oak.retro", 291).withTexCoords(2, 22).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesPine = new BlockLeavesPine("leaves.pine", 292).withTexCoords(2, 23).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesBirch = new BlockLeavesBirch("leaves.birch", 293).withTexCoords(2, 24).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesCherry = new BlockLeavesCherry("leaves.cherry", 294).withTexCoords(2, 25).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesEucalyptus = new BlockLeavesEucalyptus("leaves.eucalyptus", 295).withTexCoords(2, 26).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesShrub = new BlockLeavesShrub("leaves.shrub", 296).withTexCoords(2, 27).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        leavesCherryFlowering = new BlockLeavesCherryFlowering("leaves.cherry.flowering", 297).withTexCoords(2, 25).withHardness(0.2f).withLightOpacity(1).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_SHEARS);
        saplingOak = new BlockSaplingOak("sapling.oak", 310).withTexCoords(4, 20).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingOakRetro = new BlockSaplingRetro("sapling.oak.retro", 311).withTexCoords(4, 20).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingPine = new BlockSaplingPine("sapling.pine", 312).withTexCoords(4, 23).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingBirch = new BlockSaplingBirch("sapling.birch", 313).withTexCoords(4, 24).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingCherry = new BlockSaplingCherry("sapling.cherry", 314).withTexCoords(4, 25).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingEucalyptus = new BlockSaplingEucalyptus("sapling.eucalyptus", 315).withTexCoords(4, 26).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        saplingShrub = new BlockSaplingShrub("sapling.shrub", 316).withTexCoords(4, 27).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        tallgrass = new BlockTallGrass("tallgrass", 320).setKilledByWeather().withTexCoords(7, 2).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH);
        tallgrassFern = new BlockTallGrass("tallgrass.fern", 321).setKilledByWeather().withTexCoords(8, 3).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH);
        deadbush = new BlockDeadBush("deadbush", 322).withTexCoords(7, 3).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH);
        spinifex = new BlockSpinifex("spinifex", 323).withTexCoords(12, 10).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH);
        algae = new BlockAlgae("algae", 324, Material.plant).withTexCoords(6, 1).withHardness(0.0f).withLitInteriorSurface(true).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH);
        flowerYellow = new BlockFlower("flower.yellow", 330).setKilledByWeather().withTexCoords(13, 0).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS);
        flowerRed = new BlockFlower("flower.red", 331).setKilledByWeather().withTexCoords(12, 0).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS);
        mushroomBrown = new BlockMushroom("mushroom.brown", 340).withTexCoords(13, 1).withHardness(0.0f).withLightValue(0.125f).withTags(BlockTags.BROKEN_BY_FLUIDS);
        mushroomRed = new BlockMushroom("mushroom.red", 341).withTexCoords(12, 1).withHardness(0.0f).withTags(BlockTags.BROKEN_BY_FLUIDS);
        oreCoalStone = new BlockOreCoal("ore.coal.stone", 350).withTexCoords(18, 0).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreCoalBasalt = new BlockOreCoal("ore.coal.basalt", 351).withTexCoords(18, 1).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreCoalLimestone = new BlockOreCoal("ore.coal.limestone", 352).withTexCoords(18, 2).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreCoalGranite = new BlockOreCoal("ore.coal.granite", 353).withTexCoords(18, 3).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreIronStone = new BlockOreIron("ore.iron.stone", 360, Material.stone).withTexCoords(17, 0).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreIronBasalt = new BlockOreIron("ore.iron.basalt", 361, Material.stone).withTexCoords(17, 1).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreIronLimestone = new BlockOreIron("ore.iron.limestone", 362, Material.stone).withTexCoords(17, 2).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreIronGranite = new BlockOreIron("ore.iron.granite", 363, Material.stone).withTexCoords(17, 3).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreGoldStone = new BlockOreGold("ore.gold.stone", 370, Material.stone).withTexCoords(16, 0).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreGoldBasalt = new BlockOreGold("ore.gold.basalt", 371, Material.stone).withTexCoords(16, 1).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreGoldLimestone = new BlockOreGold("ore.gold.limestone", 372, Material.stone).withTexCoords(16, 2).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreGoldGranite = new BlockOreGold("ore.gold.granite", 373, Material.stone).withTexCoords(16, 3).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreLapisStone = new BlockOreLapis("ore.lapis.stone", 380).withTexCoords(19, 0).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreLapisBasalt = new BlockOreLapis("ore.lapis.basalt", 381).withTexCoords(19, 1).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreLapisLimestone = new BlockOreLapis("ore.lapis.limestone", 382).withTexCoords(19, 2).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreLapisGranite = new BlockOreLapis("ore.lapis.granite", 383).withTexCoords(19, 3).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneStone = new BlockOreRedstone("ore.redstone.stone", 390, false, "ore.redstone.stone", "ore.redstone.glowing.stone").withTexCoords(21, 0).withHardness(3.0f).withBlastResistance(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneBasalt = new BlockOreRedstone("ore.redstone.basalt", 391, false, "ore.redstone.basalt", "ore.redstone.glowing.basalt").withTexCoords(21, 1).withHardness(3.0f).withBlastResistance(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneLimestone = new BlockOreRedstone("ore.redstone.limestone", 392, false, "ore.redstone.limestone", "ore.redstone.glowing.limestone").withTexCoords(21, 2).withHardness(3.0f).withBlastResistance(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneGranite = new BlockOreRedstone("ore.redstone.granite", 393, false, "ore.redstone.granite", "ore.redstone.glowing.granite").withTexCoords(21, 3).withHardness(3.0f).withBlastResistance(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneGlowingStone = new BlockOreRedstone("ore.redstone.glowing.stone", 400, true, "ore.redstone.stone", "ore.redstone.glowing.stone").withTexCoords(21, 0).withOverbright().withLightValue(0.2f).withHardness(3.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneGlowingBasalt = new BlockOreRedstone("ore.redstone.glowing.basalt", 401, true, "ore.redstone.basalt", "ore.redstone.glowing.basalt").withTexCoords(21, 1).withOverbright().withLightValue(0.2f).withHardness(3.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneGlowingLimestone = new BlockOreRedstone("ore.redstone.glowing.limestone", 402, true, "ore.redstone.limestone", "ore.redstone.glowing.limestone").withTexCoords(21, 2).withOverbright().withLightValue(0.2f).withHardness(3.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        oreRedstoneGlowingGranite = new BlockOreRedstone("ore.redstone.glowing.granite", 403, true, "ore.redstone.granite", "ore.redstone.glowing.granite").withTexCoords(21, 3).withOverbright().withLightValue(0.2f).withHardness(3.0f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        oreDiamondStone = new BlockOreDiamond("ore.diamond.stone", 410).withTexCoords(20, 0).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreDiamondBasalt = new BlockOreDiamond("ore.diamond.basalt", 411).withTexCoords(20, 1).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreDiamondLimestone = new BlockOreDiamond("ore.diamond.limestone", 412).withTexCoords(20, 2).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreDiamondGranite = new BlockOreDiamond("ore.diamond.granite", 413).withTexCoords(20, 3).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        oreNethercoalNetherrack = new BlockOreNetherCoal("ore.nethercoal.netherrack", 420).withTexCoords(10, 9).withOverbright().withHardness(3.0f).withBlastResistance(5.0f).withLightValue(0.625f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockCoal = new Block("block.coal", 430, Material.stone).withTexCoords(16, 7).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockIron = new Block("block.iron", 431, Material.metal).withTexCoords(16, 4, 16, 6, 16, 5).withHardness(5.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockGold = new Block("block.gold", 432, Material.metal).withTexCoords(17, 4, 17, 6, 17, 5).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockLapis = new Block("block.lapis", 433, Material.stone).withTexCoords(0, 9).withHardness(3.0f).withBlastResistance(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockRedstone = new BlockRedstone("block.redstone", 434, Material.stone).withTexCoords(0, 10).withHardness(5.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockDiamond = new Block("block.diamond", 435, Material.stone).withTexCoords(18, 4, 18, 6, 18, 5).withHardness(5.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockNetherCoal = new Block("block.nethercoal", 436, Material.stone).withTexCoords(17, 7).withHardness(3.0f).withBlastResistance(10.0f).withOverbright().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockSteel = new Block("block.steel", 437, Material.metal).withTexCoords(19, 4, 19, 6, 19, 5).withHardness(5.0f).withBlastResistance(2000.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockQuartz = new Block("block.quartz", 438, Material.stone).withTexCoords(12, 12).withHardness(3.0f).withBlastResistance(10.0f).withOverbright().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockOlivine = new Block("block.olivine", 439, Material.stone).withTexCoords(12, 11).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        blockCharcoal = new Block("block.charcoal", 440, Material.stone).withTexCoords(15, 7).withHardness(3.0f).withBlastResistance(10.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        wireRedstone = new BlockRedstoneWire("wire.redstone", 450).withTexCoords(4, 10).withHardness(0.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        torchRedstoneIdle = new BlockRedstoneTorch("torch.redstone.idle", 460, false).withTexCoords(3, 7).withHardness(0.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        torchRedstoneActive = new BlockRedstoneTorch("torch.redstone.active", 461, true).withTexCoords(3, 6).withHardness(0.0f).withLightValue(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS);
        buttonStone = new BlockButton("button.stone", 470).withTexCoords(1, 0).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_PICKAXE);
        leverCobbleStone = new BlockLever("lever.cobble.stone", 480).withTexCoords(0, 6).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_PICKAXE);
        pressureplateStone = new BlockPressurePlate("pressureplate.stone", 490, EnumMobType.mobs, Material.stone).withTexCoords(1, 0).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        pressureplatePlanksOak = new BlockPressurePlate("pressureplate.planks.oak", 491, EnumMobType.everything, Material.wood).withTexCoords(4, 0).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        pressureplateCobbleStone = new BlockPressurePlate("pressureplate.cobble.stone", 492, EnumMobType.players, Material.stone).withTexCoords(0, 1).withHardness(0.5f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        motionsensorIdle = new BlockMotionSensor("motionsensor.idle", 500, false).withTexCoords(10, 12, 10, 12, 7, 12, 10, 12, 10, 12, 10, 12).withHardness(2.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        motionsensorActive = new BlockMotionSensor("motionsensor.active", 501, true).withTexCoords(10, 12, 10, 12, 8, 12, 10, 12, 10, 12, 10, 12).withOverbright().withLightValue(0.3f).withHardness(2.0f).withBlastResistance(10.0f).withImmovableFlagSet().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        repeaterIdle = new BlockRedstoneRepeater("repeater.idle", 510, false).withHardness(0.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        repeaterActive = new BlockRedstoneRepeater("repeater.active", 511, true).withHardness(0.0f).withLightValue(0.625f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        pistonBase = new BlockPistonBase("piston.base", 520, false).withTexCoords(11, 6).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        pistonBaseSticky = new BlockPistonBase("piston.base.sticky", 521, true).withTexCoords(10, 6).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        pistonHead = new BlockPistonHead("piston.head", 522).withTexCoords(11, 6).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        pistonMoving = new BlockPistonMoving("piston.moving", 523).withTags(BlockTags.NOT_IN_CREATIVE_MENU);
        noteblock = new BlockNote("noteblock", 530).withTexCoords(10, 4).withHardness(0.8f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        rail = new BlockRail("rail", 540, false).withHardness(0.7f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_PICKAXE);
        railPowered = new BlockRail("rail.powered", 541, true).withHardness(0.7f).withOverbright().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_PICKAXE);
        railDetector = new BlockDetectorRail("rail.detector", 542).withTexCoords(3, 12).withHardness(0.7f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_PICKAXE);
        spikes = new BlockSpikes("spikes", 550, Material.metal).withTexCoords(7, 11, 14, 3, 6, 11).withLightOpacity(3).withHardness(2.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        dispenserCobbleStone = new BlockDispenser("dispenser.cobble.stone", 560).withTexCoords(14, 3, 14, 3, 14, 2, 13, 2, 13, 2, 13, 2).withHardness(3.5f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        trapdoorPlanksOak = new BlockTrapDoor("trapdoor.planks.oak", 570, Material.wood, false).withTexCoords(4, 5, 3, 3).withHardness(3.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        trapdoorIron = new BlockTrapDoor("trapdoor.iron", 571, Material.metal, true).withTexCoords(4, 7, 4, 3).withHardness(5.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        trapdoorGlass = new BlockTrapDoor("trapdoor.glass", 572, Material.glass, false).withTexCoords(1, 3, 5, 3).withHardness(5.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        tnt = new BlockTNT("tnt", 580).withTexCoords(9, 0, 10, 0, 8, 0).withHardness(0.0f);
        doorPlanksOakBottom = new BlockDoor("door.planks.oak.bottom", 590, Material.wood, false).withTexCoords(4, 5, 1, 6).withHardness(3.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        doorPlanksOakTop = new BlockDoor("door.planks.oak.top", 591, Material.wood, true).withTexCoords(4, 5, 1, 5).withHardness(3.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        doorIronBottom = new BlockDoor("door.iron.bottom", 592, Material.metal, false).withTexCoords(4, 7, 2, 6).withHardness(5.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        doorIronTop = new BlockDoor("door.iron.top", 593, Material.metal, true).withTexCoords(4, 7, 2, 5).withHardness(5.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        mesh = new BlockMesh("mesh", 600).withTexCoords(8, 11).withHardness(1.5f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        bed = new BlockBed("bed", 610).withHardness(0.2f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        cobweb = new BlockCobweb("cobweb", 620, Material.web).withTexCoords(11, 0).withLightOpacity(1).withHardness(4.0f).withTags(BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_SHEARS, BlockTags.MINEABLE_BY_SWORD);
        fire = new BlockFire("fire", 630).withTexCoords(15, 1).withHardness(0.0f).withLightValue(1.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.NOT_IN_CREATIVE_MENU);
        mobspawner = new BlockMobSpawner("mobspawner", 640).withTexCoords(1, 4).withHardness(5.0f).withDisabledStats().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        mobspawnerDeactivated = new BlockGlass("mobspawner.deactivated", 641, Material.stone, true).withTexCoords(1, 4).withHardness(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        workbench = new BlockWorkbench("workbench", 650).withTexCoords(11, 2, 4, 0, 11, 3, 12, 3, 11, 3, 12, 3).withHardness(2.5f).withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        furnaceStoneIdle = new BlockFurnace("furnace.stone.idle", 660, false).withTexCoords(14, 3, 14, 3, 12, 2, 13, 2, 13, 2, 13, 2).withHardness(3.5f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        furnaceStoneActive = new BlockFurnace("furnace.stone.active", 661, true).withTexCoords(14, 3, 14, 3, 13, 3, 13, 2, 13, 2, 13, 2).withHardness(3.5f).withLightValue(0.875f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        furnaceBlastIdle = new BlockBlastFurnace("furnace.blast.idle", 662, false).withTexCoords(15, 8, 14, 9, 13, 7, 14, 7, 14, 7, 14, 7).withHardness(3.5f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        furnaceBlastActive = new BlockBlastFurnace("furnace.blast.active", 663, true).withTexCoords(15, 8, 14, 9, 14, 8, 14, 7, 14, 7, 14, 7).withHardness(3.5f).withLightValue(0.875f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        trommelIdle = new BlockTrommel("trommel.idle", 670, Material.stone, false).withTexCoords(1, 10, 1, 10, 2, 10, 2, 8, 2, 10, 1, 8).withHardness(3.5f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        trommelActive = new BlockTrommel("trommel.active", 671, Material.stone, true).withTexCoords(1, 10, 1, 10, 2, 7, 2, 8, 1, 7, 1, 11).withHardness(3.5f).withLightValue(0.875f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        chestLegacy = new BlockChestLegacy("chest.legacy", 680, Material.wood).withHardness(2.5f).withBlastResistance(5.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        chestLegacyPainted = new BlockChestLegacy("chest.legacy.painted", 681, Material.wood).withHardness(2.5f).withBlastResistance(5.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        chestPlanksOak = new BlockChest("chest.planks.oak", 682, Material.wood).withHardness(2.5f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        chestPlanksOakPainted = new BlockChestPainted("chest.planks.oak.painted", 683, Material.wood).withHardness(2.5f).withBlastResistance(5.0f).withDisabledNeighborNotifyOnMetadataChange().withImmovableFlagSet().withLightOpacity(3).withTags(BlockTags.FENCES_CONNECT, BlockTags.MINEABLE_BY_AXE);
        basket = new BlockBasket("basket", 900, Material.cloth).withTexCoords(4, 9, 4, 9, 4, 8).withHardness(0.5f).withTags(BlockTags.NOT_IN_CREATIVE_MENU);
        cropsWheat = new BlockCrops("crops.wheat", 690).withHardness(0.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        farmlandDirt = new BlockFarmland("farmland.dirt", 700).withTexCoords(2, 0).withHardness(0.6f).withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_SHOVEL);
        signPostPlanksOak = new BlockSign("sign.post.planks.oak", 710, TileEntitySign.class, true).withTexCoords(4, 0).withHardness(1.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        signWallPlanksOak = new BlockSign("sign.wall.planks.oak", 711, TileEntitySign.class, false).withTexCoords(4, 0).withHardness(1.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        flag = new BlockFlag("flag", 712, Material.wood).withTexCoords(4, 0).withHardness(1.0f).withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_AXE);
        layerSnow = new BlockLayerSnow("layer.snow", 720, Material.topSnow).withTexCoords(2, 4).withHardness(0.1f).withLitInteriorSurface(true).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.MINEABLE_BY_SHOVEL, BlockTags.OVERRIDE_STEPSOUND);
        layerLeavesOak = new BlockLayerLeaves("layer.leaves.oak", 721, Material.leaves).withTexCoords(2, 20).withLitInteriorSurface(true).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.PLACE_OVERWRITES, BlockTags.SHEARS_DO_SILK_TOUCH, BlockTags.MINEABLE_BY_SHEARS, BlockTags.MINEABLE_BY_SWORD, BlockTags.MINEABLE_BY_AXE, BlockTags.MINEABLE_BY_HOE);
        layerSlate = new BlockLayerSlate("layer.slate", 722, Material.stone).withTexCoords(8, 13, 7, 13).withHardness(1.5f).withBlastResistance(10.0f).withLitInteriorSurface(true).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        ice = new BlockIce("ice", 730).withTexCoords(3, 4).withHardness(0.5f).withLightOpacity(3).withTags(BlockTags.SKATEABLE, BlockTags.MINEABLE_BY_PICKAXE);
        permaice = new BlockSlippery("ice.perma", 731, Material.ice).withTexCoords(10, 15).withHardness(1.5f).withBlastResistance(10.0f).withTags(BlockTags.SKATEABLE, BlockTags.MINEABLE_BY_PICKAXE);
        blockSnow = new BlockSnow("block.snow", 740).withTexCoords(2, 4).withHardness(0.2f).withTags(BlockTags.CAVES_CUT_THROUGH, BlockTags.MINEABLE_BY_SHOVEL);
        cactus = new BlockCactus("cactus", 750).withTexCoords(5, 4, 7, 4, 6, 4).withHardness(0.4f).withTags(BlockTags.GROWS_CACTI, BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_SHEARS, BlockTags.MINEABLE_BY_HOE);
        blockClay = new BlockClay("block.clay", 760).withTexCoords(8, 4).withHardness(0.6f).withTags(BlockTags.MINEABLE_BY_SHOVEL);
        sugarcane = new BlockSugarcane("sugarcane", 770).withTexCoords(9, 4).withHardness(0.0f).withDisabledStats().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        jukebox = new BlockJukeBox("jukebox", 780).withTexCoords(11, 4, 10, 4, 10, 4).withHardness(2.0f).withBlastResistance(10.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        pumpkin = new BlockPumpkin("pumpkin", 790).withTexCoords(6, 6, 5, 5, 6, 7).withHardness(1.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        pumpkinCarvedIdle = new BlockPumpkin("pumpkin.carved.idle", 791).withTexCoords(6, 6, 5, 5, 7, 7, 6, 7, 6, 7, 6, 7).withHardness(1.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        pumpkinCarvedActive = new BlockPumpkin("pumpkin.carved.active", 792).withTexCoords(6, 6, 5, 5, 8, 7, 6, 7, 6, 7, 6, 7).withHardness(1.0f).withLightValue(1.0f).withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_AXE);
        netherrack = new Block("netherrack", 800, Material.stone).withTexCoords(7, 6).withHardness(0.4f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.FIREFLIES_CAN_SPAWN);
        netherrackIgneous = new BlockIgneousNetherrack("netherrack.igneous", 801, Material.stone).withTexCoords(12, 4).withOverbright().withHardness(1.25f).withBlastResistance(7.0f).withLightValue(10).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        soulsand = new BlockSoulSand("soulsand", 810).withTexCoords(8, 6).withHardness(0.5f).withTags(BlockTags.MINEABLE_BY_SHOVEL);
        glowstone = new BlockGlowStone("glowstone", 820, Material.stone).withTexCoords(9, 6).withHardness(0.3f).withLightValue(1.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE);
        portalNether = new BlockPortal("portal.nether", 830, 1, Block.obsidian.id, Block.fire.id).withTexCoords(14, 0).withHardness(-1.0f).withLightValue(0.75f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        portalParadise = new BlockPortal("portal.paradise", 831, 2, Block.glowstone.id, Block.bedrock.id).withTexCoords(14, 0).withHardness(-1.0f).withLightValue(0.75f).withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        cake = new BlockCake("cake", 840).withTexCoords(9, 7, 12, 7, 10, 7).withHardness(0.5f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        lampIdle = new BlockLamp("lamp.idle", 850, false).withTexCoords(4, 12).withHardness(0.5f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.MINEABLE_BY_PICKAXE);
        lampActive = new BlockLamp("lamp.active", 851, true).withLightValue(0.9375f).withTexCoords(5, 12).withHardness(0.5f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.NOT_IN_CREATIVE_MENU, BlockTags.MINEABLE_BY_PICKAXE);
        lanternFireflyGreen = new BlockLanternFirefly("lantern.firefly.green", 870, EnumFireflyColour.GREEN).withHardness(0.1f).withLightValue(0.9375f).withTexCoords(13, 11).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_SWORD, BlockTags.NOT_IN_CREATIVE_MENU);
        lanternFireflyBlue = new BlockLanternFirefly("lantern.firefly.blue", 871, EnumFireflyColour.BLUE).withHardness(0.1f).withLightValue(0.9375f).withTexCoords(13, 10).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_SWORD, BlockTags.NOT_IN_CREATIVE_MENU);
        lanternFireflyOrange = new BlockLanternFirefly("lantern.firefly.orange", 872, EnumFireflyColour.ORANGE).withHardness(0.1f).withLightValue(0.9375f).withTexCoords(14, 10).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_SWORD, BlockTags.NOT_IN_CREATIVE_MENU);
        lanternFireflyRed = new BlockLanternFirefly("lantern.firefly.red", 873, EnumFireflyColour.RED).withHardness(0.1f).withLightValue(0.9375f).withTexCoords(14, 11).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.MINEABLE_BY_SWORD, BlockTags.NOT_IN_CREATIVE_MENU);
        overlayPebbles = new BlockOverlayPebbles("overlay.pebbles", 880, Material.decoration).withHardness(0.0f).withDisabledStats().withDisabledNeighborNotifyOnMetadataChange().withTags(BlockTags.BROKEN_BY_FLUIDS, BlockTags.NOT_IN_CREATIVE_MENU);
        fenceChainlink = new BlockFenceChainlink("fence.chainlink", 890, Material.metal).withTexCoords(7, 19).withHardness(5.0f).withTags(BlockTags.MINEABLE_BY_PICKAXE, BlockTags.CHAINLINK_FENCES_CONNECT);
        ((BlockStone)stone).setCobblestoneType(cobbleStone);
        ((BlockStone)limestone).setCobblestoneType(cobbleLimestone);
        ((BlockStone)granite).setCobblestoneType(cobbleGranite);
        ((BlockStone)basalt).setCobblestoneType(cobbleBasalt);
        ((BlockStone)permafrost).setCobblestoneType(cobblePermafrost);
        ((BlockLanternFirefly)lanternFireflyGreen).setItem(Item.lanternFireflyGreen);
        ((BlockLanternFirefly)lanternFireflyOrange).setItem(Item.lanternFireflyOrange);
        ((BlockLanternFirefly)lanternFireflyBlue).setItem(Item.lanternFireflyBlue);
        ((BlockLanternFirefly)lanternFireflyRed).setItem(Item.lanternFireflyRed);
        BlockMoss.initMossMap();
        ((BlockLayerBase)layerSnow).setFullBlockID(Block.blockSnow.id);
        ((BlockLayerBase)layerLeavesOak).setFullBlockID(Block.leavesOak.id);
        ((BlockLayerBase)layerSlate).setFullBlockID(Block.slate.id);
        Item.itemsList[Block.wool.id] = new ItemBlockPainted(wool, false);
        Item.itemsList[Block.pistonBase.id] = new ItemBlockPiston(pistonBase);
        Item.itemsList[Block.pistonBaseSticky.id] = new ItemBlockPiston(pistonBaseSticky);
        Item.itemsList[Block.planksOakPainted.id] = new ItemBlockPainted(planksOakPainted, false);
        Item.itemsList[Block.chestPlanksOakPainted.id] = new ItemBlockPainted(chestPlanksOakPainted, true);
        Item.itemsList[Block.fencePlanksOakPainted.id] = new ItemBlockPainted(fencePlanksOakPainted, false);
        Item.itemsList[Block.fencegatePlanksOakPainted.id] = new ItemBlockPainted(fencegatePlanksOakPainted, true);
        Item.itemsList[Block.lampIdle.id] = new ItemBlockLamp(lampIdle);
        Item.itemsList[Block.algae.id] = new ItemBlockAlgae(algae);
        Item.itemsList[Block.chestLegacy.id] = new ItemBlockChestLegacy(chestLegacy);
        Item.itemsList[Block.layerLeavesOak.id] = new ItemBlockLayerLeaves(layerLeavesOak);
        Item.itemsList[Block.ladderOak.id] = new ItemBlockLadder((BlockLadder)ladderOak);
        for (i = Block.slabPlanksOak.id; i <= Block.slabBasaltPolished.id; ++i) {
            if (blocksList[i] == null || i == Block.slabPlanksOakPainted.id) continue;
            Item.itemsList[i] = new ItemBlockSlab(blocksList[i]);
        }
        Item.itemsList[Block.slabPlanksOakPainted.id] = new ItemBlockSlabPainted(slabPlanksOakPainted);
        Item.itemsList[Block.stairsPlanksOakPainted.id] = new ItemBlockStairsPainted(stairsPlanksOakPainted);
        for (i = 0; i < blocksList.length; ++i) {
            if (blocksList[i] == null || Item.itemsList[i] != null) continue;
            Item.itemsList[i] = blocksList[i] instanceof BlockLeavesBase ? new ItemBlockLeaves(blocksList[i]) : (blocksList[i] instanceof BlockLayerBase ? new ItemBlockLayer(blocksList[i]) : new ItemBlock(blocksList[i]));
            blocksList[i].initializeBlock();
        }
        Block.canBlockGrass[0] = true;
        StatList.onBlockInit();
    }
}

