/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class BlockChestLegacy
extends BlockTileEntity {
    public BlockChestLegacy(String key, int id, Material material) {
        super(key, id, Material.wood);
        this.withTexCoords(9, 1);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        if (side.isHorizontal()) {
            return BlockChestLegacy.texCoordToIndex(10, 1);
        }
        return BlockChestLegacy.texCoordToIndex(9, 1);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        super.randomDisplayTick(world, x, y, z, rand);
        try {
            this.updateLegacyChest(world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        try {
            this.updateLegacyChest(world, x, y, z);
            return Block.blocksList[world.getBlockId(x, y, z)].getBreakResult(world, dropCause, x, y, z, meta, tileEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ItemStack[0];
        }
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityChest();
    }

    public static boolean isLegacyChest(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        return id == Block.chestLegacy.id || id == Block.chestLegacyPainted.id;
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        BlockChest.dropChestContent(world, x, y, z);
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        try {
            this.updateLegacyChest(world, x, y, z);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void updateLegacyChest(World world, int x, int y, int z) {
        if (!BlockChestLegacy.isLegacyChest(world, x, y, z)) {
            throw new RuntimeException("Not a Legacy Chest: X: " + x + " Y:  Z: " + z);
        }
        Direction facingDirection = Direction.SOUTH;
        Direction otherChestDirection = null;
        if (BlockChestLegacy.isLegacyChest(world, x + 1, y, z)) {
            otherChestDirection = Direction.EAST;
        }
        if (BlockChestLegacy.isLegacyChest(world, x - 1, y, z)) {
            otherChestDirection = Direction.WEST;
        }
        if (BlockChestLegacy.isLegacyChest(world, x, y, z + 1)) {
            otherChestDirection = Direction.SOUTH;
        }
        if (BlockChestLegacy.isLegacyChest(world, x, y, z - 1)) {
            otherChestDirection = Direction.NORTH;
        }
        if (otherChestDirection == null) {
            int meta = world.getBlockMetadata(x, y, z);
            if (world.isBlockOpaqueCube(x + 1, y, z) && !world.isBlockOpaqueCube(x - 1, y, z)) {
                facingDirection = Direction.WEST;
            }
            if (world.isBlockOpaqueCube(x - 1, y, z) && !world.isBlockOpaqueCube(x + 1, y, z)) {
                facingDirection = Direction.EAST;
            }
            if (world.isBlockOpaqueCube(x, y, z + 1) && !world.isBlockOpaqueCube(x, y, z - 1)) {
                facingDirection = Direction.NORTH;
            }
            if (world.isBlockOpaqueCube(x, y, z - 1) && !world.isBlockOpaqueCube(x, y, z + 1)) {
                facingDirection = Direction.SOUTH;
            }
            meta = BlockChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockChest.getMetaWithType(meta, BlockChest.Type.SINGLE);
            this.updateChestBlock(world, x, y, z, meta);
        } else {
            int otherChestX = x;
            int otherChestZ = z;
            if (otherChestDirection == Direction.NORTH) {
                --otherChestZ;
            }
            if (otherChestDirection == Direction.SOUTH) {
                ++otherChestZ;
            }
            if (otherChestDirection == Direction.EAST) {
                ++otherChestX;
            }
            if (otherChestDirection == Direction.WEST) {
                --otherChestX;
            }
            int meta = world.getBlockMetadata(x, y, z);
            int otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ);
            if (otherChestDirection == Direction.NORTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(x + 1, y, z) || world.isBlockOpaqueCube(x + 1, y, z - 1)) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.SOUTH) {
                facingDirection = Direction.EAST;
                if (world.isBlockOpaqueCube(x + 1, y, z) || world.isBlockOpaqueCube(x + 1, y, z + 1)) {
                    facingDirection = Direction.WEST;
                }
            }
            if (otherChestDirection == Direction.EAST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(x, y, z + 1) || world.isBlockOpaqueCube(x + 1, y, z + 1)) {
                    facingDirection = Direction.NORTH;
                }
            }
            if (otherChestDirection == Direction.WEST) {
                facingDirection = Direction.SOUTH;
                if (world.isBlockOpaqueCube(x, y, z + 1) || world.isBlockOpaqueCube(x - 1, y, z + 1)) {
                    facingDirection = Direction.NORTH;
                }
            }
            BlockChest.Type type = BlockChest.Type.SINGLE;
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.EAST) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.NORTH && otherChestDirection == Direction.WEST) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.NORTH) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.EAST && otherChestDirection == Direction.SOUTH) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.EAST) {
                type = BlockChest.Type.LEFT;
            }
            if (facingDirection == Direction.SOUTH && otherChestDirection == Direction.WEST) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.NORTH) {
                type = BlockChest.Type.RIGHT;
            }
            if (facingDirection == Direction.WEST && otherChestDirection == Direction.SOUTH) {
                type = BlockChest.Type.LEFT;
            }
            BlockChest.Type otherType = BlockChest.Type.SINGLE;
            if (type == BlockChest.Type.LEFT) {
                otherType = BlockChest.Type.RIGHT;
            }
            if (type == BlockChest.Type.RIGHT) {
                otherType = BlockChest.Type.LEFT;
            }
            meta = BlockChest.getMetaWithDirection(meta, facingDirection);
            meta = BlockChest.getMetaWithType(meta, type);
            otherMeta = BlockChest.getMetaWithDirection(otherMeta, facingDirection);
            otherMeta = BlockChest.getMetaWithType(otherMeta, otherType);
            this.updateChestBlock(world, x, y, z, meta);
            this.updateChestBlock(world, otherChestX, y, otherChestZ, otherMeta);
        }
    }

    public void updateChestBlock(World world, int x, int y, int z, int meta) {
        if (!BlockChestLegacy.isLegacyChest(world, x, y, z)) {
            throw new RuntimeException("Not a Legacy Chest: X: " + x + " Y:  Z: " + z);
        }
        int legacyChestMeta = world.getBlockMetadata(x, y, z);
        Block block = Block.chestPlanksOak;
        if (legacyChestMeta > 0) {
            block = Block.chestPlanksOakPainted;
            meta |= legacyChestMeta << 4;
        }
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        chunk.blocks[(x & 0xF) << world.getHeightBits() + 4 | (z & 0xF) << world.getHeightBits() | y] = (short)block.id;
        chunk.data.set(x & 0xF, y, z & 0xF, meta);
        world.markBlocksDirty(x, y, z, x, y, z);
    }
}

