/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntityRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockFurnace
extends BlockTileEntityRotatable {
    protected Random furnaceRand = new Random();
    protected final boolean isActive;
    protected static boolean keepFurnaceInventory = false;

    public BlockFurnace(String key, int id, boolean flag) {
        super(key, id, Material.stone);
        this.isActive = flag;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.setDefaultDirection(world, i, j, k);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(Block.furnaceStoneIdle)};
            }
        }
        return null;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        float f = (float)x + 0.5f;
        float f1 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)z + 0.5f;
        float f3 = 0.52f;
        float f4 = rand.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.spawnParticle("smoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 5) {
            world.spawnParticle("smoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isClientSide) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(x, y, z);
            player.displayGUIFurnace(tileentityfurnace);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean lit, World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        TileEntity tileentity = world.getBlockTileEntity(x, y, z);
        if (tileentity == null) {
            String msg = "Furnace is missing Tile Entity at x: " + x + " y: " + y + " z: " + z + ", block will be removed!";
            throw new RuntimeException(msg);
        }
        keepFurnaceInventory = true;
        if (lit) {
            world.setBlockWithNotify(x, y, z, Block.furnaceStoneActive.id);
        } else {
            world.setBlockWithNotify(x, y, z, Block.furnaceStoneIdle.id);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(x, y, z, meta);
        tileentity.validate();
        world.setBlockTileEntity(x, y, z, tileentity);
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityFurnace();
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        if (!keepFurnaceInventory) {
            TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.getBlockTileEntity(x, y, z);
            for (int l = 0; l < tileentityfurnace.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.furnaceRand.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.yd = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.furnaceRand.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoval(world, x, y, z);
    }
}

