/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityNote;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.world.World;

public class BlockNote
extends BlockTileEntity {
    public BlockNote(String key, int id) {
        super(key, id, Material.wood);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].canProvidePower()) {
            boolean flag = world.isBlockGettingPowered(x, y, z);
            TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(x, y, z);
            if (tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(world, x, y, z);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isClientSide) {
            return true;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(x, y, z);
        tileentitynote.changePitch();
        tileentitynote.triggerNote(world, x, y, z);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isClientSide) {
            return;
        }
        TileEntityNote tileentitynote = (TileEntityNote)world.getBlockTileEntity(x, y, z);
        tileentitynote.triggerNote(world, x, y, z);
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityNote();
    }

    @Override
    public void playBlock(World world, int x, int y, int z, int instrument, int pitch) {
        float f = (float)Math.pow(2.0, (double)(pitch - 12) / 12.0);
        String s = "harp";
        if (instrument == 1) {
            s = "bd";
        }
        if (instrument == 2) {
            s = "snare";
        }
        if (instrument == 3) {
            s = "hat";
        }
        if (instrument == 4) {
            s = "bassattack";
        }
        world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note." + s, 3.0f, f);
        world.spawnParticle("note", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, (double)pitch / 24.0, 0.0, 0.0);
    }
}

