/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockOreRedstone
extends Block {
    private boolean illuminated;
    private String keyNormal;
    private String keyIlluminated;

    public BlockOreRedstone(String key, int id, boolean illuminated, String normalKey, String illuminatedKey) {
        super(key, id, Material.stone);
        if (illuminated) {
            this.setTickOnLoad(true);
        }
        this.illuminated = illuminated;
        this.keyNormal = normalKey;
        this.keyIlluminated = illuminatedKey;
    }

    @Override
    public int getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (this.illuminated) {
            return Block.texCoordToIndex(4, 16);
        }
        return -1;
    }

    @Override
    public int tickRate() {
        return 30;
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        this.lightRedstone(world, x, y, z);
        super.onBlockClicked(world, x, y, z, player);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.lightRedstone(world, x, y, z);
        super.onEntityWalking(world, x, y, z, entity);
    }

    private void lightRedstone(World world, int i, int j, int k) {
        this.func_319_i(world, i, j, k);
        if (!this.illuminated) {
            world.setBlockWithNotify(i, j, k, Block.getBlockByName((String)this.keyIlluminated).id);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            world.setBlockWithNotify(x, y, z, Block.getBlockByName((String)this.keyNormal).id);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(Block.getBlockByName(this.keyNormal))};
            }
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(Item.dustRedstone, 4 + world.rand.nextInt(2))};
            }
        }
        return null;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            this.func_319_i(world, x, y, z);
        }
    }

    private void func_319_i(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockOpaqueCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockOpaqueCube(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.isBlockOpaqueCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockOpaqueCube(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.isBlockOpaqueCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockOpaqueCube(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }
}

