/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityPiston;
import net.minecraft.core.block.logic.PistonDirections;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockPistonMoving
extends BlockTileEntity {
    public BlockPistonMoving(String key, int id) {
        super(key, id, Material.piston);
        this.withHardness(-1.0f);
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return null;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        TileEntity tileentity = world.getBlockTileEntity(x, y, z);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileentity).clearPistonTileEntity();
        } else {
            super.onBlockRemoval(world, x, y, z);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isClientSide && world.getBlockTileEntity(x, y, z) == null) {
            world.setBlockWithNotify(x, y, z, 0);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (world.isClientSide) {
            return;
        }
        TileEntityPiston piston = this.func_31034_c(world, x, y, z);
        if (piston != null) {
            Block.blocksList[piston.getStoredBlockID()].dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide || world.getBlockTileEntity(x, y, z) != null) {
            // empty if block
        }
    }

    public static TileEntity func_31036_a(int i, int j, int k, boolean flag, boolean flag1) {
        return new TileEntityPiston(i, j, k, flag, flag1);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, x, y, z);
        if (tileentitypiston == null) {
            return null;
        }
        float f = tileentitypiston.func_31008_a(0.0f);
        if (tileentitypiston.func_31015_b()) {
            f = 1.0f - f;
        }
        return this.func_31035_a(world, x, y, z, tileentitypiston.getStoredBlockID(), f, tileentitypiston.func_31009_d());
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        TileEntityPiston tileentitypiston = this.func_31034_c(world, x, y, z);
        if (tileentitypiston != null) {
            Block block = Block.blocksList[tileentitypiston.getStoredBlockID()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(world, x, y, z);
            float f = tileentitypiston.func_31008_a(0.0f);
            if (tileentitypiston.func_31015_b()) {
                f = 1.0f - f;
            }
            int l = tileentitypiston.func_31009_d();
            this.minX = block.minX - (double)((float)PistonDirections.xOffset[l] * f);
            this.minY = block.minY - (double)((float)PistonDirections.yOffset[l] * f);
            this.minZ = block.minZ - (double)((float)PistonDirections.zOffset[l] * f);
            this.maxX = block.maxX - (double)((float)PistonDirections.xOffset[l] * f);
            this.maxY = block.maxY - (double)((float)PistonDirections.yOffset[l] * f);
            this.maxZ = block.maxZ - (double)((float)PistonDirections.zOffset[l] * f);
        }
    }

    public AABB func_31035_a(World world, int i, int j, int k, int l, float f, int i1) {
        if (l == 0 || l == this.id) {
            return null;
        }
        AABB axisalignedbb = Block.blocksList[l].getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb == null) {
            return null;
        }
        axisalignedbb.minX -= (double)((float)PistonDirections.xOffset[i1] * f);
        axisalignedbb.maxX -= (double)((float)PistonDirections.xOffset[i1] * f);
        axisalignedbb.minY -= (double)((float)PistonDirections.yOffset[i1] * f);
        axisalignedbb.maxY -= (double)((float)PistonDirections.yOffset[i1] * f);
        axisalignedbb.minZ -= (double)((float)PistonDirections.zOffset[i1] * f);
        axisalignedbb.maxZ -= (double)((float)PistonDirections.zOffset[i1] * f);
        return axisalignedbb;
    }

    private TileEntityPiston func_31034_c(WorldSource iblockaccess, int i, int j, int k) {
        TileEntity tileentity = iblockaccess.getBlockTileEntity(i, j, k);
        if (tileentity != null && tileentity instanceof TileEntityPiston) {
            return (TileEntityPiston)tileentity;
        }
        return null;
    }
}

