/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumMobType;
import net.minecraft.core.sound.SoundType;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockPressurePlate
extends Block {
    private EnumMobType triggerMobType;

    public BlockPressurePlate(String key, int id, EnumMobType enummobtype, Material material) {
        super(key, id, material);
        this.triggerMobType = enummobtype;
        this.setTickOnLoad(true);
        float f = 0.0625f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag;
        boolean bl = flag = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
        if (flag) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockMetadata(x, y, z) != 0) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (world.getBlockMetadata(x, y, z) != 1) {
            this.setStateIfMobInteractsWithPlate(world, x, y, z);
        }
    }

    private void setStateIfMobInteractsWithPlate(World world, int i, int j, int k) {
        boolean flag = world.getBlockMetadata(i, j, k) == 1;
        boolean flag1 = false;
        float f = 0.125f;
        List<Entity> list = null;
        if (this.triggerMobType == EnumMobType.everything) {
            list = world.getEntitiesWithinAABBExcludingEntity(null, AABB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.mobs) {
            list = world.getEntitiesWithinAABB(EntityLiving.class, AABB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.triggerMobType == EnumMobType.players) {
            list = world.getEntitiesWithinAABB(EntityPlayer.class, AABB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
            world.notifyBlocksOfNeighborChange(i, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
            world.notifyBlocksOfNeighborChange(i, j, k, this.id);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect(SoundType.WORLD_SOUNDS, (double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            world.scheduleBlockUpdate(i, j, k, this.id, this.tickRate());
        }
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l > 0) {
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        }
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int x, int y, int z) {
        boolean flag = world.getBlockMetadata(x, y, z) == 1;
        float f = 0.0625f;
        if (flag) {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return blockAccess.getBlockMetadata(x, y, z) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return false;
        }
        return side == 1;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.setBlockBounds(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }

    @Override
    public int getMobilityFlag() {
        return 1;
    }
}

