/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockRedstone
extends Block {
    public BlockRedstone(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        return this.isPoweringTo(world, x, y, z, side);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.id);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.id);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.id);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.id);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.id);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.id);
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, this.id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x + 1, y, z, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, this.id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, this.id);
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        this.func_319_i(world, x, y, z);
    }

    private void func_319_i(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        for (int l = 0; l < 6; ++l) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockOpaqueCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockOpaqueCube(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.isBlockOpaqueCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockOpaqueCube(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.isBlockOpaqueCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockOpaqueCube(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (!(d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k) && !(d3 > (double)(k + 1))) continue;
            world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }
}

