/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.crafting.recipe;

import net.minecraft.core.crafting.recipe.IRecipe;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeLabel
implements IRecipe {
    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack itemStack = null;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id && labelStack == null) {
                    labelStack = stack;
                } else if (itemStack == null && stack.canItemBeRenamed()) {
                    itemStack = stack;
                }
                if (labelStack != null && itemStack != null) break block0;
            }
        }
        if (labelStack != null && itemStack != null) {
            ItemStack outStack = itemStack.copy();
            if (labelStack.tag.getBoolean("overrideName")) {
                outStack.tag.putBoolean("overrideName", true);
                outStack.tag.putString("name", labelStack.tag.getString("name"));
            }
            if (labelStack.tag.getBoolean("overrideColor")) {
                outStack.tag.putBoolean("overrideColor", true);
                outStack.tag.putByte("color", labelStack.tag.getByte("color"));
            }
            return outStack;
        }
        return null;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Item.label);
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int labelCount = 0;
        int itemCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id) {
                    ++labelCount;
                    continue;
                }
                if (stack.getItem() instanceof ItemBlock || stack.getMaxStackSize() != 1) continue;
                ++itemCount;
            }
        }
        return labelCount == 1 && itemCount == 1;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                inventorycrafting.setSlotContentsAt(x, y, null);
            }
        }
        return returnStack;
    }
}

