/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.crafting.recipe;

import net.minecraft.core.crafting.recipe.IRecipe;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeLabelDye
implements IRecipe {
    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        ItemStack labelStack = null;
        ItemStack dyeStack = null;
        block0: for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id && labelStack == null) {
                    labelStack = stack;
                } else if (stack.itemID == Item.dye.id && dyeStack == null) {
                    dyeStack = stack;
                }
                if (labelStack != null && dyeStack != null) break block0;
            }
        }
        if (labelStack != null && dyeStack != null) {
            ItemStack outStack = labelStack.copy();
            outStack.tag.putBoolean("overrideColor", true);
            outStack.tag.putByte("color", (byte)(15 - dyeStack.getMetadata()));
            return outStack;
        }
        return null;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return new ItemStack(Item.label);
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        int labelCount = 0;
        int dyeCount = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == Item.label.id) {
                    ++labelCount;
                }
                if (stack.itemID != Item.dye.id) continue;
                ++dyeCount;
            }
        }
        return labelCount == 1 && dyeCount == 1;
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                --stack.stackSize;
                if (stack.stackSize > 0) continue;
                inventorycrafting.setSlotContentsAt(x, y, null);
            }
        }
        return returnStack;
    }
}

