/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFlying;
import net.minecraft.core.entity.animal.IAnimal;
import net.minecraft.core.enums.EnumFireflyColour;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;

public class EntityFireflyCluster
extends EntityFlying
implements IAnimal {
    private int biomeAssimilationTimer;
    private final int MAX_ASSIMILATION_TIME = 6000;
    public int courseChangeCooldown;
    public int clusterSize;

    public EntityFireflyCluster(World world) {
        super(world);
        this.setSize(5.0f, 3.0f);
        this.courseChangeCooldown = 0;
        this.moveSpeed = 0.05f;
        this.fireImmune = true;
        this.biomeAssimilationTimer = 6000;
        this.clusterSize = this.random.nextInt(5) + 3;
    }

    @Override
    public void spawnInit() {
        super.init();
        Biome currentBiome = this.world.getBlockBiome((int)this.x, (int)this.y, (int)this.z);
        EnumFireflyColour colour = null;
        block0: for (EnumFireflyColour c : EnumFireflyColour.values()) {
            if (c.getSpawnBiomes() == null) continue;
            for (Biome b : c.getSpawnBiomes()) {
                if (b != currentBiome) continue;
                colour = c;
                continue block0;
            }
        }
        if (colour == null) {
            for (EnumFireflyColour c : EnumFireflyColour.values()) {
                if (c.getSpawnBiomes() != null) continue;
                colour = c;
                break;
            }
        }
        this.setColour(colour);
    }

    protected EnumFireflyColour getColourForBiome(Biome currentBiome) {
        for (EnumFireflyColour c : EnumFireflyColour.values()) {
            if (c.getSpawnBiomes() == null) continue;
            for (Biome b : c.getSpawnBiomes()) {
                if (b != currentBiome) continue;
                return c;
            }
        }
        return EnumFireflyColour.GREEN;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("colour", this.entityData.getByte(16));
        tag.putShort("BiomeAssimilationTimer", (short)this.biomeAssimilationTimer);
        tag.putInt("ClusterSize", (short)this.clusterSize);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(16, tag.getByte("colour"));
        this.setBiomeAssimilationTimer(tag.getShort("BiomeAssimilationTimer"));
        this.clusterSize = tag.getInteger("ClusterSize");
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)0);
    }

    public void setColour(EnumFireflyColour colour) {
        this.entityData.set(16, (byte)colour.getId());
    }

    public void setBiomeAssimilationTimer(int biomeAssimilationTimer) {
        this.biomeAssimilationTimer = biomeAssimilationTimer;
    }

    public void setClusterSize(int size) {
        this.clusterSize = size;
    }

    public EnumFireflyColour getColour() {
        byte id = this.entityData.getByte(16);
        for (EnumFireflyColour colour : EnumFireflyColour.values()) {
            if (colour.getId() != id) continue;
            return colour;
        }
        return null;
    }

    @Override
    protected void updatePlayerActionState() {
        Biome currentBiome = this.world.getBlockBiome((int)this.x, (int)this.y, (int)this.z);
        if (this.biomeAssimilationTimer-- == 0) {
            EnumFireflyColour newColour = this.getColourForBiome(currentBiome);
            if (newColour != this.getColour()) {
                this.setColour(newColour);
            }
            this.biomeAssimilationTimer = 6000;
        }
    }

    @Override
    public boolean getCanSpawnHere() {
        if (this.world.dimension == Dimension.nether && this.random.nextInt(100) != 0) {
            return false;
        }
        int x = MathHelper.floor_double(this.x);
        int y = MathHelper.floor_double(this.bb.minY);
        int z = MathHelper.floor_double(this.z);
        int id = this.world.getBlockId(x, y - 1, z);
        if (this.world.getSavedLightValue(LightLayer.Block, x, y, z) > 0) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, x, y, z) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(x, y, z);
        if (this.world.currentWeather != null && this.world.currentWeather.doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && Block.blocksList[id] != null && Block.blocksList[id].hasTag(BlockTags.FIREFLIES_CAN_SPAWN) && this.world.checkIfAABBIsClear(this.bb.expand(-2.0, 0.0, -2.0));
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void push(Entity entity) {
    }

    @Override
    public boolean hurt(Entity entity, int i, DamageType type) {
        return false;
    }

    @Override
    protected String getLivingSound() {
        return "";
    }

    @Override
    protected String getHurtSound() {
        return "";
    }

    @Override
    protected String getDeathSound() {
        return "";
    }

    @Override
    public void tick() {
        super.tick();
        float dy = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbHeight;
        float dx = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
        float dz = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
        if (this.random.nextInt(10 - this.clusterSize) == 0) {
            this.world.spawnParticle(this.getColour().getParticleName(), this.x + (double)dx, this.y + (double)dy, this.z + (double)dz, this.xd, this.yd, this.zd, 256.0);
        }
        if (!this.world.getWorldType().hasCeiling() && this.world.isDaytime()) {
            this.remove();
        }
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 1;
    }
}

