/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.fx;

import net.minecraft.client.render.Tessellator;
import net.minecraft.core.entity.fx.EntityFX;
import net.minecraft.core.world.World;

public class EntityReddustFX
extends EntityFX {
    float field_673_a;

    public EntityReddustFX(World world, double d, double d1, double d2, float f, float f1, float f2) {
        this(world, d, d1, d2, 1.0f, f, f1, f2);
    }

    public EntityReddustFX(World world, double d, double d1, double d2, float f, float f1, float f2, float f3) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        if (f1 == 0.0f) {
            f1 = 1.0f;
        }
        float f4 = (float)Math.random() * 0.4f + 0.6f;
        this.particleRed = ((float)(Math.random() * (double)0.2f) + 0.8f) * f1 * f4;
        this.particleGreen = ((float)(Math.random() * (double)0.2f) + 0.8f) * f2 * f4;
        this.particleBlue = ((float)(Math.random() * (double)0.2f) + 0.8f) * f3 * f4;
        this.particleScale *= 0.75f;
        this.particleScale *= f;
        this.field_673_a = this.particleScale;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * f);
        this.noPhysics = false;
    }

    @Override
    public void renderParticle(Tessellator t, float renderPartialTicks, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + renderPartialTicks) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.field_673_a * f6;
        super.renderParticle(t, renderPartialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.particleTextureIndex = 7 - this.particleAge * 8 / this.particleMaxAge;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= (double)0.96f;
        this.yd *= (double)0.96f;
        this.zd *= (double)0.96f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }
}

