/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.projectile;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.HitResult;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;

public class EntityCannonball
extends Entity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    public EntityLiving owner;

    public EntityCannonball(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
    }

    public EntityCannonball(World world, double x, double y, double z) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.setPos(x, y, z);
        this.heightOffset = 0.0f;
    }

    public EntityCannonball(World world, EntityLiving owner) {
        super(world);
        this.owner = owner;
        this.setSize(0.5f, 0.5f);
        this.moveTo(owner.x, owner.y + (double)owner.getHeadHeight(), owner.z, owner.yRot, owner.xRot);
        this.x -= (double)(MathHelper.cos(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.y -= 0.1;
        this.z -= (double)(MathHelper.sin(this.yRot / 180.0f * 3.141593f) * 0.16f);
        this.setPos(this.x, this.y, this.z);
        this.heightOffset = 0.0f;
        this.xd = -MathHelper.sin(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f);
        this.zd = MathHelper.cos(this.yRot / 180.0f * 3.141593f) * MathHelper.cos(this.xRot / 180.0f * 3.141593f);
        this.yd = -MathHelper.sin(this.xRot / 180.0f * 3.141593f);
        this.setCannonballHeading(this.xd, this.yd, this.zd, 1.5f, 1.0f);
    }

    @Override
    protected void init() {
    }

    public void setCannonballHeading(double newMotionX, double newMotionY, double newMotionZ, float speed, float randomness) {
        float velocity = MathHelper.sqrt_double(newMotionX * newMotionX + newMotionY * newMotionY + newMotionZ * newMotionZ);
        newMotionX /= (double)velocity;
        newMotionY /= (double)velocity;
        newMotionZ /= (double)velocity;
        newMotionX += this.random.nextGaussian() * 0.0075 * (double)randomness;
        newMotionY += this.random.nextGaussian() * 0.0075 * (double)randomness;
        newMotionZ += this.random.nextGaussian() * 0.0075 * (double)randomness;
        this.xd = newMotionX *= (double)speed;
        this.yd = newMotionY *= (double)speed;
        this.zd = newMotionZ *= (double)speed;
        float velocityHorizontal = MathHelper.sqrt_double(newMotionX * newMotionX + newMotionZ * newMotionZ);
        this.yRotO = this.yRot = (float)(Math.atan2(newMotionX, newMotionZ) * 180.0 / Math.PI);
        this.xRotO = this.xRot = (float)(Math.atan2(newMotionY, velocityHorizontal) * 180.0 / Math.PI);
    }

    @Override
    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float velocityHorizontal = MathHelper.sqrt_double(xd * xd + zd * zd);
            this.yRotO = this.yRot = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(yd, velocityHorizontal) * 180.0 / Math.PI);
            this.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
        }
    }

    @Override
    public void tick() {
        Vec3d nextPos;
        int id;
        super.tick();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
            this.yRotO = this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
            this.xRotO = this.xRot = (float)(Math.atan2(this.yd, f) * 180.0 / Math.PI);
        }
        if ((id = this.world.getBlockId(this.xTile, this.yTile, this.zTile)) > 0) {
            this.world.newExplosion(this, this.x, this.y, this.z, 1.5f, false, true);
            this.remove();
            return;
        }
        Vec3d currentPos = Vec3d.createVector(this.x, this.y, this.z);
        HitResult hit = this.world.checkBlockCollisionBetweenPoints(currentPos, nextPos = Vec3d.createVector(this.x + this.xd, this.y + this.yd, this.z + this.zd), false, true);
        if (hit != null) {
            this.xTile = hit.x;
            this.yTile = hit.y;
            this.zTile = hit.z;
            this.xd = (float)(hit.location.xCoord - this.x);
            this.yd = (float)(hit.location.yCoord - this.y);
            this.zd = (float)(hit.location.zCoord - this.z);
            float velocity = MathHelper.sqrt_double(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
            this.x -= this.xd / (double)velocity * 0.05;
            this.y -= this.yd / (double)velocity * 0.05;
            this.z -= this.zd / (double)velocity * 0.05;
        }
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        float velocityHorizontal = MathHelper.sqrt_double(this.xd * this.xd + this.zd * this.zd);
        this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / Math.PI);
        this.xRot = (float)(Math.atan2(this.yd, velocityHorizontal) * 180.0 / Math.PI);
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.xRot = this.xRotO + (this.xRot - this.xRotO) * 0.2f;
        this.yRot = this.yRotO + (this.yRot - this.yRotO) * 0.2f;
        float deceleration = 0.88f;
        float gravity = 0.09f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float particleDistance = 0.25f;
                this.world.spawnParticle("bubble", this.x - this.xd * (double)particleDistance, this.y - this.yd * (double)particleDistance, this.z - this.zd * (double)particleDistance, this.xd, this.yd, this.zd);
            }
            deceleration = 0.8f;
        }
        this.world.spawnParticle("largesmoke", this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.xd *= (double)deceleration;
        this.yd *= (double)deceleration;
        this.zd *= (double)deceleration;
        this.yd -= (double)gravity;
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putShort("xTile", (short)this.xTile);
        tag.putShort("xTile", (short)this.xTile);
        tag.putShort("yTile", (short)this.yTile);
        tag.putShort("zTile", (short)this.zTile);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        this.xTile = tag.getShort("xTile");
        this.yTile = tag.getShort("yTile");
        this.zTile = tag.getShort("zTile");
    }

    @Override
    public float getShadowHeightOffs() {
        return 0.0f;
    }
}

