/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumFireflyColour;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class ItemJar
extends Item {
    protected ItemJar(String name, int id) {
        super(name, id);
        this.setMaxStackSize(64);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        List<Entity> list = world.getEntitiesWithinAABBExcludingEntity(entityplayer, entityplayer.bb.expand(2.0, 2.0, 2.0));
        for (Entity e : list) {
            EnumFireflyColour colour;
            if (!(e instanceof EntityFireflyCluster)) continue;
            EntityFireflyCluster entityFireflyCluster = (EntityFireflyCluster)e;
            if (entityFireflyCluster.clusterSize-- <= 0) {
                entityFireflyCluster.remove();
            }
            if ((colour = ((EntityFireflyCluster)e).getColour()) == EnumFireflyColour.BLUE) {
                ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyBlue, 1));
            } else if (colour == EnumFireflyColour.ORANGE) {
                ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyOrange, 1));
            } else if (colour == EnumFireflyColour.RED) {
                ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyRed, 1));
            } else {
                ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyGreen, 1));
            }
            return itemstack;
        }
        return itemstack;
    }

    public static void fillJar(EntityPlayer entityPlayer, ItemStack ItemToGive) {
        if (entityPlayer.inventory.getCurrentItem().stackSize <= 1) {
            entityPlayer.swingItem();
            entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, ItemToGive);
        } else if (entityPlayer.inventory.addItemStackToInventory(ItemToGive)) {
            entityPlayer.swingItem();
            entityPlayer.inventory.getCurrentItem().consumeItem(entityPlayer);
        }
    }
}

