/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.conversion.ChunkConverter;

public final class ItemStack {
    public int stackSize;
    public int animationsToGo;
    public int itemID;
    private int metadata;
    public CompoundTag tag;

    public ItemStack(IItemConvertible item) {
        this(item, 1);
    }

    public ItemStack(IItemConvertible item, int stackSize) {
        this(item, stackSize, 0);
    }

    public ItemStack(IItemConvertible item, int stackSize, int metadata) {
        this(item.asItem(), stackSize, metadata);
    }

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int stackSize) {
        this(block.id, stackSize, 0);
    }

    public ItemStack(Block block, int stackSize, int metadata) {
        this(block.id, stackSize, metadata);
    }

    public ItemStack(Block block, int stackSize, int metadata, CompoundTag tag) {
        this(block.id, stackSize, metadata, tag);
    }

    public ItemStack(Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(Item item, int stackSize) {
        this(item.id, stackSize, 0);
    }

    public ItemStack(Item item, int stackSize, int metadata) {
        this(item.id, stackSize, metadata);
    }

    public ItemStack(Item item, int stackSize, int metadata, CompoundTag tag) {
        this(item.id, stackSize, metadata, tag);
    }

    public ItemStack(int itemID, int stackSize, int metadata) {
        this(itemID, stackSize, metadata, Item.itemsList[itemID].getDefaultTag());
    }

    public ItemStack(ItemStack itemStack) {
        this.itemID = itemStack.itemID;
        this.metadata = itemStack.metadata;
        this.stackSize = itemStack.stackSize;
        this.tag = new CompoundTag(itemStack.tag);
    }

    public ItemStack(int itemID, int stackSize, int metadata, CompoundTag tag) {
        this.itemID = itemID;
        this.stackSize = stackSize;
        this.metadata = metadata;
        this.tag = tag;
    }

    private ItemStack() {
    }

    public ItemStack splitStack(int i) {
        ItemStack itemStack = new ItemStack(this);
        itemStack.stackSize = i;
        this.stackSize -= i;
        return itemStack;
    }

    public Item getItem() {
        return Item.itemsList[this.itemID];
    }

    public int getIconIndex() {
        return this.getItem().getIconIndex(this);
    }

    public boolean useItem(EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        boolean flag = this.getItem().onItemUse(this, entityplayer, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
        return flag;
    }

    public float getStrVsBlock(Block block) {
        return this.getItem().getStrVsBlock(this, block);
    }

    public ItemStack useItemRightClick(World world, EntityPlayer entityplayer) {
        return this.getItem().onItemRightClick(this, world, entityplayer);
    }

    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.putShort("id", (short)this.itemID);
        nbttagcompound.putByte("Count", (byte)this.stackSize);
        nbttagcompound.putShort("Damage", (short)this.metadata);
        nbttagcompound.putByte("Expanded", (byte)1);
        nbttagcompound.putInt("Version", 19134);
        nbttagcompound.putCompound("Data", this.tag);
        return nbttagcompound;
    }

    public void readFromNBT(CompoundTag nbttagcompound) {
        this.itemID = nbttagcompound.getShort("id");
        this.stackSize = nbttagcompound.getByte("Count");
        this.metadata = nbttagcompound.getShort("Damage");
        byte expanded = nbttagcompound.getByte("Expanded");
        int version = nbttagcompound.getInteger("Version");
        if (expanded == 0 && this.itemID >= 256) {
            this.itemID += Block.blocksList.length - 256;
        }
        if (version < 19133 && this.itemID < Block.blocksList.length) {
            short[] id = new short[]{(short)this.itemID};
            byte[] meta = new byte[]{(byte)this.metadata};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id, meta);
            this.itemID = id[0];
            this.metadata = meta[0];
        }
        this.tag = nbttagcompound.getCompound("Data");
        if (this.tag == null) {
            this.tag = Item.itemsList[this.itemID].getDefaultTag();
        }
        if (!this.tag.containsKey("color")) {
            this.tag.putByte("color", (byte)TextFormatting.WHITE.id);
        }
        if (!this.tag.containsKey("name")) {
            this.tag.putString("name", "");
        }
        if (this.getItem() == null) {
            this.itemID = 0;
        }
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit();
    }

    public int getMaxStackSize(IInventory inv) {
        return this.getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return Item.itemsList[this.itemID].getMaxDamage() > 0;
    }

    @Deprecated
    public boolean getHasSubtypes() {
        return Item.itemsList[this.itemID].getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.metadata > 0;
    }

    public int getItemDamageForDisplay() {
        return this.metadata;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public void setMetadata(int i) {
        this.metadata = i;
    }

    public int getMaxDamage() {
        return Item.itemsList[this.itemID].getMaxDamage();
    }

    public void damageItem(int i, Entity entity) {
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).getGamemode().toolDurability) {
            return;
        }
        if (!this.isItemStackDamageable()) {
            return;
        }
        this.metadata += i;
        if (this.metadata > this.getMaxDamage()) {
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).addStat(StatList.breakItemStats[this.itemID], 1);
            }
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.metadata = 0;
        }
    }

    public void repairItem(int i) {
        if (!this.isItemStackDamageable()) {
            return;
        }
        if (this.metadata > this.getMaxDamage()) {
            return;
        }
        this.metadata += i;
    }

    public void hitEntity(EntityLiving entityliving, EntityPlayer entityplayer) {
        boolean flag = Item.itemsList[this.itemID].hitEntity(this, entityliving, entityplayer);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
    }

    public void onDestroyBlock(int id, int x, int y, int z, EntityPlayer entityplayer) {
        boolean flag = Item.itemsList[this.itemID].onBlockDestroyed(this, id, x, y, z, entityplayer);
        if (flag) {
            entityplayer.addStat(StatList.usedItemStats[this.itemID], 1);
        }
    }

    public boolean consumeItem(EntityPlayer entityplayer) {
        if (this.stackSize <= 0) {
            return false;
        }
        if (entityplayer.getGamemode().consumeBlocks) {
            --this.stackSize;
        }
        return true;
    }

    public int getDamageVsEntity(Entity entity) {
        return Item.itemsList[this.itemID].getDamageVsEntity(entity);
    }

    public boolean canHarvestBlock(Block block) {
        return Item.itemsList[this.itemID].canHarvestBlock(block);
    }

    public boolean useItemOnEntity(EntityLiving entityliving, EntityPlayer entityPlayer) {
        return Item.itemsList[this.itemID].useItemOnEntity(this, entityliving, entityPlayer);
    }

    public ItemStack copy() {
        return new ItemStack(this.itemID, this.stackSize, this.metadata, new CompoundTag(this.tag));
    }

    public static boolean areItemStacksEqual(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack == null && itemstack1 == null) {
            return true;
        }
        if (itemstack == null || itemstack1 == null) {
            return false;
        }
        return itemstack.isItemStackEqual(itemstack1);
    }

    private boolean isItemStackEqual(ItemStack itemstack) {
        if (this.stackSize != itemstack.stackSize) {
            return false;
        }
        if (this.itemID != itemstack.itemID) {
            return false;
        }
        return this.metadata == itemstack.metadata;
    }

    public boolean isItemEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.metadata == itemstack.metadata;
    }

    public String getItemName() {
        return Item.itemsList[this.itemID].getLanguageKey(this);
    }

    public String getItemTranslateKey() {
        return this.getItemName() + ".name";
    }

    public static ItemStack copyItemStack(ItemStack itemstack) {
        return itemstack != null ? itemstack.copy() : null;
    }

    public String toString() {
        return this.stackSize + " * " + Item.itemsList[this.itemID].getKey() + ":" + this.metadata;
    }

    public void updateAnimation(World world, Entity entity, int i, boolean flag) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        Item.itemsList[this.itemID].inventoryTick(this, world, entity, i, flag);
    }

    public void onCrafting(World world, EntityPlayer entityplayer) {
        entityplayer.addStat(StatList.craftedItemStats[this.itemID], this.stackSize);
        Item.itemsList[this.itemID].onCraftedBy(this, world, entityplayer);
    }

    public boolean isStackEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.stackSize == itemstack.stackSize && this.metadata == itemstack.metadata;
    }

    public boolean canStackWith(ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        return this.itemID == itemStack.itemID && this.metadata == itemStack.metadata;
    }

    public boolean canItemBeRenamed() {
        return this.getMaxStackSize() == 1 && this.isItemStackDamageable();
    }

    public String getItemNickname() {
        return this.tag.getString("name");
    }

    public byte getNameColor() {
        return this.tag.getByte("color");
    }

    public static ItemStack readItemStackFromNbt(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        ItemStack stack = new ItemStack();
        stack.readFromNBT(nbt);
        if (stack.getItem() == null || stack.stackSize <= 0) {
            return null;
        }
        return stack;
    }

    public void importStack(ItemStack other) {
        if (!other.isStackable()) {
            return;
        }
    }
}

