/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.material;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.util.helper.DamageType;

public class ArmorMaterial {
    public final String name;
    public final int durability;
    public final int renderIndex;
    private Map<DamageType, Float> protection = new HashMap<DamageType, Float>();
    public static final ArmorMaterial leather = new ArmorMaterial("leather", 0, 180);
    public static final ArmorMaterial chainmail = new ArmorMaterial("chainmail", 1, 240);
    public static final ArmorMaterial iron = new ArmorMaterial("iron", 2, 200);
    public static final ArmorMaterial gold = new ArmorMaterial("gold", 4, 120);
    public static final ArmorMaterial diamond = new ArmorMaterial("diamond", 3, 800);
    public static final ArmorMaterial steel = new ArmorMaterial("steel", 5, 1200);

    public ArmorMaterial(String name, int renderIndex, int durability) {
        this.name = name;
        this.renderIndex = renderIndex;
        this.durability = durability;
    }

    public float getProtection(DamageType damageType) {
        if (damageType == null) {
            return 0.0f;
        }
        Float protection = this.protection.get((Object)damageType);
        return protection != null ? protection.floatValue() : 0.0f;
    }

    public static void setProtectionValuePercent(ArmorMaterial material, DamageType damageType, float percent) {
        material.protection.put(damageType, Float.valueOf(percent / 100.0f));
    }

    static {
        ArmorMaterial.setProtectionValuePercent(leather, DamageType.COMBAT, 20.0f);
        ArmorMaterial.setProtectionValuePercent(leather, DamageType.BLAST, 20.0f);
        ArmorMaterial.setProtectionValuePercent(leather, DamageType.FIRE, 20.0f);
        ArmorMaterial.setProtectionValuePercent(leather, DamageType.FALL, 120.0f);
        ArmorMaterial.setProtectionValuePercent(iron, DamageType.COMBAT, 45.0f);
        ArmorMaterial.setProtectionValuePercent(iron, DamageType.BLAST, 45.0f);
        ArmorMaterial.setProtectionValuePercent(iron, DamageType.FIRE, 45.0f);
        ArmorMaterial.setProtectionValuePercent(iron, DamageType.FALL, 45.0f);
        ArmorMaterial.setProtectionValuePercent(chainmail, DamageType.COMBAT, 120.0f);
        ArmorMaterial.setProtectionValuePercent(chainmail, DamageType.BLAST, 35.0f);
        ArmorMaterial.setProtectionValuePercent(chainmail, DamageType.FIRE, 35.0f);
        ArmorMaterial.setProtectionValuePercent(chainmail, DamageType.FALL, 35.0f);
        ArmorMaterial.setProtectionValuePercent(gold, DamageType.COMBAT, 70.0f);
        ArmorMaterial.setProtectionValuePercent(gold, DamageType.BLAST, 70.0f);
        ArmorMaterial.setProtectionValuePercent(gold, DamageType.FIRE, 70.0f);
        ArmorMaterial.setProtectionValuePercent(gold, DamageType.FALL, 70.0f);
        ArmorMaterial.setProtectionValuePercent(diamond, DamageType.COMBAT, 66.0f);
        ArmorMaterial.setProtectionValuePercent(diamond, DamageType.BLAST, 66.0f);
        ArmorMaterial.setProtectionValuePercent(diamond, DamageType.FIRE, 124.0f);
        ArmorMaterial.setProtectionValuePercent(diamond, DamageType.FALL, 66.0f);
        ArmorMaterial.setProtectionValuePercent(steel, DamageType.COMBAT, 55.0f);
        ArmorMaterial.setProtectionValuePercent(steel, DamageType.BLAST, 150.0f);
        ArmorMaterial.setProtectionValuePercent(steel, DamageType.FIRE, 55.0f);
        ArmorMaterial.setProtectionValuePercent(steel, DamageType.FALL, 55.0f);
    }
}

