/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemToolHoe
extends ItemTool {
    public ItemToolHoe(String name, int id, ToolMaterial enumtoolmaterial) {
        super(name, id, 3, enumtoolmaterial, BlockTags.MINEABLE_BY_HOE);
        this.maxStackSize = 1;
        this.setMaxDamage(enumtoolmaterial.getDurability());
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        return block.hasTag(BlockTags.MINEABLE_BY_HOE);
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int i1 = world.getBlockId(blockX, blockY, blockZ);
        int j1 = world.getBlockId(blockX, blockY + 1, blockZ);
        if (side != Side.BOTTOM && j1 == 0 && (i1 == Block.grass.id || i1 == Block.dirt.id || i1 == Block.pathDirt.id || i1 == Block.grassRetro.id || i1 == Block.mud.id)) {
            int meta = 0;
            if (i1 == Block.mud.id) {
                meta = 1;
            }
            Block block = Block.farmlandDirt;
            world.playBlockSoundEffect((float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.dirt, EnumBlockSoundEffectType.MINE);
            if (world.isClientSide) {
                return true;
            }
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, block.id, meta);
            itemstack.damageItem(1, entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, int id, int x, int y, int z, EntityLiving entityliving) {
        if (entityliving != null && !entityliving.world.isClientSide && id == Block.tallgrass.id) {
            if (this.material.isSilkTouch()) {
                entityliving.world.dropItem(x, y, z, new ItemStack(Item.itemsList[id]));
            } else if (entityliving.world.rand.nextInt(5) == 0) {
                entityliving.world.dropItem(x, y, z, new ItemStack(Item.seedsWheat));
            }
            itemstack.damageItem(1, entityliving);
        }
        return super.onBlockDestroyed(itemstack, id, x, y, z, entityliving);
    }
}

