/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.net.SavedServer;

public class SavedServerList {
    private File serverListFile;
    public List<SavedServer> servers = new ArrayList<SavedServer>();

    private SavedServerList() {
    }

    public static SavedServerList readFromFile(File file) {
        SavedServerList serverList = new SavedServerList();
        serverList.serverListFile = file;
        try {
            FileInputStream fileStream = new FileInputStream(file);
            DataInputStream dataStream = new DataInputStream(fileStream);
            CompoundTag tag = new CompoundTag();
            tag.read(dataStream);
            for (Tag<?> subTag : tag.getValues()) {
                if (!(subTag instanceof CompoundTag)) continue;
                serverList.servers.add(SavedServer.readFromTag((CompoundTag)subTag));
            }
            fileStream.close();
        }
        catch (Exception e) {
            return serverList;
        }
        return serverList;
    }

    public void writeToFile() {
        try {
            FileOutputStream fileStream = new FileOutputStream(this.serverListFile);
            DataOutputStream dataStream = new DataOutputStream(fileStream);
            CompoundTag tag = new CompoundTag();
            for (int i = 0; i < this.servers.size(); ++i) {
                this.servers.get(i).writeToTag(tag, i);
            }
            tag.write(dataStream);
            fileStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

