/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.packet.Packet3Chat;
import net.minecraft.core.util.helper.AES;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class ServerPlayerCommandSender
extends PlayerCommandSender {
    public final MinecraftServer server;
    public final EntityPlayerMP player;

    public ServerPlayerCommandSender(MinecraftServer server, EntityPlayerMP player) {
        this.player = player;
        this.server = server;
    }

    @Override
    public boolean isAdmin() {
        return this.server.configManager.isOp(this.player.username);
    }

    @Override
    public void sendMessage(String string) {
        this.player.playerNetServerHandler.sendPacket(new Packet3Chat(string, AES.keyChain.get(this.player.username)));
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    public EntityPlayerMP getPlayerMP() {
        return this.player;
    }

    @Override
    public String getName() {
        return this.player.getDisplayName();
    }
}

