/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class ScoreCommand
extends ServerCommand {
    public ScoreCommand(MinecraftServer server) {
        super(server, "score", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)handler.getPlayer(args[0]);
        if (player == null) {
            return false;
        }
        if (args[1].equalsIgnoreCase("set")) {
            int newScore;
            if (args.length != 3) {
                return false;
            }
            player.score = newScore = Integer.parseInt(args[2]);
            this.server.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Set " + player.getDisplayName() + TextFormatting.WHITE + "'s score to " + player.score);
            handler.sendMessageToPlayer(player, "Your score was set to " + player.score);
            return true;
        }
        if (args[1].equalsIgnoreCase("get")) {
            sender.sendMessage(player.getDisplayName() + "\u00a7f's score is " + player.score);
            return true;
        }
        if (args[1].equalsIgnoreCase("reset")) {
            player.score = 0;
            this.server.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Set " + player.getDisplayName() + TextFormatting.WHITE + "'s score to " + player.score);
            handler.sendMessageToPlayer(player, "Your score was set to " + player.score);
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/score <username> get");
        sender.sendMessage("/score <username> set <value>");
        sender.sendMessage("/score <username> reset");
    }
}

