/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet103SetSlot
extends Packet {
    public int windowId;
    public int itemSlot;
    public ItemStack myItemStack;

    public Packet103SetSlot() {
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleSetSlot(this);
    }

    public Packet103SetSlot(int i, int j, ItemStack itemstack) {
        this.windowId = i;
        this.itemSlot = j;
        this.myItemStack = itemstack != null ? itemstack.copy() : itemstack;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.windowId = dis.readByte();
        this.itemSlot = dis.readShort();
        short word0 = dis.readShort();
        if (word0 >= 0) {
            byte byte0 = dis.readByte();
            short word1 = dis.readShort();
            CompoundTag tag = Packet103SetSlot.readCompressedCompoundTag(dis);
            this.myItemStack = new ItemStack(word0, (int)byte0, (int)word1, tag);
        } else {
            this.myItemStack = null;
        }
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.windowId);
        dos.writeShort(this.itemSlot);
        if (this.myItemStack == null) {
            dos.writeShort(-1);
        } else {
            dos.writeShort(this.myItemStack.itemID);
            dos.writeByte(this.myItemStack.stackSize);
            dos.writeShort(this.myItemStack.getMetadata());
            Packet103SetSlot.writeCompressedCompoundTag(this.myItemStack.tag, dos);
        }
    }

    @Override
    public int getPacketSize() {
        return 8;
    }
}

