/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet141UpdateFlag
extends Packet {
    public int x;
    public int y;
    public int z;
    public byte[] flagColors;
    public ItemStack[] items;
    public String owner;

    public Packet141UpdateFlag() {
    }

    public Packet141UpdateFlag(int x, int y, int z, byte[] flagColors, ItemStack[] items, String owner) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.flagColors = flagColors;
        this.items = items;
        this.owner = owner;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.x = dis.readInt();
        this.y = dis.readShort();
        this.z = dis.readInt();
        this.flagColors = new byte[384];
        dis.readFully(this.flagColors);
        this.items = new ItemStack[3];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = ItemStack.readItemStackFromNbt(Packet141UpdateFlag.readCompressedCompoundTag(dis));
        }
        this.owner = Packet141UpdateFlag.readString(dis, 16);
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.x);
        dos.writeShort(this.y);
        dos.writeInt(this.z);
        dos.write(this.flagColors);
        for (ItemStack item : this.items) {
            if (item == null) {
                dos.writeShort(0);
                continue;
            }
            CompoundTag tag = new CompoundTag();
            item.writeToNBT(tag);
            Packet141UpdateFlag.writeCompressedCompoundTag(tag, dos);
        }
        Packet141UpdateFlag.writeString(this.owner, dos);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleUpdateFlag(this);
    }

    @Override
    public int getPacketSize() {
        return 0;
    }
}

