/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Key;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.AES;

public class Packet3Chat
extends Packet {
    public String message;
    public boolean encrypted;

    public Packet3Chat() {
    }

    public Packet3Chat(String s) {
        if (s.length() > 512) {
            s = s.substring(0, 512);
        }
        this.message = s;
        this.encrypted = false;
    }

    public Packet3Chat(String s, Key AESKey) {
        if (s.length() > 512) {
            s = s.substring(0, 512);
        }
        try {
            this.message = AES.encrypt(s, AESKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.encrypted = true;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.message = Packet3Chat.readString(dis, 1024);
        this.encrypted = dis.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        Packet3Chat.writeString(this.message, dos);
        dos.writeBoolean(this.encrypted);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleChat(this);
    }

    @Override
    public int getPacketSize() {
        return this.message.length();
    }
}

