/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;

public class Packet52MultiBlockChange
extends Packet {
    public int xPosition;
    public int zPosition;
    public short[] coordinateArray;
    public short[] typeArray;
    public byte[] metadataArray;
    public int size;

    public Packet52MultiBlockChange() {
        this.isChunkDataPacket = true;
    }

    public Packet52MultiBlockChange(int x, int z, short[] blocksToUpdate, int numBlocksToUpdate, World world) {
        this.isChunkDataPacket = true;
        this.xPosition = x;
        this.zPosition = z;
        this.size = numBlocksToUpdate;
        this.coordinateArray = new short[numBlocksToUpdate];
        this.typeArray = new short[numBlocksToUpdate];
        this.metadataArray = new byte[numBlocksToUpdate];
        Chunk chunk = world.getChunkFromChunkCoords(x, z);
        for (int i = 0; i < numBlocksToUpdate; ++i) {
            int blockX = blocksToUpdate[i] >> 12 & 0xF;
            int blockY = blocksToUpdate[i] & 0xFF;
            int blockZ = blocksToUpdate[i] >> 8 & 0xF;
            this.coordinateArray[i] = blocksToUpdate[i];
            this.typeArray[i] = (short)chunk.getBlockID(blockX, blockY, blockZ);
            this.metadataArray[i] = (byte)chunk.getBlockMetadata(blockX, blockY, blockZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        int i;
        this.xPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.size = dis.readShort() & 0xFFFF;
        this.coordinateArray = new short[this.size];
        this.typeArray = new short[this.size];
        this.metadataArray = new byte[this.size];
        for (i = 0; i < this.size; ++i) {
            this.coordinateArray[i] = dis.readShort();
        }
        for (i = 0; i < this.size; ++i) {
            this.typeArray[i] = dis.readShort();
        }
        dis.readFully(this.metadataArray);
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        int i;
        dos.writeInt(this.xPosition);
        dos.writeInt(this.zPosition);
        dos.writeShort((short)this.size);
        for (i = 0; i < this.size; ++i) {
            dos.writeShort(this.coordinateArray[i]);
        }
        for (i = 0; i < this.size; ++i) {
            dos.writeShort(this.typeArray[i]);
        }
        dos.write(this.metadataArray);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleMultiBlockChange(this);
    }

    @Override
    public int getPacketSize() {
        return 10 + this.size * 4;
    }
}

