/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotDye;

public class ContainerFlag
extends Container {
    private TileEntityFlag tileEntity;

    public ContainerFlag(IInventory inv, TileEntityFlag flag) {
        this.tileEntity = flag;
        this.addSlot(new SlotDye(flag, 36, 110, 10));
        this.addSlot(new SlotDye(flag, 37, 110, 32));
        this.addSlot(new SlotDye(flag, 38, 110, 54));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot(inv, x + y * 9 + 9, 8 + x * 18, 100 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inv, i, 8 + i * 18, 158));
        }
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= 0 && slot.id <= 2) {
            return this.getSlots(0, 3, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            return this.getSlots(3, 36, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.id < 27) {
                return this.getSlots(3, 27, false);
            }
            return this.getSlots(30, 9, false);
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= 0 && slot.id <= 2) {
            return this.getSlots(3, 36, false);
        }
        return this.getSlots(0, 3, false);
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.tileEntity.canInteractWith(entityplayer);
    }
}

